/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.demo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormatSymbols;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.holidays.DefaultHoliDay;
import net.sf.nachocalendar.holidays.HoliDay;
import net.sf.nachocalendar.holidays.HoliDayCalendarFactory;
import net.sf.nachocalendar.holidays.HoliDayModel;

public class HolidayCalendarDemo
extends JDialog {
    private HoliDayModel model;
    private CalendarPanel cp;
    private DateField datefield;
    private DatePanel setter;
    private DefaultListModel listmodel;
    private boolean[] workingdays = new boolean[]{false, true, true, true, true, true, true};
    private String[] days;
    private ChangeListener cpListener;
    private DefaultListModel listamodel = new DefaultListModel();
    private JButton bAdd;
    private JButton bExit;
    private JButton bGetValue;
    private JButton bGetValues;
    private JButton bLoad;
    private JButton bRefresh;
    private JButton bRemove;
    private JButton bSave;
    private JButton bUpdate;
    private JCheckBox cAntiAliased;
    private JCheckBox cEnabled;
    private JCheckBox cEternal;
    private JCheckBox cFri;
    private JRadioButton cHorizontal;
    private JCheckBox cMon;
    private JRadioButton cMonday;
    private JCheckBox cSat;
    private JRadioButton cScrollDown;
    private JRadioButton cScrollUp;
    private JComboBox cSelection;
    private JCheckBox cShowMoon;
    private JCheckBox cShowToday;
    private JCheckBox cSun;
    private JRadioButton cSunday;
    private JCheckBox cThu;
    private JCheckBox cTue;
    private JRadioButton cVertical;
    private JCheckBox cWed;
    private JRadioButton cYearDown;
    private JRadioButton cYearUp;
    private JList dlista;
    private ButtonGroup firstDayGroup;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JList lista;
    private ButtonGroup orientationGroup;
    private JCheckBox recurrent;
    private JSpinner sPanels;
    private ButtonGroup scrollGroup;
    private JTextField tName;
    private ButtonGroup yearGroup;

    public HolidayCalendarDemo(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.days = symbols.getShortWeekdays();
        for (int i = 1; i < this.days.length; ++i) {
            this.days[i] = this.days[i].substring(0, 1).toUpperCase() + this.days[i].substring(1).toLowerCase();
        }
        this.cp = HoliDayCalendarFactory.createCalendarPanel();
        this.datefield = HoliDayCalendarFactory.createDateField();
        this.setter = HoliDayCalendarFactory.createDatePanel();
        this.setter.setModel(this.cp.getModel());
        this.setter.setRenderer(this.cp.getRenderer());
        this.cp.setMinimalDaysInFirstWeek(4);
        this.listmodel = new DefaultListModel();
        this.initComponents();
        this.dlista.setModel(this.listamodel);
        this.cSelection.setSelectedIndex(2);
        this.lista.setModel(this.listmodel);
        this.model = (HoliDayModel)this.cp.getModel();
        this.getContentPane().add((Component)this.cp, "West");
        this.updateWorking();
        this.createListeners();
        this.cp.addChangeListener(this.cpListener);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void createListeners() {
        this.setter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HolidayCalendarDemo.this.cp.setValues(HolidayCalendarDemo.this.setter.getValues());
            }
        });
    }

    private void initComponents() {
        this.orientationGroup = new ButtonGroup();
        this.scrollGroup = new ButtonGroup();
        this.yearGroup = new ButtonGroup();
        this.firstDayGroup = new ButtonGroup();
        this.jScrollPane2 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        this.jSeparator2 = new JSeparator();
        JLabel jLabel1 = new JLabel();
        this.tName = new JTextField();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.lista = new JList();
        JLabel jLabel2 = new JLabel();
        DateField jPanel3 = this.datefield;
        this.recurrent = new JCheckBox();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.bLoad = new JButton();
        this.bSave = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.cSun = new JCheckBox();
        this.cMon = new JCheckBox();
        this.cTue = new JCheckBox();
        this.cWed = new JCheckBox();
        this.cThu = new JCheckBox();
        this.cFri = new JCheckBox();
        this.cSat = new JCheckBox();
        this.bUpdate = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.cVertical = new JRadioButton();
        this.cHorizontal = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.cScrollUp = new JRadioButton();
        this.cScrollDown = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.cYearUp = new JRadioButton();
        this.cYearDown = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.cSunday = new JRadioButton();
        this.cMonday = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.cSelection = new JComboBox();
        this.cAntiAliased = new JCheckBox();
        this.cEnabled = new JCheckBox();
        this.cEternal = new JCheckBox();
        this.cShowToday = new JCheckBox();
        this.cShowMoon = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.bRefresh = new JButton();
        this.sPanels = new JSpinner(new SpinnerNumberModel(3, 1, 12, 1));
        this.jLabel3 = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.bExit = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        DatePanel jPanel5 = this.setter;
        this.jPanel9 = new JPanel();
        this.bGetValue = new JButton();
        this.bGetValues = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.dlista = new JList();
        FormListener formListener = new FormListener();
        this.setTitle("NachoCalendar Demo");
        this.addWindowListener(formListener);
        jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        jLabel1.setHorizontalAlignment(11);
        jLabel1.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.tName, gridBagConstraints);
        this.lista.addListSelectionListener(formListener);
        jScrollPane3.setViewportView(this.lista);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)jScrollPane3, gridBagConstraints);
        jLabel2.setHorizontalAlignment(11);
        jLabel2.setText("Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)jPanel3, gridBagConstraints);
        this.recurrent.setText("Recurrent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.recurrent, gridBagConstraints);
        this.bAdd.setText("Add");
        this.bAdd.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.bAdd, gridBagConstraints);
        this.bRemove.setText("Remove");
        this.bRemove.setEnabled(false);
        this.bRemove.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.bRemove, gridBagConstraints);
        this.bLoad.setText("Load");
        this.bLoad.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.bLoad, gridBagConstraints);
        this.bSave.setText("Save");
        this.bSave.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel1.add((Component)this.bSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Working Days"));
        this.cSun.setText(this.days[1]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cSun, gridBagConstraints);
        this.cMon.setSelected(true);
        this.cMon.setText(this.days[2]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cMon, gridBagConstraints);
        this.cTue.setSelected(true);
        this.cTue.setText(this.days[3]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cTue, gridBagConstraints);
        this.cWed.setSelected(true);
        this.cWed.setText(this.days[4]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cWed, gridBagConstraints);
        this.cThu.setSelected(true);
        this.cThu.setText(this.days[5]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cThu, gridBagConstraints);
        this.cFri.setSelected(true);
        this.cFri.setText(this.days[6]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cFri, gridBagConstraints);
        this.cSat.setSelected(true);
        this.cSat.setText(this.days[7]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.cSat, gridBagConstraints);
        this.bUpdate.setText("Update");
        this.bUpdate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.bUpdate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(new TitledBorder("Properties"));
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Orientation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel5, gridBagConstraints);
        this.cVertical.setSelected(true);
        this.cVertical.setText("Vertical");
        this.orientationGroup.add(this.cVertical);
        this.cVertical.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cVertical, gridBagConstraints);
        this.cHorizontal.setText("Horizontal");
        this.orientationGroup.add(this.cHorizontal);
        this.cHorizontal.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cHorizontal, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(11);
        this.jLabel6.setText("Scroll Position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel6, gridBagConstraints);
        this.cScrollUp.setSelected(true);
        this.cScrollUp.setText("Up/Left");
        this.scrollGroup.add(this.cScrollUp);
        this.cScrollUp.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cScrollUp, gridBagConstraints);
        this.cScrollDown.setText("Down/Rigth");
        this.scrollGroup.add(this.cScrollDown);
        this.cScrollDown.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cScrollDown, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(11);
        this.jLabel7.setText("Year Position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel7, gridBagConstraints);
        this.cYearUp.setSelected(true);
        this.cYearUp.setText("Up/Left");
        this.yearGroup.add(this.cYearUp);
        this.cYearUp.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cYearUp, gridBagConstraints);
        this.cYearDown.setText("Down/Rigth");
        this.yearGroup.add(this.cYearDown);
        this.cYearDown.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cYearDown, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(11);
        this.jLabel8.setText("FirstDay");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel8, gridBagConstraints);
        this.cSunday.setSelected(true);
        this.cSunday.setText("Sunday");
        this.firstDayGroup.add(this.cSunday);
        this.cSunday.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cSunday, gridBagConstraints);
        this.cMonday.setText("Monday");
        this.firstDayGroup.add(this.cMonday);
        this.cMonday.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cMonday, gridBagConstraints);
        this.jLabel9.setHorizontalAlignment(11);
        this.jLabel9.setText("SelectionMode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel9, gridBagConstraints);
        this.cSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"SingleSelection", "SingleInterval", "MultipleInterval"}));
        this.cSelection.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cSelection, gridBagConstraints);
        this.cAntiAliased.setText("AntiAliased");
        this.cAntiAliased.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.cAntiAliased, gridBagConstraints);
        this.cEnabled.setSelected(true);
        this.cEnabled.setText("Enabled");
        this.cEnabled.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.cEnabled, gridBagConstraints);
        this.cEternal.setSelected(true);
        this.cEternal.setText("Eternal Scroll");
        this.cEternal.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.cEternal, gridBagConstraints);
        this.cShowToday.setText("Show Today");
        this.cShowToday.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.cShowToday, gridBagConstraints);
        this.cShowMoon.setText("Show Moon");
        this.cShowMoon.addItemListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.cShowMoon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.jPanel8, gridBagConstraints);
        this.bRefresh.setText("Update");
        this.bRefresh.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.bRefresh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.sPanels, gridBagConstraints);
        this.jLabel3.setText("Panels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        this.jScrollPane2.setViewportView(jPanel1);
        this.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.bExit.setText("Exit");
        this.bExit.addActionListener(formListener);
        jPanel2.add(this.bExit);
        this.getContentPane().add((Component)jPanel2, "South");
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel4.setText("Set Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel6.add((Component)jPanel5, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.bGetValue.setText("getValue");
        this.bGetValue.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.bGetValue, gridBagConstraints);
        this.bGetValues.setText("getValues");
        this.bGetValues.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel9.add((Component)this.bGetValues, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.jPanel9, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.dlista);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.jScrollPane1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel6, "East");
        this.pack();
    }

    private void cShowMoonItemStateChanged(ItemEvent evt) {
        this.cp.setPrintMoon(this.cShowMoon.isSelected());
        this.datefield.setPrintMoon(this.cShowMoon.isSelected());
        this.setter.setPrintMoon(this.cShowMoon.isSelected());
    }

    private void cShowTodayItemStateChanged(ItemEvent evt) {
        this.cp.setShowToday(this.cShowToday.isSelected());
        this.setter.setShowToday(this.cShowToday.isSelected());
        this.datefield.setShowToday(this.cShowToday.isSelected());
    }

    private void cEternalItemStateChanged(ItemEvent evt) {
        this.cp.setEternalScroll(this.cEternal.isSelected());
    }

    private void bGetValuesActionPerformed(ActionEvent evt) {
        this.listamodel.clear();
        Object[] datos = this.setter.getValues();
        if (datos == null || datos.length < 1) {
            return;
        }
        for (int i = 0; i < datos.length; ++i) {
            this.listamodel.addElement(datos[i]);
        }
    }

    private void bGetValueActionPerformed(ActionEvent evt) {
        this.listamodel.clear();
        Object dato = this.setter.getValue();
        if (dato == null) {
            return;
        }
        this.listamodel.addElement(dato);
    }

    private void cSelectionItemStateChanged(ItemEvent evt) {
        this.cp.setSelectionMode(this.cSelection.getSelectedIndex());
        this.setter.setSelectionMode(this.cSelection.getSelectedIndex());
    }

    private void cAntiAliasedItemStateChanged(ItemEvent evt) {
        this.setter.setAntiAliased(this.cAntiAliased.isSelected());
        this.cp.setAntiAliased(this.cAntiAliased.isSelected());
        this.datefield.setAntiAliased(this.cAntiAliased.isSelected());
    }

    private void cEnabledItemStateChanged(ItemEvent evt) {
        this.setter.setEnabled(this.cEnabled.isSelected());
        this.cp.setEnabled(this.cEnabled.isSelected());
        this.datefield.setEnabled(this.cEnabled.isSelected());
    }

    private void cMondayItemStateChanged(ItemEvent evt) {
        this.setter.setFirstDayOfWeek(2);
        this.cp.setFirstDayOfWeek(2);
        this.datefield.setFirstDayOfWeek(2);
    }

    private void cSundayItemStateChanged(ItemEvent evt) {
        this.setter.setFirstDayOfWeek(1);
        this.cp.setFirstDayOfWeek(1);
        this.datefield.setFirstDayOfWeek(1);
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        int q = ((Number)this.sPanels.getValue()).intValue();
        this.cp.setQuantity(q);
        this.pack();
    }

    private void cYearDownActionPerformed(ActionEvent evt) {
        this.cp.setYearPosition(1);
        this.pack();
    }

    private void cYearUpActionPerformed(ActionEvent evt) {
        this.cp.setYearPosition(0);
        this.pack();
    }

    private void cScrollDownActionPerformed(ActionEvent evt) {
        this.cp.setScrollPosition(1);
        this.pack();
    }

    private void cScrollUpActionPerformed(ActionEvent evt) {
        this.cp.setScrollPosition(0);
        this.pack();
    }

    private void cHorizontalActionPerformed(ActionEvent evt) {
        Container con = this.getContentPane();
        con.remove(this.cp);
        this.cp.setOrientation(0);
        con.add((Component)this.cp, "North");
        this.pack();
    }

    private void cVerticalActionPerformed(ActionEvent evt) {
        Container con = this.getContentPane();
        con.remove(this.cp);
        this.cp.setOrientation(1);
        con.add((Component)this.cp, "West");
        this.pack();
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        this.updateWorking();
    }

    private void bLoadActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int resp = chooser.showOpenDialog(this);
        if (resp != 0) {
            return;
        }
        this.listmodel.clear();
        this.model.clear();
        File f = chooser.getSelectedFile();
        try {
            Object o;
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream is = new ObjectInputStream(fis);
            while ((o = is.readObject()) != null) {
                HoliDay h = (HoliDay)o;
                this.model.addHoliDay(h);
                this.listmodel.addElement(o);
            }
            is.close();
            fis.close();
        }
        catch (EOFException fis) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int resp = chooser.showSaveDialog(this);
        if (resp != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            for (int i = 0; i < this.listmodel.size(); ++i) {
                os.writeObject(this.listmodel.get(i));
            }
            os.flush();
            os.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        HoliDay h = (HoliDay)this.listmodel.remove(this.lista.getSelectedIndex());
        this.model.removeHoliDay(h);
        this.cp.refresh();
        this.setter.refresh();
    }

    private void bAddActionPerformed(ActionEvent evt) {
        DefaultHoliDay h = new DefaultHoliDay();
        h.setName(this.tName.getText());
        h.setDate((Date)this.datefield.getValue());
        h.setRecurrent(this.recurrent.isSelected());
        this.listmodel.addElement(h);
        this.model.addHoliDay(h);
        this.cp.refresh();
        this.setter.refresh();
    }

    private void listaValueChanged(ListSelectionEvent evt) {
        this.bRemove.setEnabled(this.lista.getSelectedIndex() > -1);
    }

    private void bExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    private void updateWorking() {
        this.workingdays[0] = this.cSun.isSelected();
        this.workingdays[1] = this.cMon.isSelected();
        this.workingdays[2] = this.cTue.isSelected();
        this.workingdays[3] = this.cWed.isSelected();
        this.workingdays[4] = this.cThu.isSelected();
        this.workingdays[5] = this.cFri.isSelected();
        this.workingdays[6] = this.cSat.isSelected();
        this.cp.setWorkingdays(this.workingdays);
    }

    private class FormListener
    implements ActionListener,
    ItemListener,
    WindowListener,
    ListSelectionListener {
        private FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == HolidayCalendarDemo.this.bAdd) {
                HolidayCalendarDemo.this.bAddActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bRemove) {
                HolidayCalendarDemo.this.bRemoveActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bLoad) {
                HolidayCalendarDemo.this.bLoadActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bSave) {
                HolidayCalendarDemo.this.bSaveActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bUpdate) {
                HolidayCalendarDemo.this.bUpdateActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cVertical) {
                HolidayCalendarDemo.this.cVerticalActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cHorizontal) {
                HolidayCalendarDemo.this.cHorizontalActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cScrollUp) {
                HolidayCalendarDemo.this.cScrollUpActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cScrollDown) {
                HolidayCalendarDemo.this.cScrollDownActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cYearUp) {
                HolidayCalendarDemo.this.cYearUpActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cYearDown) {
                HolidayCalendarDemo.this.cYearDownActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bRefresh) {
                HolidayCalendarDemo.this.bRefreshActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bExit) {
                HolidayCalendarDemo.this.bExitActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bGetValue) {
                HolidayCalendarDemo.this.bGetValueActionPerformed(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.bGetValues) {
                HolidayCalendarDemo.this.bGetValuesActionPerformed(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == HolidayCalendarDemo.this.cSunday) {
                HolidayCalendarDemo.this.cSundayItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cMonday) {
                HolidayCalendarDemo.this.cMondayItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cSelection) {
                HolidayCalendarDemo.this.cSelectionItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cAntiAliased) {
                HolidayCalendarDemo.this.cAntiAliasedItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cEnabled) {
                HolidayCalendarDemo.this.cEnabledItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cEternal) {
                HolidayCalendarDemo.this.cEternalItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cShowToday) {
                HolidayCalendarDemo.this.cShowTodayItemStateChanged(evt);
            } else if (evt.getSource() == HolidayCalendarDemo.this.cShowMoon) {
                HolidayCalendarDemo.this.cShowMoonItemStateChanged(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == HolidayCalendarDemo.this) {
                HolidayCalendarDemo.this.exitForm(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == HolidayCalendarDemo.this.lista) {
                HolidayCalendarDemo.this.listaValueChanged(evt);
            }
        }
    }
}

