/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.lib.misc;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import ru.infor.lib.misc.SmallButton;

public class TableNavigator
extends JPanel {
    private static final long serialVersionUID = -7731484760583602356L;
    JTable table;
    Object[] curRecord = null;
    int curRow = -1;
    public JButton btnFirst;
    public JButton btnPrev;
    public JButton btnNext;
    public JButton btnLast;
    public JButton btnAdd;
    public JButton btnDelete;
    public JButton btnEdit;
    public JButton btnPost;
    public JButton btnCancel;
    public JButton btnRefresh;

    public TableNavigator(JTable table) {
        this.table = table;
        JToolBar toolBar = new JToolBar();
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        toolBar.setBorderPainted(false);
        this.btnFirst = new SmallButton("", "img/first16x16.png");
        this.btnPrev = new SmallButton("", "img/prev16x16.png");
        this.btnNext = new SmallButton("", "img/next16x16.png");
        this.btnLast = new SmallButton("", "img/last16x16.png");
        this.btnAdd = new SmallButton("", "img/add16x16.png");
        this.btnDelete = new SmallButton("", "img/del16x16.png");
        this.btnEdit = new SmallButton("", "img/edit16x16.png");
        this.btnPost = new SmallButton("", "img/post16x16.png");
        this.btnCancel = new SmallButton("", "img/cancel16x16.png");
        this.btnRefresh = new SmallButton("", "img/refresh16x16.png");
        this.btnFirst.addActionListener(this.btnFirstClick());
        this.btnPrev.addActionListener(this.btnPrevClick());
        this.btnNext.addActionListener(this.btnNextClick());
        this.btnLast.addActionListener(this.btnLastClick());
        this.btnAdd.addActionListener(this.btnAddClick());
        this.btnDelete.addActionListener(this.btnDeleteClick());
        this.btnEdit.addActionListener(this.btnEditClick());
        this.btnPost.addActionListener(this.btnPostClick());
        this.btnCancel.addActionListener(this.btnCancelClick());
        this.btnRefresh.addActionListener(this.btnRefreshClick());
        toolBar.add(this.btnFirst);
        toolBar.add(this.btnPrev);
        toolBar.add(this.btnNext);
        toolBar.add(this.btnLast);
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnDelete);
        toolBar.add(this.btnEdit);
        toolBar.add(this.btnPost);
        toolBar.add(this.btnCancel);
        toolBar.add(this.btnRefresh);
        this.add(toolBar);
    }

    public void rowEditingBegining(int oldRow) {
        this.setCurRow(oldRow);
        for (int i = 0; i < this.curRecord.length; ++i) {
            this.curRecord[i] = this.table.getValueAt(this.curRow, i);
        }
    }

    public void saveCurrentRow(int oldRow) {
        if (this.table.getModel().getRowCount() > 0) {
            this.setCurRecord();
            this.setCurRow(oldRow);
            for (int i = 0; i < this.curRecord.length; ++i) {
                this.curRecord[i] = this.table.getValueAt(this.curRow, i);
            }
        }
    }

    public void selectRow(int oldRow) {
        this.table.setRowSelectionInterval(oldRow, oldRow);
        this.saveCurrentRow(oldRow);
    }

    public void rowEditingCanceled(int oldRow) {
        for (int i = 0; i < this.curRecord.length; ++i) {
            this.table.setValueAt(this.curRecord[i], oldRow, i);
        }
        this.table.updateUI();
    }

    public ActionListener btnRefreshClick() {
        return null;
    }

    public ActionListener btnPostClick() {
        return null;
    }

    public ActionListener btnCancelClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableNavigator.this.table.editingCanceled(null);
                TableNavigator.this.rowEditingCanceled(TableNavigator.this.curRow);
            }
        };
    }

    public ActionListener btnEditClick() {
        return null;
    }

    public ActionListener btnDeleteClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] options = new Object[]{"\u0414\u0430", "\u041d\u0435\u0442"};
                int rez = JOptionPane.showOptionDialog(null, "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c?", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", -1, 3, null, options, options[0]);
                if (rez == 0) {
                    int nr = TableNavigator.this.table.getSelectedRow();
                    ((DefaultTableModel)TableNavigator.this.table.getModel()).removeRow(nr);
                    if (nr > TableNavigator.this.table.getRowCount() - 1) {
                        nr = TableNavigator.this.table.getRowCount() - 1;
                    }
                    TableNavigator.this.selectRow(nr);
                    TableNavigator.this.table.updateUI();
                }
            }
        };
    }

    public ActionListener btnAddClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int nr = TableNavigator.this.table.getSelectedRow();
                TableNavigator.this.setCurRecord();
                TableNavigator.this.curRecord = null;
                ((DefaultTableModel)TableNavigator.this.table.getModel()).insertRow(nr, TableNavigator.this.curRecord);
                TableNavigator.this.selectRow(nr);
            }
        };
    }

    public ActionListener btnFirstClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableNavigator.this.selectRow(0);
            }
        };
    }

    public ActionListener btnPrevClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int nr = TableNavigator.this.table.getSelectedRow() - 1;
                if (nr < 0) {
                    nr = 0;
                }
                TableNavigator.this.selectRow(nr);
            }
        };
    }

    public ActionListener btnNextClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int nr = TableNavigator.this.table.getSelectedRow() + 1;
                if (nr > TableNavigator.this.table.getRowCount() - 1) {
                    nr = TableNavigator.this.table.getRowCount() - 1;
                }
                TableNavigator.this.selectRow(nr);
            }
        };
    }

    public ActionListener btnLastClick() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableNavigator.this.selectRow(TableNavigator.this.table.getRowCount() - 1);
                TableNavigator.this.btnNext.setEnabled(false);
                TableNavigator.this.btnLast.setEnabled(false);
            }
        };
    }

    public void setCurRow(int oldRow) {
        this.curRow = oldRow;
    }

    public void setCurRecord() {
        if (this.curRecord == null) {
            this.curRecord = new Object[this.table.getModel().getColumnCount()];
        }
    }

    public void setVisibleButton(String visi) {
        this.btnFirst.setEnabled(true);
        this.btnPrev.setEnabled(true);
        this.btnNext.setEnabled(true);
        this.btnLast.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnPost.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }
}

