/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.infor.ws.business.vms.directories.WorkDayCalendarWSO;
import ru.infor.ws.business.vms.schedule.template.ScheduleTemplateWSO;
import ru.infor.ws.core.ValidationUtils;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.SearchResultList;
import ru.infor.ws.objects.vms.AbstractScheduleWorkDaySearchCriteria;
import ru.infor.ws.objects.vms.ScheduleTemplateSearchCriteria;
import ru.infor.ws.objects.vms.WorkDayCalendarSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractScheduleWorkDay;
import ru.infor.ws.objects.vms.entities.ConductorScheduleWorkDay;
import ru.infor.ws.objects.vms.entities.DriverScheduleWorkDay;
import ru.infor.ws.objects.vms.entities.ScheduleDayTemplate;
import ru.infor.ws.objects.vms.entities.ScheduleTemplate;
import ru.infor.ws.objects.vms.entities.WorkDayCalendar;

public abstract class AbstractScheduleWorkDayWSO {
    private static final long ONE_DAY_IN_MILLISEC = 86400000L;
    private static final Logger logger = Logger.getLogger(AbstractScheduleWorkDayWSO.class);
    private Map<Date, WorkDayCalendar> daysMap;

    protected List<AbstractScheduleWorkDay> createScheduleWorkDays_noSave(InvocationContext context, AbstractScheduleWorkDaySearchCriteria sc, Class<? extends AbstractScheduleWorkDay> clazz, SearchResultList lastWorkDayList) {
        if (lastWorkDayList.isEmpty()) {
            return Arrays.asList(this.createScheduleDay(clazz, sc.getDateFrom(), null, null));
        }
        AbstractScheduleWorkDay lastWorkDay = (AbstractScheduleWorkDay)((Object)lastWorkDayList.getObjList()[0]);
        if (lastWorkDay == null || lastWorkDay.getTemplate() == null || lastWorkDay.getDay() == null || lastWorkDay.getDay().getIsDeleted() == 1) {
            return Arrays.asList(this.createScheduleDay(clazz, sc.getDateFrom(), null, null));
        }
        ValidationUtils.notNull((Object)((Object)lastWorkDay.getTemplate()), (String)"lastWorkDay.getTemplate can't be null");
        Map<Integer, ScheduleDayTemplate[]> map = this.getScheduleDayTemplateMap(context, lastWorkDay.getTemplate().getNum(), clazz);
        if (map == null || map.isEmpty()) {
            return Arrays.asList(this.createScheduleDay(clazz, sc.getDateFrom(), null, null));
        }
        ArrayList<AbstractScheduleWorkDay> list = new ArrayList<AbstractScheduleWorkDay>();
        Date dateCurr = CommonSearchCriteria.middleOfDay((Date)sc.getDateFrom());
        Date dateLastWork = CommonSearchCriteria.endOfDay((Date)lastWorkDay.getDate());
        Integer dayOfWeek = this.getDayOfWeek(context, dateLastWork, sc);
        ScheduleDayTemplate[] days = map.get(dayOfWeek);
        ValidationUtils.notNull((Object)days, (String)("can't obtain ScheduleDayTemplate[] by dayOfWeek: " + dayOfWeek));
        int currIndex = Arrays.asList(days).indexOf((Object)lastWorkDay.getDay());
        logger.debug((Object)("last working date: " + lastWorkDay.getDate() + ", currIndex: " + currIndex));
        currIndex = (int)((long)currIndex + ((dateCurr.getTime() - dateLastWork.getTime()) / 86400000L + 1L));
        logger.debug((Object)("begining date: " + dateCurr + ", index: " + (currIndex %= days.length)));
        while (dateCurr.compareTo(sc.getDateTill()) <= 0) {
            dayOfWeek = this.getDayOfWeek(context, dateCurr, sc);
            ScheduleDayTemplate[] daysForDateCurr = map.get(dayOfWeek);
            ValidationUtils.notNull((Object)daysForDateCurr, (String)("can't obtain ScheduleDayTemplate[] by dayOfWeek: " + dayOfWeek));
            ScheduleDayTemplate dayTemp = daysForDateCurr[currIndex];
            ScheduleTemplate stTmp = new ScheduleTemplate();
            stTmp.setId(dayTemp.getScheduleTemplateId());
            list.add(this.createScheduleDay(clazz, dateCurr, stTmp, dayTemp));
            dateCurr = this.addDay(dateCurr);
            currIndex = (currIndex + 1) % daysForDateCurr.length;
        }
        return list;
    }

    private Integer getDayOfWeek(InvocationContext context, Date dateCurr, AbstractScheduleWorkDaySearchCriteria sc) {
        WorkDayCalendar day;
        Calendar c = Calendar.getInstance();
        c.setTime(dateCurr);
        Integer res = c.get(7);
        if (this.daysMap == null) {
            this.daysMap = new HashMap<Date, WorkDayCalendar>();
            WorkDayCalendarSearchCriteria cSC = new WorkDayCalendarSearchCriteria();
            cSC.setWorkingDateFrom(sc.getDateFrom());
            cSC.setWorkingDateTill(sc.getDateTill());
            cSC.setCount(Integer.MAX_VALUE);
            SearchResultList list = new WorkDayCalendarWSO().getList(context, cSC);
            if (!list.isEmpty()) {
                Object[] objectArray = list.getObjList();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    WorkDayCalendar day2 = (WorkDayCalendar)((Object)obj);
                    this.daysMap.put(CommonSearchCriteria.middleOfDay((Date)day2.getWorkingDate()), day2);
                    ++n2;
                }
            }
        }
        return (day = this.daysMap.get(CommonSearchCriteria.middleOfDay((Date)dateCurr))) != null ? day.getDayOfWeek() : res;
    }

    private Map<Integer, ScheduleDayTemplate[]> getScheduleDayTemplateMap(InvocationContext context, Integer tempalteNum, Class<? extends AbstractScheduleWorkDay> clazz) {
        ScheduleTemplateSearchCriteria sc = new ScheduleTemplateSearchCriteria();
        sc.setScheduleOwnerType(this.getOwnerType(clazz));
        sc.setNum(tempalteNum);
        ScheduleTemplateWSO scheduleTemplateWS = new ScheduleTemplateWSO();
        SearchResultList list = scheduleTemplateWS.getList(context, sc);
        if (list.isEmpty()) {
            logger.error((Object)("can't locate ScheduleTemplate{tempalteNum = " + tempalteNum + ", scheduleOwnerType = " + this.getOwnerType(clazz) + "}"));
            return null;
        }
        HashMap<Integer, ScheduleDayTemplate[]> res = new HashMap<Integer, ScheduleDayTemplate[]>();
        Object[] objectArray = list.getObjList();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ScheduleTemplate st = (ScheduleTemplate)((Object)obj);
            if ((st = scheduleTemplateWS.getCurrentObject(context, st.getId())).getDayOfWeek() != null) {
                res.put(st.getDayOfWeek(), st.getDays());
            } else {
                int i = 1;
                while (i <= 7) {
                    if (!res.containsKey(i)) {
                        res.put(i, st.getDays());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return res;
    }

    private Integer getOwnerType(Class<? extends AbstractScheduleWorkDay> clazz) {
        if (ConductorScheduleWorkDay.class.equals(clazz)) {
            return 1;
        }
        if (DriverScheduleWorkDay.class.equals(clazz)) {
            return 0;
        }
        return -1;
    }

    private AbstractScheduleWorkDay createScheduleDay(Class<? extends AbstractScheduleWorkDay> clazz, Date dateCurr, ScheduleTemplate template, ScheduleDayTemplate dayTemp) {
        AbstractScheduleWorkDay res = null;
        try {
            res = clazz.newInstance();
        }
        catch (Exception exception) {}
        res.setDate(dateCurr);
        res.setTemplate(template);
        res.setDay(dayTemp);
        return res;
    }

    private Date addDay(Date dateCurr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateCurr);
        calendar.add(6, 1);
        return calendar.getTime();
    }
}

