/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import ru.infor.ws.objects.vms.DeviceScheduleRunInfo;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.RouteScheduleRun;
import ru.infor.ws.objects.vms.entities.TransportStop;

public class CheckPointList
extends ArrayList<Route2CheckPointLink> {
    private static final long serialVersionUID = 7347519380336768844L;
    private static final Logger logger = Logger.getLogger(CheckPointList.class);

    public CheckPointList(Object[] list) {
        super(list.length);
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.add((Route2CheckPointLink)obj);
            ++n2;
        }
        Collections.sort(this, new Comparator<Route2CheckPointLink>(){

            @Override
            public int compare(Route2CheckPointLink o1, Route2CheckPointLink o2) {
                int res = o1.getDirection().compareTo(o2.getDirection());
                if (res != 0) {
                    return res;
                }
                Integer o1Off = o1.getMinOffsetInSec() == null ? 0 : o1.getMinOffsetInSec();
                Integer o2Off = o2.getMinOffsetInSec() == null ? 0 : o2.getMinOffsetInSec();
                return o1Off.compareTo(o2Off);
            }
        });
    }

    public List<Route2CheckPointLink> getSubList(TransportStop first, TransportStop last, Integer direction) {
        return this.getSubList(first, last, direction, 0);
    }

    private boolean checkCPonDayOfWeek(Route2CheckPointLink cp, Integer dayOfWeek) {
        if (new Integer(1).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnSunday());
        }
        if (new Integer(2).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnMonday());
        }
        if (new Integer(3).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnTuesday());
        }
        if (new Integer(4).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnWednesday());
        }
        if (new Integer(5).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnThursday());
        }
        if (new Integer(6).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnFriday());
        }
        if (new Integer(7).equals(dayOfWeek)) {
            return new Integer(1).equals(cp.getCheckOnSaturday());
        }
        return true;
    }

    public List<Route2CheckPointLink> getSubList(TransportStop first, TransportStop last, Integer direction, Integer dayOfWeek) {
        ArrayList<Route2CheckPointLink> res = new ArrayList<Route2CheckPointLink>(this.size());
        if (dayOfWeek == 0) {
            for (Route2CheckPointLink cp : this) {
                if (!direction.equals(cp.getDirection())) continue;
                res.add(cp);
            }
        } else {
            logger.debug((Object)("dayOfWeek: " + dayOfWeek));
            for (Route2CheckPointLink cp : this) {
                if (!direction.equals(cp.getDirection()) || !this.checkCPonDayOfWeek(cp, dayOfWeek)) continue;
                res.add(cp);
            }
        }
        logger.debug(res);
        if (first != null) {
            while (!res.isEmpty()) {
                if (first.equals((Object)((Route2CheckPointLink)res.get(0)).getStop())) break;
                res.remove(0);
            }
        }
        if (last != null) {
            while (!res.isEmpty()) {
                if (last.equals((Object)((Route2CheckPointLink)res.get(res.size() - 1)).getStop())) break;
                res.remove(res.size() - 1);
            }
        }
        return res;
    }

    public Integer getDirection(RouteScheduleRun run) {
        TransportStop last;
        TransportStop first = run.getFirstStop() == null ? run.getSchedule().getFirstStop() : run.getFirstStop();
        TransportStop transportStop = last = run.getLastStop() == null ? run.getSchedule().getLastStop() : run.getLastStop();
        if (first.equals((Object)last)) {
            return DeviceScheduleRunInfo.FORWARD;
        }
        int fIndex_F = this.getStopIndex(first, DeviceScheduleRunInfo.FORWARD);
        int lIndex_F = this.getStopIndex(last, DeviceScheduleRunInfo.FORWARD);
        int fIndex_B = this.getStopIndex(first, DeviceScheduleRunInfo.BACKWARD);
        int lIndex_B = this.getStopIndex(last, DeviceScheduleRunInfo.BACKWARD);
        if (fIndex_B != -1 && lIndex_B != -1 && fIndex_B < lIndex_B) {
            return DeviceScheduleRunInfo.BACKWARD;
        }
        if (fIndex_F != -1 && lIndex_F != -1 && fIndex_F < lIndex_F) {
            return DeviceScheduleRunInfo.FORWARD;
        }
        return DeviceScheduleRunInfo.UNKNOWN;
    }

    private int getStopIndex(TransportStop stop, Integer direction) {
        for (Route2CheckPointLink link : this) {
            if (!direction.equals(link.getDirection()) || !stop.equals((Object)link.getStop())) continue;
            return this.indexOf(link);
        }
        return -1;
    }
}

