/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.business.vms.websocket.objects;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Logger;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import ru.infor.websocket.server.SocketServerFactory;
import ru.infor.ws.business.vms.websocket.NDDataKafkaSocketIntf;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.vms.daemons.AbstractDaemon;

class KafkaSubscriptionConsumer
extends AbstractDaemon {
    private static final Logger logger = Logger.getLogger(KafkaSubscriptionConsumer.class);
    private String sid;
    private KafkaConsumer<String, byte[]> consumer;

    public KafkaSubscriptionConsumer(String sid) {
        this.sid = sid;
        Properties kafkaParams = new Properties();
        kafkaParams.put("group.id", this.getTopicName());
        kafkaParams.put("zookeeper.connect", "192.168.100.116:2181");
        kafkaParams.put("metadata.broker.list", "192.168.100.116:9092");
        kafkaParams.put("bootstrap.servers", "192.168.100.116:9092");
        kafkaParams.put("key.deserializer", StringDeserializer.class.getName());
        kafkaParams.put("value.deserializer", ByteArrayDeserializer.class.getName());
        this.consumer = new KafkaConsumer(kafkaParams);
    }

    public String getTopicName() {
        return "NDData_to_" + this.sid + "_Consumer";
    }

    protected void runInt() {
        ConsumerRecords data = this.consumer.poll(100L);
        logger.debug((Object)("data: " + data + "(" + data.isEmpty() + ")"));
        if (data == null || data.isEmpty()) {
            return;
        }
        LinkedList<NDData> datas = new LinkedList<NDData>();
        for (ConsumerRecord res : data) {
            try {
                MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])((byte[])res.value()));
                unpacker.unpackString();
                NDData d = new NDData();
                d.setCreatedDateTime(new Date(unpacker.unpackLong()));
                int size = unpacker.unpackMapHeader();
                HashMap<Integer, Double> fields = new HashMap<Integer, Double>(size);
                if (size > 0) {
                    int i = 0;
                    while (i < size) {
                        fields.put(unpacker.unpackInt(), unpacker.unpackDouble());
                        ++i;
                    }
                }
                d.setLat((Double)fields.get(0));
                d.setLon((Double)fields.get(1));
                d.setSpeed((Double)fields.get(2));
                d.setDirection((Double)fields.get(3));
                Double alarm = (Double)fields.get(4);
                d.setAlarmDevice(alarm == null ? 0 : alarm.intValue());
                datas.add(d);
            }
            catch (Throwable e) {
                logger.error((Object)("deserialization error: " + e.getMessage()), e);
            }
        }
        logger.debug(datas);
        ((NDDataKafkaSocketIntf)SocketServerFactory.get(NDDataKafkaSocketIntf.class, (String)this.sid)).sendListKafka(datas);
    }

    public synchronized void setStopped(boolean stopped) {
        super.setStopped(stopped);
        if (stopped) {
            this.consumer.close();
        }
    }

    protected long getSleepSec() {
        return 0L;
    }

    public void run() {
        while (!this.consumer.listTopics().keySet().contains(this.getTopicName())) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
        this.consumer.subscribe(Collections.singletonList(this.getTopicName()));
        super.run();
    }
}

