/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.business.vms.websocket.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import ru.infor.db.common.HibernateUtils;
import ru.infor.db.core.UserManagerCr;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.ws.business.events.EventUIWSO;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.ServerInvocationContext;
import ru.infor.ws.objects.events.EventUI;

public class SubscribingOptions_SendEventUI
extends SubscribingOptions<EventUI> {
    private static final Logger logger = Logger.getLogger(SubscribingOptions_SendEventUI.class);
    private static final long serialVersionUID = 560457998560619706L;
    private List<Long> deviceIdList;
    private String messageLike;

    public Collection<EventUI> filter(Collection<EventUI> col) {
        ArrayList<EventUI> datas = new ArrayList<EventUI>(col.size());
        ServerInvocationContext sic = new ServerInvocationContext(new InvocationContext("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0439", ""));
        sic.setSession(HibernateUtils.getSession(null));
        Transaction tr = null;
        try {
            try {
                tr = sic.getSession().beginTransaction();
                sic.setUser(new UserManagerCr(sic).locateByName(sic.getUserName()));
                for (EventUI d : col) {
                    if (this.deviceIdList != null && !this.deviceIdList.isEmpty() && !this.deviceIdList.contains(d.getInitiator()) || this.messageLike != null && !this.messageLike.isEmpty() && (d.getMessage() == null || !d.getMessage().toLowerCase().contains(this.messageLike.toLowerCase()))) continue;
                    if (d.getInitiatorName() == null) {
                        d.setInitiatorName(EventUIWSO.getInitiatorName((InvocationContext)sic, (Long)d.getInitiator(), (Date)d.getEventDate()));
                    }
                    datas.add(d);
                }
                tr.commit();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (tr != null) {
                    tr.rollback();
                }
            }
        }
        finally {
            sic.setSession(null);
        }
        return datas;
    }

    public List<Long> getDeviceIdList() {
        return this.deviceIdList;
    }

    public void setDeviceIdList(List<Long> deviceIdList) {
        this.deviceIdList = deviceIdList;
    }

    public String getMessageLike() {
        return this.messageLike;
    }

    public void setMessageLike(String messageLike) {
        this.messageLike = messageLike;
    }
}

