/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.business.vms.websocket.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.vms.EntityCache;

public class SubscribingOptions_SendListNDData4Route
extends SubscribingOptions<NDData> {
    private static final Logger logger = Logger.getLogger(SubscribingOptions_SendListNDData4Route.class);
    private static final long serialVersionUID = 1030017602537586006L;
    private List<Long> routeIdList;

    public SubscribingOptions_SendListNDData4Route() {
        this.setMethodName("sendList");
        this.setServiceName("RouteWS");
    }

    public Collection<NDData> filter(Collection<NDData> col) {
        if (this.routeIdList == null || this.routeIdList.isEmpty()) {
            return col;
        }
        logger.debug((Object)("routeIdList:" + this.routeIdList.stream().map(id -> id.toString()).collect(Collectors.joining(","))));
        ArrayList<NDData> datas = new ArrayList<NDData>(col.size());
        for (NDData d : col) {
            Long routeId = EntityCache.getInstance().getRouteIdByDeviceId(d.getDeviceId());
            logger.debug((Object)("routeId:" + routeId + " ndd:" + d));
            if (!this.routeIdList.contains(routeId)) continue;
            datas.add(d);
        }
        return datas;
    }

    public List<Long> getRouteIdList() {
        return this.routeIdList;
    }

    public void setRouteIdList(List<Long> routeIdList) {
        this.routeIdList = routeIdList;
    }
}

