/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.draw.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;

@Entity
public class LayerFilter
implements Serializable {
    private static final long serialVersionUID = 5595750949463048780L;
    public static Integer userField = 0;
    public static Integer fixedField = 1;
    public static Integer floatField = 2;
    private Long id;
    private String dataValue;
    private Integer fieldDate;
    private Integer fieldDevice;
    private Date beginDate;
    private Date endDate;
    private Long[] devicesIdList;
    private String devicesIdListStr;

    @Column(length=4000)
    public String getDevicesIdListStr() {
        return this.devicesIdListStr;
    }

    public void setDevicesIdListStr(String devicesIdListStr) {
        this.devicesIdListStr = devicesIdListStr;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(String dataValue) {
        this.dataValue = dataValue;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getFieldDate() {
        return this.fieldDate;
    }

    public void setFieldDate(Integer fieldDate) {
        this.fieldDate = fieldDate;
    }

    public Integer getFieldDevice() {
        return this.fieldDevice;
    }

    public void setFieldDevice(Integer fieldDevice) {
        this.fieldDevice = fieldDevice;
    }

    @Transient
    public Long[] getDevicesIdList() {
        if (this.devicesIdListStr == null) {
            this.devicesIdList = null;
            return null;
        }
        if (this.devicesIdList == null && this.devicesIdListStr != null && !this.devicesIdListStr.trim().isEmpty()) {
            String[] ids = this.devicesIdListStr.replaceAll("[\\[\\]]", "").split(",");
            ArrayList<Long> list = new ArrayList<Long>(ids.length);
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    list.add(Long.valueOf(id));
                }
                catch (Exception exception) {}
                ++n2;
            }
            this.devicesIdList = list.toArray(new Long[list.size()]);
        }
        return this.devicesIdList;
    }

    @Transient
    public void setDevicesIdList(Long[] devicesIdList) {
        this.devicesIdList = devicesIdList;
        this.devicesIdListStr = devicesIdList == null ? null : Arrays.toString((Object[])devicesIdList);
    }

    public NDDataSearchCriteria toSearchCriteria() {
        NDDataSearchCriteria sc = new NDDataSearchCriteria();
        if (fixedField.equals(this.fieldDate)) {
            sc.setCreatedDateTimeFrom(this.beginDate);
            sc.setCreatedDateTimeTill(this.endDate);
        } else if (floatField.equals(this.fieldDate)) {
            if ("HOUR".equals(this.dataValue)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                sc.setCreatedDateTimeTill(c.getTime());
                c.add(10, -1);
                sc.setCreatedDateTimeFrom(c.getTime());
            } else if ("DAY".equals(this.dataValue)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                sc.setCreatedDateTimeTill(c.getTime());
                c.add(5, -1);
                sc.setCreatedDateTimeFrom(c.getTime());
            } else if ("BEFOREDAY".equals(this.dataValue)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                c.add(5, -1);
                c.set(11, 8);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                sc.setCreatedDateTimeTill(c.getTime());
                c.add(5, -1);
                sc.setCreatedDateTimeFrom(c.getTime());
            } else if ("BEFOREWEEK".equals(this.dataValue)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                c.add(5, -1);
                c.set(11, 8);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                sc.setCreatedDateTimeTill(c.getTime());
                c.add(5, -7);
                sc.setCreatedDateTimeFrom(c.getTime());
            } else if ("BEFOREMOUNTH".equals(this.dataValue)) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                c.add(5, -1);
                c.set(11, 8);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                sc.setCreatedDateTimeTill(c.getTime());
                c.add(2, -1);
                sc.setCreatedDateTimeFrom(c.getTime());
            }
        }
        if (fixedField.equals(this.fieldDevice)) {
            sc.setDeviceIdList(this.getDevicesIdList());
        }
        sc.appendSorting(SortObject.getInstance((String)"deviceId", (String)SortObject.DIRECTION_ASC));
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
        return sc;
    }

    public String toString() {
        return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438";
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerFilter)) {
            return false;
        }
        LayerFilter other = (LayerFilter)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

