/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.events;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import ru.infor.common.SysProperties;
import ru.infor.ws.business.core.plugins.PluginsWSO;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.SearchResultList;
import ru.infor.ws.objects.core.PluginsSearchCriteria;
import ru.infor.ws.objects.core.entities.Plugins;

public class DBClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(DBClassLoader.class);
    static String PLUGIN_NAME_COMMON_CLASSES = "\u041e\u0431\u0449\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b";
    private InvocationContext ctx;
    private Long pluginId;
    private Hashtable classes = new Hashtable();

    private DBClassLoader() {
        super(DBClassLoader.class.getClassLoader());
    }

    public DBClassLoader(InvocationContext ctx, Long pluginId) {
        this();
        this.ctx = ctx;
        this.pluginId = pluginId;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    public Class findClass(String className) {
        Class<?> result = null;
        result = (Class<?>)this.classes.get(className);
        if (result != null) {
            logger.info((Object)("Load class from cache " + className));
            return result;
        }
        byte[] classByte = new PluginsWSO().getClassDataOfName(this.ctx, className, this.pluginId);
        if (classByte == null) {
            PluginsSearchCriteria sc = new PluginsSearchCriteria();
            sc.setName(SysProperties.getProperty((String)"plugin.name.common.classes", (String)PLUGIN_NAME_COMMON_CLASSES));
            SearchResultList srP = new PluginsWSO().getPlugins(this.ctx, sc);
            if (!srP.isEmpty()) {
                classByte = new PluginsWSO().getClassDataOfName(this.ctx, className, ((Plugins)srP.getObjList()[0]).getId());
            }
        }
        if (classByte == null) {
            try {
                result = this.getParent().loadClass(className);
                this.classes.put(className, result);
                return result;
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)e.getMessage());
                return null;
            }
        }
        if (classByte.length > 0) {
            logger.info((Object)("Load class from DB " + className));
            result = this.defineClass(className, classByte, 0, classByte.length, null);
            this.classes.put(className, result);
            return result;
        }
        try {
            logger.info((Object)("Try other loader fo " + className));
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] classByte = new PluginsWSO().getClassDataOfName(this.ctx, name, this.pluginId);
        if (classByte != null && classByte.length > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(classByte);
            return inputStream;
        }
        return super.getResourceAsStream(name);
    }
}

