/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.vms;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class BusStopWithTime {
    static String BUS_STOP_NAME = "busstop";
    static String BUSES = "buses";
    static String BUS_ROUTE_NAME = "bus";
    static String BUS_ROUTE_TIME = "time";
    JSONObject busStop;
    JSONArray listTime = new JSONArray();

    public BusStopWithTime() {
        this.busStop = new JSONObject();
        this.busStop.put((Object)BUSES, (Object)this.listTime);
    }

    public BusStopWithTime(String name) {
        this();
        this.setBusStopName(name);
    }

    public void setBusStopName(String name) {
        this.busStop.put((Object)BUS_STOP_NAME, (Object)name);
    }

    public void addBusRouteWithTime(String routeName, String time) {
        this.listTime.add((Object)new BusWithTime(routeName, time));
    }

    public void addBusRouteWithTime(String busName, Date time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        this.addBusRouteWithTime(busName, df.format(time));
    }

    public String toString() {
        return this.busStop.toJSONString();
    }

    public class BusWithTime
    implements JSONAware {
        String busName;
        String time;

        public BusWithTime(String busName, String time) {
            this.busName = busName;
            this.time = time;
        }

        public String toJSONString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{\"").append(BUS_ROUTE_NAME).append("\":\"");
            sb.append(this.busName);
            sb.append("\",\"").append(BUS_ROUTE_TIME).append("\":\"");
            sb.append(this.time);
            sb.append("\"}");
            return sb.toString();
        }
    }
}

