/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.vms;

import java.io.Serializable;
import java.util.Arrays;
import ru.infor.ws.objects.vms.DeviceInfo4GranitPassingCP;

public class DeviceInfo4Granit
implements Serializable {
    private static final long serialVersionUID = -3795743648830393874L;
    private Long deviceId;
    private Integer offsetInSec;
    private String route;
    private String rsTypeD;
    private String shiftTypeD;
    private DeviceInfo4GranitPassingCP[] passingCPList;

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getRsTypeD() {
        return this.rsTypeD;
    }

    public void setRsTypeD(String rsTypeD) {
        this.rsTypeD = rsTypeD;
    }

    public String getShiftTypeD() {
        return this.shiftTypeD;
    }

    public void setShiftTypeD(String shiftTypeD) {
        this.shiftTypeD = shiftTypeD;
    }

    public DeviceInfo4GranitPassingCP[] getPassingCPList() {
        return this.passingCPList;
    }

    public void setPassingCPList(DeviceInfo4GranitPassingCP[] passingCPList) {
        this.passingCPList = passingCPList;
    }

    public String toString() {
        return "DeviceInfo4Granit {deviceId = " + this.deviceId + ", route = " + this.route + ", rsTypeD = " + this.rsTypeD + ", shiftTypeD = " + this.shiftTypeD + ", passingCPList = " + Arrays.toString(this.passingCPList) + "}";
    }

    protected static String format(String src, int lenght) {
        if (src == null) {
            char[] ch = new char[lenght];
            Arrays.fill(ch, ' ');
            return new String(ch);
        }
        if (src.length() > lenght) {
            src = src.substring(0, lenght);
        }
        return String.valueOf(src) + "                    ".substring(src.length(), lenght);
    }

    public String[] toGranit() {
        String offsetInfo = " --";
        if (this.offsetInSec != null) {
            offsetInfo = this.offsetInSec < 0 ? "-" : "+";
            offsetInfo = String.valueOf(offsetInfo) + String.valueOf(this.offsetInSec / 60);
        }
        String[] res = new String[4];
        res[0] = "      " + DeviceInfo4Granit.format(this.route, 4) + " " + DeviceInfo4Granit.format(this.rsTypeD, 2) + "  " + DeviceInfo4Granit.format(this.shiftTypeD, 1) + " " + offsetInfo;
        int i = 1;
        while (i < 4) {
            res[i] = "                    ";
            ++i;
        }
        if (this.passingCPList != null) {
            i = 0;
            while (i < this.passingCPList.length) {
                res[i + 1] = this.passingCPList[i].toGranit();
                ++i;
            }
        }
        return res;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getOffsetInSec() {
        return this.offsetInSec;
    }

    public void setOffsetInSec(Integer offsetInSec) {
        this.offsetInSec = offsetInSec;
    }
}

