/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.vms.entities;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ru.infor.ws.objects.core.entities.LowlevelEntityWithChangerInfo;
import ru.infor.ws.objects.vms.entities.BuildingRegion;
import ru.infor.ws.objects.vms.entities.BuildingState;

@Entity
public class Building
extends LowlevelEntityWithChangerInfo {
    private static final long serialVersionUID = 8885034394561170727L;
    private Long id;
    private String cityName;
    private String houseNumber;
    private String street;
    private String postcode;
    private String linestring;
    private String linestringGJ;
    private Integer levels;
    private Long osmId;
    private Double lat;
    private Double lon;
    private String adress;
    private String okato;
    private BuildingRegion region;
    private String settlement;
    private BuildingState state;

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @Column(length=2048)
    public String getAdress() {
        return this.adress;
    }

    public void setAdress(String adress) {
        this.adress = adress;
    }

    @ManyToOne
    public BuildingRegion getRegion() {
        return this.region;
    }

    public void setRegion(BuildingRegion region) {
        this.region = region;
    }

    public String getSettlement() {
        return this.settlement;
    }

    public void setSettlement(String settlement) {
        this.settlement = settlement;
    }

    public String getOkato() {
        return this.okato;
    }

    public void setOkato(String okato) {
        this.okato = okato;
    }

    @Transient
    public boolean isStored() {
        return this.id != null;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityname) {
        this.cityName = cityname;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String housenumber) {
        this.houseNumber = housenumber;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    @Transient
    public String getLinestring() {
        return this.linestring;
    }

    public void setLinestring(String linestring) {
        this.linestring = linestring;
    }

    @Transient
    public String getLinestringGJ() {
        return this.linestringGJ;
    }

    public void setLinestringGJ(String linestringGJ) {
        this.linestringGJ = linestringGJ;
    }

    public Integer getLevels() {
        return this.levels;
    }

    public void setLevels(Integer levels) {
        this.levels = levels;
    }

    public Long getOsmId() {
        return this.osmId;
    }

    public void setOsmId(Long osmId) {
        this.osmId = osmId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Building)) {
            return false;
        }
        Building other = (Building)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Building {id = " + this.id + ": " + (this.cityName == null ? "" : this.cityName) + ", " + (this.street == null ? "" : this.street) + ", " + (this.houseNumber == null ? "" : this.houseNumber) + "}";
    }

    @ManyToOne
    public BuildingState getState() {
        return this.state;
    }

    public void setState(BuildingState state) {
        this.state = state;
    }
}

