/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.vms.entities;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import ru.infor.ws.objects.analytics.EntityWithAnalytics;
import ru.infor.ws.objects.analytics.entities.Analytic;
import ru.infor.ws.objects.core.entities.LowlevelEntityWithChangerInfo;
import ru.infor.ws.objects.police.entities.FunctionalServices;
import ru.infor.ws.objects.police.entities.PoliceSubdivision;
import ru.infor.ws.objects.vms.entities.BuildingRegion;
import ru.infor.ws.objects.vms.entities.ClassByTotalLength;
import ru.infor.ws.objects.vms.entities.Contractor;
import ru.infor.ws.objects.vms.entities.Crew;
import ru.infor.ws.objects.vms.entities.FuelType;
import ru.infor.ws.objects.vms.entities.ObjectGroup;
import ru.infor.ws.objects.vms.entities.Subdivision;
import ru.infor.ws.objects.vms.entities.Subsystem;
import ru.infor.ws.objects.vms.entities.TransportCategory;
import ru.infor.ws.objects.vms.entities.TransportGroup;
import ru.infor.ws.objects.vms.entities.TransportKind;
import ru.infor.ws.objects.vms.entities.TransportStatus;
import ru.infor.ws.objects.vms.entities.TransportType;
import ru.infor.ws.objects.vms.entities.TypePassengerVehicles;
import ru.infor.ws.objects.vms.entities.TypeTransportation;
import ru.infor.ws.objects.vms.entities.VehicleFleet;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Transport
extends LowlevelEntityWithChangerInfo
implements EntityWithAnalytics {
    private static final long serialVersionUID = 3671739808804890881L;
    private Long id;
    private TransportType transportType;
    private String regNum;
    private String description;
    private TransportGroup group;
    private String garageNum;
    private Subdivision subdivision;
    @Deprecated
    private String codeM;
    private String regNumber;
    private String licCard;
    private String modification;
    private BigDecimal rateFuel100summer;
    private BigDecimal rateFuel100winter;
    private FuelType fuelType;
    private BigDecimal rateFuel100Ssummer;
    private BigDecimal rateFuel100Swinter;
    private FuelType fuelTypeS;
    private Date discardDate;
    private Integer flagOperational;
    private TransportKind transportKind;
    private TransportStatus transportStatus;
    private Date lastUpdateSatus;
    private String codevirt;
    private Contractor owner;
    private ObjectGroup objectGroup;
    private Integer transmitDataToTN = 0;
    private Date lastTransfer;
    private String vinNumber;
    private String yearOfCar;
    private String capacityTS;
    private String registrationNumber;
    private Date registrationDate;
    private String ptsNumber;
    private Date ptsDate;
    private TransportCategory category;
    private TypeTransportation[] transportations;
    private Crew crew;
    private Double minimumLitersForFueling;
    private Double minimumLitersForDraining;
    private TypePassengerVehicles typePassengerVehicles;
    private VehicleFleet park;
    private Integer testReportIssued;
    private Analytic[] analytics;
    private FunctionalServices functionalServices;
    private String phone4SMS;
    private Subsystem subsystem;
    private Contractor relayOperator;
    private Integer relaying;
    private String contractNumber;
    private BuildingRegion region;
    private PoliceSubdivision policeSubdivision;
    private ClassByTotalLength classByTotalLength;
    private Integer transmitDataToYandex = 0;

    @ManyToOne
    public ClassByTotalLength getClassByTotalLength() {
        return this.classByTotalLength;
    }

    public void setClassByTotalLength(ClassByTotalLength classByTotalLength) {
        this.classByTotalLength = classByTotalLength;
    }

    public Integer getTransmitDataToYandex() {
        return this.transmitDataToYandex;
    }

    public void setTransmitDataToYandex(Integer transmitDataToYandex) {
        this.transmitDataToYandex = transmitDataToYandex;
    }

    @ManyToOne
    public PoliceSubdivision getPoliceSubdivision() {
        return this.policeSubdivision;
    }

    public void setPoliceSubdivision(PoliceSubdivision policeSubdivision) {
        this.policeSubdivision = policeSubdivision;
    }

    @ManyToOne
    public BuildingRegion getRegion() {
        return this.region;
    }

    public void setRegion(BuildingRegion region) {
        this.region = region;
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    @ManyToOne
    public Contractor getRelayOperator() {
        return this.relayOperator;
    }

    public void setRelayOperator(Contractor relayOperator) {
        this.relayOperator = relayOperator;
    }

    public Integer getRelaying() {
        return this.relaying;
    }

    public void setRelaying(Integer relaying) {
        this.relaying = relaying;
    }

    @ManyToOne
    public Subsystem getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    public String getPhone4SMS() {
        return this.phone4SMS;
    }

    public void setPhone4SMS(String phone4sms) {
        this.phone4SMS = phone4sms;
    }

    @ManyToOne
    public VehicleFleet getPark() {
        return this.park;
    }

    public void setPark(VehicleFleet park) {
        this.park = park;
    }

    @ManyToOne
    public TypePassengerVehicles getTypePassengerVehicles() {
        return this.typePassengerVehicles;
    }

    public void setTypePassengerVehicles(TypePassengerVehicles typePassengerVehicles) {
        this.typePassengerVehicles = typePassengerVehicles;
    }

    public Double getMinimumLitersForFueling() {
        return this.minimumLitersForFueling;
    }

    public void setMinimumLitersForFueling(Double minimumLitersForFueling) {
        this.minimumLitersForFueling = minimumLitersForFueling;
    }

    public Double getMinimumLitersForDraining() {
        return this.minimumLitersForDraining;
    }

    public void setMinimumLitersForDraining(Double minimumLitersForDraining) {
        this.minimumLitersForDraining = minimumLitersForDraining;
    }

    public Integer getTransmitDataToTN() {
        return this.transmitDataToTN;
    }

    public void setTransmitDataToTN(Integer transmitDataToTN) {
        this.transmitDataToTN = transmitDataToTN;
    }

    public Date getLastTransfer() {
        return this.lastTransfer;
    }

    public void setLastTransfer(Date lastTransfer) {
        this.lastTransfer = lastTransfer;
    }

    @ManyToOne
    public TransportStatus getTransportStatus() {
        return this.transportStatus;
    }

    public void setTransportStatus(TransportStatus transportStatus) {
        this.transportStatus = transportStatus;
    }

    public Date getLastUpdateSatus() {
        return this.lastUpdateSatus;
    }

    public void setLastUpdateSatus(Date lastUpdateSatus) {
        this.lastUpdateSatus = lastUpdateSatus;
    }

    @ManyToOne
    public TransportKind getTransportKind() {
        return this.transportKind;
    }

    public void setTransportKind(TransportKind transportKind) {
        this.transportKind = transportKind;
    }

    public Integer getFlagOperational() {
        return this.flagOperational;
    }

    public void setFlagOperational(Integer flagOperational) {
        this.flagOperational = flagOperational;
    }

    public Date getDiscardDate() {
        return this.discardDate;
    }

    public void setDiscardDate(Date discardDate) {
        this.discardDate = discardDate;
    }

    @Deprecated
    public BigDecimal getRateFuel100() {
        return this.getRateFuel100summer();
    }

    @Deprecated
    public void setRateFuel100(BigDecimal rateFuel100) {
        this.setRateFuel100summer(rateFuel100);
    }

    public String getRegNumber() {
        return this.regNumber;
    }

    public void setRegNumber(String regNumber) {
        this.regNumber = regNumber;
    }

    public String getLicCard() {
        return this.licCard;
    }

    public void setLicCard(String licCard) {
        this.licCard = licCard;
    }

    public String getModification() {
        return this.modification;
    }

    public void setModification(String modification) {
        this.modification = modification;
    }

    @Deprecated
    public String getCodeM() {
        return this.codeM;
    }

    @Deprecated
    public void setCodeM(String codeM) {
        this.codeM = codeM;
    }

    @ManyToOne
    public Subdivision getSubdivision() {
        return this.subdivision;
    }

    public void setSubdivision(Subdivision subdivision) {
        this.subdivision = subdivision;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public boolean isStored() {
        return this.id != null;
    }

    public String getRegNum() {
        return this.regNum;
    }

    public void setRegNum(String regNum) {
        this.regNum = regNum;
    }

    @Column(length=4096000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transport)) {
            return false;
        }
        Transport other = (Transport)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Transport {id = " + this.id + "}";
    }

    @ManyToOne
    public TransportGroup getGroup() {
        return this.group;
    }

    public void setGroup(TransportGroup group) {
        this.group = group;
    }

    public String getGarageNum() {
        return this.garageNum;
    }

    public void setGarageNum(String garageNum) {
        this.garageNum = garageNum;
    }

    @ManyToOne
    public TransportType getTransportType() {
        return this.transportType;
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    @ManyToOne
    public FuelType getFuelType() {
        return this.fuelType;
    }

    public void setFuelType(FuelType fuelTypeF) {
        this.fuelType = fuelTypeF;
    }

    @ManyToOne
    public FuelType getFuelTypeS() {
        return this.fuelTypeS;
    }

    public void setFuelTypeS(FuelType fuelTypeS) {
        this.fuelTypeS = fuelTypeS;
    }

    public BigDecimal getRateFuel100summer() {
        return this.rateFuel100summer;
    }

    public void setRateFuel100summer(BigDecimal rateFuel100summer) {
        this.rateFuel100summer = rateFuel100summer;
    }

    public BigDecimal getRateFuel100winter() {
        return this.rateFuel100winter;
    }

    public void setRateFuel100winter(BigDecimal rateFuel100winter) {
        this.rateFuel100winter = rateFuel100winter;
    }

    public BigDecimal getRateFuel100Ssummer() {
        return this.rateFuel100Ssummer;
    }

    public void setRateFuel100Ssummer(BigDecimal rateFuel100Ssummer) {
        this.rateFuel100Ssummer = rateFuel100Ssummer;
    }

    public BigDecimal getRateFuel100Swinter() {
        return this.rateFuel100Swinter;
    }

    public void setRateFuel100Swinter(BigDecimal rateFuel100Swinter) {
        this.rateFuel100Swinter = rateFuel100Swinter;
    }

    public String getCodevirt() {
        return this.codevirt;
    }

    public void setCodevirt(String codevirt) {
        this.codevirt = codevirt;
    }

    @ManyToOne
    public Contractor getOwner() {
        return this.owner;
    }

    public void setOwner(Contractor owner) {
        this.owner = owner;
    }

    @ManyToOne
    public ObjectGroup getObjectGroup() {
        return this.objectGroup;
    }

    public void setObjectGroup(ObjectGroup objectGroup) {
        this.objectGroup = objectGroup;
    }

    public String getVinNumber() {
        return this.vinNumber;
    }

    public void setVinNumber(String vinNumber) {
        this.vinNumber = vinNumber;
    }

    public String getYearOfCar() {
        return this.yearOfCar;
    }

    public void setYearOfCar(String yearOfCar) {
        this.yearOfCar = yearOfCar;
    }

    public String getCapacityTS() {
        return this.capacityTS;
    }

    public void setCapacityTS(String capacityTS) {
        this.capacityTS = capacityTS;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public String getPtsNumber() {
        return this.ptsNumber;
    }

    public void setPtsNumber(String ptsNumber) {
        this.ptsNumber = ptsNumber;
    }

    public Date getPtsDate() {
        return this.ptsDate;
    }

    public void setPtsDate(Date ptsDate) {
        this.ptsDate = ptsDate;
    }

    @ManyToOne
    public TransportCategory getCategory() {
        return this.category;
    }

    public void setCategory(TransportCategory category) {
        this.category = category;
    }

    @Transient
    public TypeTransportation[] getTransportations() {
        return this.transportations;
    }

    public void setTransportations(TypeTransportation[] transportations) {
        this.transportations = transportations;
    }

    public String readTransportIdentNum() {
        String rez = "";
        if (this.getTransportType() != null && this.getTransportType().getDescription() != null) {
            rez = this.getTransportType().getDescription().trim();
        }
        rez = (this.getRegNum() == null ? "o000oo000" : this.getRegNum()).concat(" ").concat(rez);
        return rez;
    }

    @ManyToOne
    public Crew getCrew() {
        return this.crew;
    }

    public void setCrew(Crew crew) {
        this.crew = crew;
    }

    public Integer getTestReportIssued() {
        return this.testReportIssued;
    }

    public void setTestReportIssued(Integer testReportIssued) {
        this.testReportIssued = testReportIssued;
    }

    @Transient
    public Analytic[] getAnalytics() {
        return this.analytics;
    }

    public void setAnalytics(Analytic[] analytics) {
        this.analytics = analytics;
    }

    @ManyToOne
    public FunctionalServices getFunctionalServices() {
        return this.functionalServices;
    }

    public void setFunctionalServices(FunctionalServices functionalServices) {
        this.functionalServices = functionalServices;
    }
}

