/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography;

import java.util.ArrayList;
import java.util.List;
import org.geotools.referencing.GeodeticCalculator;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;

public class GeoUtils {
    static GeodeticCalculator gc = new GeodeticCalculator();

    public static Geometry buildGeometryFromString(String geom) {
        Object p = null;
        if (geom != null) {
            try {
                p = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : (geom.toLowerCase().indexOf("MULTILINESTRING".toLowerCase()) > -1 ? new MultiLineString(geom) : (geom.toLowerCase().indexOf("LINESTRING".toLowerCase()) > -1 ? new LineString(geom) : new Polygon(geom)));
            }
            catch (Exception exception) {}
        }
        return p;
    }

    public static Double buildLengthFromGeometry(Geometry p) {
        Double mi = 0.0;
        if (p instanceof MultiPolygon) {
            Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Polygon pol = polygonArray[n2];
                mi = mi + GeoUtils.fromPolygon(pol);
                ++n2;
            }
        } else if (p instanceof MultiLineString) {
            LineString[] lineStringArray = ((MultiLineString)p).getLines();
            int n = lineStringArray.length;
            int n3 = 0;
            while (n3 < n) {
                LineString pol = lineStringArray[n3];
                mi = mi + GeoUtils.fromGeometry(pol.getPoints());
                ++n3;
            }
        } else if (p instanceof Polygon) {
            mi = mi + GeoUtils.fromPolygon((Polygon)p);
        } else if (p instanceof LineString) {
            mi = mi + GeoUtils.fromGeometry(((LineString)p).getPoints());
        }
        return mi;
    }

    private static Double fromGeometry(Point[] points) {
        Double mi = 0.0;
        int i = 1;
        while (i < points.length) {
            gc.setStartingGeographicPoint(points[i - 1].getX(), points[i - 1].getY());
            gc.setDestinationGeographicPoint(points[i].getX(), points[i].getY());
            mi = mi + gc.getOrthodromicDistance();
            ++i;
        }
        return mi / 1000.0;
    }

    private static Double fromPolygon(Polygon pol) {
        Double mi = 0.0;
        int i = 0;
        while (i < pol.getDimension()) {
            LinearRing lr = pol.getRing(i);
            mi = mi + GeoUtils.fromGeometry(lr.getPoints());
            ++i;
        }
        return mi;
    }

    public static Point[] getAllPoints(Geometry p) {
        ArrayList<Point> list = new ArrayList<Point>();
        if (p instanceof MultiPolygon) {
            Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Polygon pol = polygonArray[n2];
                list.addAll(GeoUtils.pointsFromPolygon(pol));
                ++n2;
            }
        } else if (p instanceof MultiLineString) {
            LineString[] lineStringArray = ((MultiLineString)p).getLines();
            int n = lineStringArray.length;
            int n3 = 0;
            while (n3 < n) {
                LineString pol = lineStringArray[n3];
                list.addAll(GeoUtils.pointsFromGeometry(pol.getPoints()));
                ++n3;
            }
        } else if (p instanceof Polygon) {
            list.addAll(GeoUtils.pointsFromPolygon((Polygon)p));
        } else if (p instanceof LineString) {
            list.addAll(GeoUtils.pointsFromGeometry(((LineString)p).getPoints()));
        }
        return list.toArray(new Point[list.size()]);
    }

    private static List<Point> pointsFromGeometry(Point[] points) {
        ArrayList<Point> list = new ArrayList<Point>();
        int i = 0;
        while (i < points.length) {
            list.add(points[i]);
            ++i;
        }
        return list;
    }

    private static List<Point> pointsFromPolygon(Polygon pol) {
        ArrayList<Point> list = new ArrayList<Point>();
        int i = 0;
        while (i < pol.getDimension()) {
            LinearRing lr = pol.getRing(i);
            list.addAll(GeoUtils.pointsFromGeometry(lr.getPoints()));
            ++i;
        }
        return list;
    }
}

