/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import ru.blok.cartography.common.ObjectDataSet;
import ru.blok.cartography.josm.JosmMainApp;
import ru.blok.cartography.josm.WMSLayer;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;

public class JosmMainCommon
extends JosmMainApp {
    String layerName;

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public static String getLayerName() {
        return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u0430";
    }

    public JosmMainCommon(JFrame mainFrame, String keyPage) {
        super(mainFrame, keyPage);
    }

    @Override
    protected void initMenu(JMenu sysmenu, String keyPage) {
        JMenuItem mi2 = new JMenuItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ObjectDataSet)ds).save();
            }
        });
        sysmenu.add(mi2);
        super.initMenu(sysmenu, keyPage);
    }

    public static void init(JFrame m, AbstractMapEntry w, String keyPage) {
        JosmMainCommon.initCommon(m);
        main_josm = new JosmMainCommon(m, keyPage);
        JosmMainCommon.initFinal(m);
        Layer current = null;
        Layer osm = null;
        if (main_josm != null) {
            if (JosmMainApp.map != null) {
                if (JosmMainApp.map.mapView != null) {
                    if (JosmMainApp.map.mapView.getAllLayers() != null) {
                        for (Layer layer : JosmMainApp.map.mapView.getAllLayers()) {
                            if (layer.getName().equals(JosmMainCommon.getLayerName())) {
                                current = layer;
                            }
                            if (!(layer instanceof WMSLayer)) continue;
                            osm = layer;
                        }
                    }
                }
            }
        }
        if (current != null) {
            main_josm.removeLayer(current);
        }
        ds = JosmMainCommon.initDS(w, keyPage);
        main_josm.addLayer((Layer)new OsmDataLayer(ds, JosmMainCommon.getLayerName(), null));
        if (osm == null) {
            layer2 = new WMSLayer(keyPage);
            main_josm.addLayer(layer2);
        }
        if (((ObjectDataSet)ds).getOsmPrimitive() != null) {
            main_josm.getCurrentDataSet().setSelected(new PrimitiveId[]{((ObjectDataSet)ds).getOsmPrimitive()});
            OsmPrimitive p = ((ObjectDataSet)ds).getOsmPrimitive();
            if (p instanceof Way) {
                JosmMainApp.map.mapView.zoomTo(((Way)p).getNode(0).getCoor());
            } else if (p instanceof Node) {
                JosmMainApp.map.mapView.zoomTo(((Node)p).getCoor());
            }
        } else {
            Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.workplaceId);
            Node n = new Node(new LatLon(coord[0].doubleValue(), coord[1].doubleValue()));
            ds.addPrimitive((OsmPrimitive)n);
            main_josm.getCurrentDataSet().setSelected(new PrimitiveId[]{n});
        }
    }

    public static DataSet initDS(AbstractMapEntry w, String keyPage) {
        try {
            return new ObjectDataSet(w, keyPage);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

