/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.coordinatemanager;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ru.infor.ws.objects.cartography.entities.CoordinateTransformParameters;

public class CoordinateManager {
    double g = 0.1;
    int n = 10;
    double gz = 7.669903939428206E-4;
    double er = 1.0E-6;
    double e = 1.0E-4;

    public double[] transformFromSk42ToWGS(double[] d) {
        double x = d[0];
        double y = d[1];
        double bet = x / 6367558.4968;
        int n = (int)(y * Math.pow(10.0, -6.0));
        double z0 = (y - (double)(n * 10 + 5) * Math.pow(10.0, 5.0)) / (6378245.0 * Math.cos(bet));
        double z02 = Math.pow(z0, 2.0);
        double b0 = bet + Math.sin(2.0 * bet) * (0.00252588685 - 1.49186E-5 * Math.pow(Math.sin(bet), 2.0) + 1.1904E-7 * Math.pow(Math.sin(bet), 4.0));
        double sinb02 = Math.pow(Math.sin(b0), 2.0);
        double sinb04 = Math.pow(Math.sin(b0), 4.0);
        double sinb06 = Math.pow(Math.sin(b0), 6.0);
        double db = -z02 * Math.sin(2.0 * b0) * (0.251684631 - 0.003369236 * sinb02 + 1.1276E-5 * sinb04 - z02 * (0.10500614 - 0.04559916 * sinb02 + 0.00228901 * sinb04 - 2.987E-5 * sinb06 - z02 * (0.042858 - 0.025318 * sinb02 + 0.014346 * sinb04 - 0.001264 * sinb06 - z02 * (0.01672 - 0.0063 * sinb02 + 0.01188 * sinb04 - 0.00328 * sinb06))));
        double l = z0 * (1.0 - 0.0033467108 * sinb02 - 5.6002E-6 * sinb04 - 1.87E-8 * sinb06 - z02 * (0.16778975 + 0.16273586 * sinb02 - 5.249E-4 * sinb04 - 8.46E-6 * sinb06 - z02 * (0.0420025 + 0.1487407 * sinb02 + 0.005942 * sinb04 - 1.5E-5 * sinb06 - z02 * (0.01225 + 0.09477 * sinb02 + 0.03282 * sinb04 - 0.0034 * sinb06 - z02 * (0.0038 + 0.0524 * sinb02 + 0.0482 * sinb04 + 0.0032 * sinb06)))));
        double B = b0 + db;
        double L = 6.0 * ((double)n - 0.5) / 57.29577951 + l;
        double lat = Math.toDegrees(B);
        double lon = Math.toDegrees(L);
        return new double[]{lat, lon};
    }

    public List<Double[]> transformWGStoMSK(List<Double[]> list, Double[] dd) {
        try {
            DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem flat = CRS.decode((String)"EPSG:2497");
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)wgs84, (CoordinateReferenceSystem)flat);
            GeometryFactory f = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
            ArrayList<Double[]> ret = new ArrayList<Double[]>();
            if (list != null) {
                for (Double[] d : list) {
                    Point p = new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(d[1].doubleValue(), d[0].doubleValue())}), f);
                    Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)math);
                    double x = p2.getCoordinate().y + dd[0];
                    double y = p2.getCoordinate().x + dd[1];
                    double xp = x * Math.cos(dd[2]) - y * Math.sin(dd[2]);
                    double yp = x * Math.sin(dd[2]) + y * Math.cos(dd[2]);
                    ret.add(new Double[]{xp, yp});
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Double[]> transformMSKtoWGS(List<Double[]> list, Double[] dd) {
        try {
            DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem flat = CRS.decode((String)"EPSG:2497");
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)flat, (CoordinateReferenceSystem)wgs84);
            GeometryFactory f = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 2497);
            ArrayList<Double[]> ret = new ArrayList<Double[]>();
            if (list != null) {
                for (Double[] d : list) {
                    double x = d[0];
                    double y = d[1];
                    double xp = x * Math.cos(-dd[2].doubleValue()) - y * Math.sin(-dd[2].doubleValue());
                    double yp = x * Math.sin(-dd[2].doubleValue()) + y * Math.cos(-dd[2].doubleValue());
                    x = xp - dd[0];
                    y = yp - dd[1];
                    Point p = new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(y, x)}), f);
                    Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)math);
                    double lat = p2.getCoordinate().y;
                    double lon = p2.getCoordinate().x;
                    ret.add(new Double[]{lat, lon});
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[] transformMSKtoWGS(double[] coord, CoordinateTransformParameters parameters) {
        if (parameters.getStringWKT() != null && !"".equals(parameters.getStringWKT().trim())) {
            try {
                DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
                CoordinateReferenceSystem flat = CRS.parseWKT((String)parameters.getStringWKT());
                MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)flat, (CoordinateReferenceSystem)wgs84, (boolean)true);
                GeneralDirectPosition pt1 = new GeneralDirectPosition(coord[1], coord[0]);
                DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                return new double[]{pt2.getCoordinate()[1], pt2.getCoordinate()[0]};
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (parameters.getKoofs() != null) {
                return this.transformMSKtoWGS(coord, parameters.getKoofs());
            }
            return this.transformFromSk42ToWGS(coord);
        }
        return coord;
    }

    public double[] transformMSKtoWGS(double[] coord, Double[] dd) {
        try {
            DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem flat = CRS.decode((String)"EPSG:2497");
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)flat, (CoordinateReferenceSystem)wgs84);
            GeometryFactory f = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 2497);
            double x = coord[1];
            double y = coord[0];
            double xp = x * Math.cos(-dd[2].doubleValue()) - y * Math.sin(-dd[2].doubleValue());
            double yp = x * Math.sin(-dd[2].doubleValue()) + y * Math.cos(-dd[2].doubleValue());
            x = xp - dd[0];
            y = yp - dd[1];
            Point p = new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(y, x)}), f);
            Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)math);
            double lat = p2.getCoordinate().y;
            double lon = p2.getCoordinate().x;
            return new double[]{lat, lon};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Double[] getTransformation(List<Double[]> list) {
        try {
            DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem flat = CRS.decode((String)"EPSG:2497");
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)wgs84, (CoordinateReferenceSystem)flat);
            GeometryFactory f = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
            ArrayList<Double[]> l1 = new ArrayList<Double[]>();
            if (list != null) {
                for (Double[] d : list) {
                    Point p = new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(d[1].doubleValue(), d[0].doubleValue())}), f);
                    Point p2 = (Point)JTS.transform((Geometry)p, (MathTransform)math);
                    Double[] dd = new Double[]{p2.getCoordinate().y, p2.getCoordinate().x, d[2], d[3]};
                    l1.add(dd);
                }
            }
            Double[] dd = this.findCoeff(l1);
            System.out.println("find " + dd[0] + " " + dd[1] + " " + dd[2]);
            return dd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected double getP(List<Double[]> list, Double[] dd) {
        double p = 0.0;
        for (Double[] d : list) {
            double x = d[0] + dd[0];
            double y = d[1] + dd[1];
            double xp = x * Math.cos(dd[2]) - y * Math.sin(dd[2]);
            double yp = x * Math.sin(dd[2]) + y * Math.cos(dd[2]);
            p = p + (d[2] - xp) * (d[2] - xp) + (d[3] - yp) * (d[3] - yp);
        }
        return p;
    }

    protected Double getlx(List<Double[]> list, Double[] dd) {
        double a = -this.g;
        double b = this.g;
        Double[] ddt = new Double[]{dd[0], dd[1], dd[2]};
        double pmin = Double.MAX_VALUE;
        double vmin = 0.0;
        double ii = (b - a) / (double)this.n;
        while (ii > this.e) {
            int k = 0;
            int i = 0;
            while (i <= this.n) {
                double z = a + ii * (double)i;
                ddt[0] = dd[0] + z;
                double p = this.getP(list, ddt);
                if (p < pmin) {
                    pmin = p;
                    vmin = z;
                    k = i;
                }
                ++i;
            }
            if (k > 0) {
                a += ii * (double)(k - 1);
            }
            if (k < this.n) {
                b = a + ii * (double)(k + 1);
            }
            ii = (b - a) / (double)this.n;
        }
        return vmin;
    }

    protected double getly(List<Double[]> list, Double[] dd) {
        double a = -this.g;
        double b = this.g;
        Double[] ddt = new Double[]{dd[0], dd[1], dd[2]};
        double pmin = Double.MAX_VALUE;
        double vmin = 0.0;
        double ii = (b - a) / (double)this.n;
        while (ii > this.e) {
            int k = 0;
            int i = 0;
            while (i <= this.n) {
                double z = a + ii * (double)i;
                ddt[1] = dd[1] + z;
                double p = this.getP(list, ddt);
                if (p < pmin) {
                    pmin = p;
                    vmin = z;
                    k = i;
                }
                ++i;
            }
            if (k > 0) {
                a += ii * (double)(k - 1);
            }
            if (k < this.n) {
                b = a + ii * (double)(k + 1);
            }
            ii = (b - a) / (double)this.n;
        }
        return vmin;
    }

    protected double getla(List<Double[]> list, Double[] dd) {
        double a = -this.gz / 2.0;
        double b = this.gz / 2.0;
        Double[] ddt = new Double[]{dd[0], dd[1], dd[2]};
        double pmin = Double.MAX_VALUE;
        double vmin = 0.0;
        double ii = (b - a) / (double)this.n;
        while (ii > this.er) {
            int k = 0;
            int i = 0;
            while (i <= this.n) {
                double z = a + ii * (double)i;
                ddt[2] = dd[2] + z;
                double p = this.getP(list, ddt);
                if (p < pmin) {
                    pmin = p;
                    vmin = z;
                    k = i;
                }
                ++i;
            }
            if (k > 0) {
                a += ii * (double)(k - 1);
            }
            if (k < this.n) {
                b = a + ii * (double)(k + 1);
            }
            ii = (b - a) / (double)this.n;
        }
        return vmin;
    }

    protected Double[] findCoeff(List<Double[]> list) {
        Double[] dd2;
        double ddx = 0.0;
        double ddy = 0.0;
        for (Double[] dd2 : list) {
            double dx = dd2[2] - dd2[0];
            double dy = dd2[3] - dd2[1];
            ddx += dx;
            ddy += dy;
        }
        dd2 = new Double[]{ddx /= (double)list.size(), ddy /= (double)list.size(), 0.0};
        double p = Double.MAX_VALUE;
        double pe = Double.MAX_VALUE;
        while (p > this.e && pe > this.e) {
            double lx = this.getlx(list, dd2);
            dd2[0] = dd2[0] + lx;
            double ly = this.getly(list, dd2);
            dd2[1] = dd2[1] + ly;
            double la = this.getla(list, dd2);
            dd2[2] = dd2[2] + la;
            System.out.println(dd2[0] + " " + dd2[1] + " " + dd2[2]);
            double p1 = this.getP(list, dd2);
            pe = Math.abs(p - p1);
            p = p1;
        }
        return dd2;
    }
}

