/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.core;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import ru.infor.common.SysProperties;

public class Utils {
    static final Logger logger = Logger.getLogger(Utils.class);

    public static String zipFiles(String[] fileS) {
        if (fileS == null || fileS.length == 0) {
            return null;
        }
        File file0 = new File(fileS[0]);
        String fileName = file0.getParent().concat(File.separator).concat(file0.getName()).concat(".zip");
        logger.debug((Object)("zip file name=" + fileName));
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fileName));
            int i = 0;
            while (i < fileS.length) {
                File file = new File(fileS[i]);
                Utils.doZip(file, out);
                ++i;
            }
            out.close();
            return fileName;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void doZip(File dir, ZipOutputStream out) throws IOException {
        logger.debug((Object)("zip file=" + dir.getPath()));
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Utils.doZip(f, out);
                ++n2;
            }
        } else {
            out.putNextEntry(new ZipEntry(dir.getName()));
            Utils.write2Archive(new FileInputStream(dir), out);
        }
    }

    private static void write2Archive(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
    }

    public static String[] unzipFile(String fileS) {
        File file = new File(fileS);
        if (!file.exists() || !file.canRead()) {
            logger.error((Object)("File cannot be read:" + fileS));
            return null;
        }
        ArrayList<String> rez = new ArrayList<String>();
        try {
            ZipFile zip = new ZipFile(fileS);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(file.getParent(), entry.getName()).mkdirs();
                    continue;
                }
                Utils.writeFromArchive(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(file.getParent(), entry.getName()))));
                String re = new File(file.getParent()) + File.separator + entry.getName();
                rez.add(re);
                logger.debug((Object)("unzip file=" + re));
            }
            zip.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rez.toArray(new String[rez.size()]);
    }

    private static void writeFromArchive(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public String readFromFile(String fileName) {
        String DataLine = "";
        try {
            File inFile = new File(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
            DataLine = br.readLine();
            br.close();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        return DataLine;
    }

    public static void loadFileFromInternet(String pathTempFile, String url) {
        logger.debug((Object)("loadFileFromInternet url=" + url));
        FilterInputStream in = null;
        OutputStream fOut = null;
        try {
            try {
                int data;
                URL remoteFile = new URL(url);
                URLConnection fileStream = remoteFile.openConnection();
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String load2StringFromInternet(String url) {
        logger.debug((Object)("load2StringFromInternet url=" + url));
        try {
            String inputLine;
            URL remoteFile = new URL(url);
            URLConnection fileStream = remoteFile.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(fileStream.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            br.close();
            String rez = StringEscapeUtils.unescapeJava((String)response.toString());
            logger.debug((Object)("load2StringFromInternet rez=" + rez));
            return rez;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public static String[] uploadFile2ListFile(String filename) {
        String fileUrl;
        String[] fileList;
        block4: {
            fileList = null;
            String path = SysProperties.getProperty((String)"upload.path", (String)"c:/upload");
            if (path == null) {
                path = File.createTempFile("create", ".xml").getParent();
            }
            if ((fileUrl = String.valueOf(path) + File.separator + filename) != null && !fileUrl.trim().equals("")) break block4;
            return null;
        }
        try {
            fileList = filename.indexOf(".zip") > -1 ? Utils.unzipFile(fileUrl) : new String[]{fileUrl};
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fileList;
    }

    public static void main(String[] args) {
        String[] fileS = new String[2];
        fileS = Utils.unzipFile("c:/3/XMLExport_04032016_s.xml.zip");
        System.out.println(fileS[0]);
    }
}

