/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportdata;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class ExportMifMid {
    static WayWSProxy pWayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    static NodeWSProxy nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    List<String> text = new ArrayList<String>();

    private static void putWay(Way w, List<String> colums, PrintWriter mid, PrintWriter mif, boolean p) {
        int n;
        int n2;
        Tag[] tagArray;
        if (w.getNodes() == null) {
            w = pWayWSProxy.getCurrentObject(InitializedVariable.context, w.getId());
        }
        StringBuilder st = new StringBuilder();
        block0: for (String s : colums) {
            if ("id_navigation_map".equals(s)) {
                st.append(w.getId());
                continue;
            }
            if (st.length() > 0) {
                st.append(";");
            }
            tagArray = w.getTags();
            n2 = tagArray.length;
            n = 0;
            while (n < n2) {
                Tag t = tagArray[n];
                if (s.equals(t.getKey())) {
                    st.append('\"').append(t.getValue()).append('\"');
                    continue block0;
                }
                ++n;
            }
        }
        mid.println(st.toString());
        Node n1 = w.getNodes()[0];
        Node n22 = w.getNodes()[w.getNodes().length - 1];
        if (n1.equals((Object)n22) || n1.getLat() == n22.getLat() && n1.getLon() == n22.getLon()) {
            mif.println("Region  1");
            mif.println(w.getNodes().length);
        } else {
            mif.println("Pline " + w.getNodes().length);
        }
        tagArray = w.getNodes();
        n2 = tagArray.length;
        n = 0;
        while (n < n2) {
            Tag n3 = tagArray[n];
            mif.println(String.valueOf(n3.getLon()) + " " + n3.getLat());
            ++n;
        }
    }

    private static void putNode(Node n, List<String> colums, PrintWriter mid, PrintWriter mif, boolean p) {
        n = nodeWSProxy.getCurrentObject(InitializedVariable.context, n.getId());
        StringBuilder st = new StringBuilder();
        block0: for (String s : colums) {
            if ("id_navigation_map".equals(s)) {
                st.append(n.getId());
                continue;
            }
            if (st.length() > 0) {
                st.append(";");
            }
            Tag[] tagArray = n.getTags();
            int n2 = tagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Tag t = tagArray[n3];
                if (s.equals(t.getKey())) {
                    st.append('\"').append(t.getValue()).append('\"');
                    continue block0;
                }
                ++n3;
            }
        }
        mid.println(st.toString());
        mif.println("Point " + n.getLon() + " " + n.getLat());
    }

    public static PrintWriter[] InitMifMid(String nameFile, String encode) {
        try {
            PrintWriter mif = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MIF").getAbsoluteFile()), encode));
            PrintWriter mid = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MID").getAbsoluteFile()), encode));
            mif.println("Version 300");
            mif.println("Charset \"WindowsCyrillic\"");
            mif.println("Delimiter \";\"");
            mif.println("CoordSys Earth Projection 1,0");
            return new PrintWriter[]{mif, mid};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> InitColumn(PrintWriter mif, PrintWriter mid, AbstractMapEntry w, String[] addColumn) {
        Integer c = w.getTags().length + 1;
        if (addColumn != null) {
            c = c + addColumn.length;
        }
        ArrayList<String> colums = new ArrayList<String>();
        colums.add("id_navigation_map");
        Object[] objectArray = w.getTags();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tag t = objectArray[n2];
            colums.add(t.getKey());
            ++n2;
        }
        if (addColumn != null) {
            objectArray = addColumn;
            n = addColumn.length;
            n2 = 0;
            while (n2 < n) {
                Tag s = objectArray[n2];
                if (!colums.contains(s)) {
                    colums.add((String)s);
                }
                ++n2;
            }
        }
        mif.println("Columns " + colums.size());
        mif.println("id_navigation_map Integer");
        int i = 1;
        while (i < colums.size()) {
            mif.println(String.valueOf((String)colums.get(i)) + " Char(255)");
            ++i;
        }
        mif.println("Data");
        return colums;
    }

    public static List<String> InitColumnP(PrintWriter mif, PrintWriter mid) {
        ArrayList<String> colums = new ArrayList<String>();
        colums.add("LayerName");
        colums.add("LayerNumber");
        colums.add("ObjectName");
        colums.add("ObjectCode");
        colums.add("ObjectNumber");
        colums.add("ObjectLocal");
        colums.add("ObjectKey");
        colums.add("SEM90");
        colums.add("SEM15");
        colums.add("SEM3");
        colums.add("SEM84");
        mif.println("Columns " + colums.size());
        mif.println("LayerName Char(32)");
        mif.println("LayerNumber Integer");
        mif.println("ObjectName Char(32)");
        mif.println("ObjectCode Char(32)");
        mif.println("ObjectNumber Integer");
        mif.println("ObjectLocal Char(32)");
        mif.println("ObjectKey Char(32)");
        mif.println("SEM90 Char(32)");
        mif.println("SEM15 Char(32)");
        mif.println("SEM3 Char(32)");
        mif.println("SEM84 Char(32)");
        mif.println("Data");
        return colums;
    }

    public static void exportMifMid(Object[] ways, String nameFile, String encode, String[] addColumn, Object[] nodes) {
        if (ways != null && ways.length > 0) {
            PrintWriter[] mm = ExportMifMid.InitMifMid(nameFile, encode);
            PrintWriter mif = mm[0];
            PrintWriter mid = mm[1];
            try {
                Way w = pWayWSProxy.getCurrentObject(InitializedVariable.context, ((Way)ways[0]).getId());
                List<String> colums = ExportMifMid.InitColumn(mif, mid, (AbstractMapEntry)w, addColumn);
                Object[] objectArray = ways;
                int n = ways.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ww = objectArray[n2];
                    ExportMifMid.putWay((Way)ww, colums, mid, mif, false);
                    ++n2;
                }
                objectArray = nodes;
                n = nodes.length;
                n2 = 0;
                while (n2 < n) {
                    Object nn = objectArray[n2];
                    ExportMifMid.putNode((Node)nn, colums, mid, mif, false);
                    ++n2;
                }
                mif.close();
                mid.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void exportMifMid(ObjectUIList<Way> ways, String nameFile, String encode, String[] addColumn) {
        ExportMifMid.exportMifMid(ways, nameFile, encode, addColumn, null, false);
    }

    public static void exportMifMid(ObjectUIList<Way> ways, String nameFile, String encode, String[] addColumn, ObjectUIList<Node> nodes, boolean panorama) {
        PrintWriter[] mm = ExportMifMid.InitMifMid(nameFile, encode);
        PrintWriter mif = mm[0];
        PrintWriter mid = mm[1];
        List<String> colums = null;
        if (panorama) {
            colums = ExportMifMid.InitColumnP(mif, mid);
        } else if (ways != null && ways.size() > 0) {
            Way w = (Way)ways.get(0);
            w = pWayWSProxy.getCurrentObject(InitializedVariable.context, w.getId());
            colums = ExportMifMid.InitColumn(mif, mid, (AbstractMapEntry)w, addColumn);
        } else if (nodes != null && nodes.size() > 0) {
            Node n = (Node)nodes.get(0);
            n = nodeWSProxy.getCurrentObject(InitializedVariable.context, n.getId());
            colums = ExportMifMid.InitColumn(mif, mid, (AbstractMapEntry)n, addColumn);
        }
        if (colums != null) {
            if (ways != null) {
                for (Object ww : ways) {
                    ExportMifMid.putWay((Way)ww, colums, mid, mif, panorama);
                }
            }
            if (nodes != null) {
                for (Object nn : nodes) {
                    ExportMifMid.putNode((Node)nn, colums, mid, mif, panorama);
                }
            }
        }
        mif.close();
        mid.close();
    }

    public static void exportMifMid(Object[] ways, String nameFile, String encode, String[] addColumn) {
        ExportMifMid.exportMifMid(ways, nameFile, encode, addColumn, null);
    }
}

