/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.blok.cartography.exportimport.ColumnTag;
import ru.blok.cartography.exportimport.CommonManager;
import ru.blok.cartography.exportimport.ExportImport;
import ru.blok.cartography.exportimport.ObjectGeom;
import ru.blok.cartography.exportimport.mifmid.MifMidDataReared;
import ru.blok.cartography.exportimport.shp.SHPReader;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;

public abstract class CommonReader {
    static Logger logger = Logger.getLogger(CommonReader.class);
    String keyPage;
    CommonManager cm;

    public static CommonReader getInstanse(String type, String fileName, String encode, String keyPage) {
        CommonReader cr = null;
        if (ExportImport.mifmid.equals(type)) {
            try {
                cr = new MifMidDataReared(fileName, encode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (ExportImport.shp.equals(type)) {
            cr = new SHPReader(fileName, encode);
        }
        if (cr != null) {
            cr.keyPage = keyPage;
            cr.cm = new CommonManager(keyPage);
            return cr;
        }
        return null;
    }

    public abstract List<ColumnTag> getColumnTags();

    protected String getValueByNameFile(ColumnTag ct, List<Tag> tagsFromFile) {
        if (ct.getValue() != null && !"".equals(ct.getValue())) {
            return ct.getValue();
        }
        if (tagsFromFile == null || tagsFromFile.size() == 0) {
            return "";
        }
        for (Tag t : tagsFromFile) {
            if (!t.getKey().equals(ct.getNameFile())) continue;
            return t.getValue();
        }
        return "";
    }

    public void setProperty(List<Tag> tagsFromFile, AbstractMapEntry entry) {
        List<ColumnTag> columnTags = this.getColumnTags();
        ArrayList<Tag> lw = new ArrayList<Tag>();
        int i = 0;
        while (i < columnTags.size()) {
            Long lId;
            String value = this.getValueByNameFile(columnTags.get(i), tagsFromFile);
            if (columnTags.get(i).isIdInNK()) {
                lId = Long.parseLong(value);
                entry.setId(lId);
            }
            if (columnTags.get(i).isIdObject()) {
                lId = Long.parseLong(value);
                entry.setObjectid(lId);
            }
            if (columnTags.get(i).isIdDs()) {
                lId = Long.parseLong(value);
                entry.setDatasourceid(lId);
            }
            if (columnTags.get(i).isAddProp() && (!"".equals(value) || columnTags.get(i).isAddEmpty())) {
                Tag wt = new Tag();
                wt.setKey(columnTags.get(i).getNameNK());
                wt.setValue(value);
                lw.add(wt);
            }
            ++i;
        }
        entry.setTags(lw.toArray(new Tag[0]));
    }

    public abstract ObjectGeom getNextGeom() throws IOException;

    public int runImport() {
        int i = 0;
        try {
            ObjectGeom h;
            while ((h = this.getNextGeom()) != null) {
                this.cm.putObjectGeom(h);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return i;
    }

    public void runImport(final ExportImport ei, final PanelContext pc, final String nameLabel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                pc.getPanel().getPresentatorForName("runImport").getViewer().setEditable(false);
                int i = 0;
                try {
                    ObjectGeom h;
                    while ((h = CommonReader.this.getNextGeom()) != null) {
                        CommonReader.this.cm.putObjectGeom(h);
                        CommonReader.this.loggingGeom(h, ++i);
                        ei.setTextImport(Integer.toString(i));
                        pc.getPanel().updateUIForPresentatorName(nameLabel);
                    }
                    ei.setTextImport(String.valueOf(Integer.toString(i)) + " \u0418\u043c\u043f\u043e\u0440\u0442 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f");
                    pc.getPanel().updateUIForPresentatorName(nameLabel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                pc.getPanel().getPresentatorForName("runImport").getViewer().setEditable(true);
            }
        }).start();
    }

    private void loggingGeom(ObjectGeom h, int i) {
        String rez = String.valueOf(i);
        if (h.getValues() == null || h.getValues().size() == 0) {
            logger.info((Object)rez);
        }
        String objId = null;
        String objName = null;
        int j = 0;
        while (j < h.getValues().size()) {
            Tag t = h.getValues().get(j);
            if (t.getKey().equals("osm_id")) {
                objId = t.getValue();
            }
            if (t.getKey().equals("name")) {
                objName = t.getValue();
            }
            ++j;
        }
        rez = " i=" + rez + " -> " + (objName == null ? (objId == null ? rez : objId) : objName);
        logger.info((Object)rez);
    }
}

