/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.blok.cartography.exportimport.ColumnTag;
import ru.blok.cartography.exportimport.ExportImport;
import ru.blok.cartography.exportimport.mifmid.MifMidDataWriter;
import ru.blok.cartography.exportimport.shp.SHPWriter;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.cartography.NodeSearchCriteria;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;
import ru.infor.ws.objects.core.SortObject;

public abstract class CommonWriter {
    protected String keyPage;
    WaySearchCriteria waySearchCriteria;
    NodeSearchCriteria nodeSearchCriteria;
    private boolean exportWays;
    private boolean exportNodes;
    String fileName;
    String encode;
    public WayWSProxy pWayWSProxy;
    public NodeWSProxy nodeWSProxy;
    List<ColumnTag> list;
    PanelContext pc;
    String nameLabel;
    ExportImport ei;
    Integer count = 0;

    public static CommonWriter getInstanse(String type, String fileName, String encode, String keyPage) {
        CommonWriter cw = null;
        if (ExportImport.mifmid.equals(type)) {
            cw = new MifMidDataWriter();
        }
        if (ExportImport.shp.equals(type)) {
            cw = new SHPWriter();
        }
        cw.keyPage = keyPage;
        cw.setEncode(encode);
        cw.setFileName(fileName);
        cw.pWayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class, (String)keyPage);
        cw.nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class, (String)keyPage);
        return cw;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public boolean isExportWays() {
        return this.exportWays;
    }

    public void setExportWays(boolean exportWays) {
        this.exportWays = exportWays;
    }

    public boolean isExportNodes() {
        return this.exportNodes;
    }

    public void setExportNodes(boolean exportNodes) {
        this.exportNodes = exportNodes;
    }

    public WaySearchCriteria getWaySearchCriteria() {
        return this.waySearchCriteria;
    }

    public void setWaySearchCriteria(WaySearchCriteria waySearchCriteria) {
        this.waySearchCriteria = waySearchCriteria;
    }

    public NodeSearchCriteria getNodeSearchCriteria() {
        return this.nodeSearchCriteria;
    }

    public void setNodeSearchCriteria(NodeSearchCriteria nodeSearchCriteria) {
        this.nodeSearchCriteria = nodeSearchCriteria;
    }

    public List<ColumnTag> getColumnTags() {
        return this.list;
    }

    public void prepareData() {
        String s;
        int n;
        int n2;
        String[] stringArray;
        HashMap<String, ColumnTag> maps = new HashMap<String, ColumnTag>();
        ColumnTag ct = new ColumnTag("Id_navigation_map", "Id_navigation_map");
        ct.setType(ColumnTag.NUMBER);
        ct.setIdInNK(true);
        maps.put(ct.getNameNK(), ct);
        ct = new ColumnTag("objectId", "objectId");
        ct.setType(ColumnTag.NUMBER);
        ct.setIdObject(true);
        maps.put(ct.getNameNK(), ct);
        ct = new ColumnTag("dataSourceId", "dataSourceId");
        ct.setType(ColumnTag.NUMBER);
        ct.setIdDs(true);
        maps.put(ct.getNameNK(), ct);
        if (this.exportWays) {
            String[] ss;
            stringArray = ss = this.pWayWSProxy.getUniqueTagKeys(InitializedVariable.getContext((String)this.keyPage), this.waySearchCriteria);
            n2 = ss.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (!maps.containsKey(s)) {
                    ct = new ColumnTag(s, s);
                    ct.setType(ColumnTag.TEXT);
                    maps.put(ct.getNameNK(), ct);
                }
                ++n;
            }
        }
        if (this.exportNodes) {
            this.nodeSearchCriteria.setLoadSingleNodesOnly(Integer.valueOf(1));
            String[] ss1 = this.nodeWSProxy.getUniqueTagKeys(InitializedVariable.getContext((String)this.keyPage), this.nodeSearchCriteria);
            stringArray = ss1;
            n2 = ss1.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (!maps.containsKey(s)) {
                    ct = new ColumnTag(s, s);
                    ct.setType(ColumnTag.TEXT);
                    maps.put(ct.getNameNK(), ct);
                }
                ++n;
            }
        }
        this.list = new ArrayList<ColumnTag>();
        for (Map.Entry e : maps.entrySet()) {
            this.list.add((ColumnTag)e.getValue());
        }
    }

    public abstract void exportData(ObjectUIList<Way> var1, ObjectUIList<Node> var2);

    public int runExport() {
        ObjectUIList lw = null;
        ObjectUIList ln = null;
        Integer count = 0;
        this.waySearchCriteria.appendSorting(SortObject.getInstance((String)"id", (String)SortObject.DIRECTION_ASC));
        this.nodeSearchCriteria.appendSorting(SortObject.getInstance((String)"id", (String)SortObject.DIRECTION_ASC));
        if (this.exportWays) {
            lw = new ObjectUIList(Way.class, this.keyPage);
            lw.setSearchCriteria((CommonSearchCriteria)this.waySearchCriteria);
            count = count + lw.size();
        }
        if (this.exportNodes) {
            ln = new ObjectUIList(Node.class, this.keyPage);
            ln.setSearchCriteria((CommonSearchCriteria)this.nodeSearchCriteria);
            count = count + ln.size();
        }
        this.exportData((ObjectUIList<Way>)lw, ln);
        return count;
    }

    public void runExport(final ExportImport ei, final PanelContext pc, String nameLabel, final String nameCountLabel) {
        this.pc = pc;
        this.nameLabel = nameLabel;
        this.ei = ei;
        new Thread(new Runnable(){

            @Override
            public void run() {
                pc.getPanel().getPresentatorForName("runExport").getViewer().setEditable(false);
                ObjectUIList lw = null;
                ObjectUIList ln = null;
                CommonWriter.this.waySearchCriteria.appendSorting(SortObject.getInstance((String)"id", (String)SortObject.DIRECTION_ASC));
                CommonWriter.this.nodeSearchCriteria.appendSorting(SortObject.getInstance((String)"id", (String)SortObject.DIRECTION_ASC));
                Integer count = 0;
                if (CommonWriter.this.exportWays) {
                    lw = new ObjectUIList(Way.class, CommonWriter.this.keyPage);
                    lw.setSearchCriteria((CommonSearchCriteria)CommonWriter.this.waySearchCriteria);
                    count = count + lw.size();
                }
                if (CommonWriter.this.exportNodes) {
                    ln = new ObjectUIList(Node.class, CommonWriter.this.keyPage);
                    ln.setSearchCriteria((CommonSearchCriteria)CommonWriter.this.nodeSearchCriteria);
                    count = count + ln.size();
                }
                ei.setTextCount(count.toString());
                pc.getPanel().updateUIForPresentatorName(nameCountLabel);
                CommonWriter.this.exportData((ObjectUIList<Way>)lw, (ObjectUIList<Node>)ln);
                pc.getPanel().getPresentatorForName("runExport").getViewer().setEditable(true);
            }
        }).start();
    }

    protected void inc() {
        this.count = this.count + 1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (CommonWriter.this.ei != null && CommonWriter.this.pc != null) {
                    CommonWriter.this.ei.setTextExport(Integer.toString(CommonWriter.this.count));
                    CommonWriter.this.pc.getPanel().updateUIForPresentatorName(CommonWriter.this.nameLabel);
                }
            }
        }).start();
    }
}

