/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportimport.mifmid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import ru.blok.cartography.exportimport.ColumnTag;
import ru.blok.cartography.exportimport.CommonWriter;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class MifMidDataWriter
extends CommonWriter {
    public Connection connection2 = null;
    public Statement stmtcart;

    public PrintWriter[] InitMifMid(String nameFile, String encode) {
        try {
            if (nameFile.indexOf(".") > 0) {
                nameFile = nameFile.substring(0, nameFile.indexOf("."));
            }
            PrintWriter mif = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MIF").getAbsoluteFile()), encode));
            PrintWriter mid = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MID").getAbsoluteFile()), encode));
            mif.println("Version 300");
            mif.println("Charset \"WindowsCyrillic\"");
            mif.println("Delimiter \";\"");
            mif.println("CoordSys Earth Projection 1,0");
            return new PrintWriter[]{mif, mid};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void InitColumn(PrintWriter mif, PrintWriter mid) {
        mif.println("Columns " + this.getColumnTags().size());
        for (ColumnTag ct : this.getColumnTags()) {
            StringBuilder name = new StringBuilder(ct.getNameFile()).append(" ");
            if (ct.getType() == ColumnTag.NUMBER) {
                name.append("Integer");
            } else {
                name.append("Char(255)");
            }
            mif.println(name);
        }
        mif.println("Data");
    }

    private String getValueWithType(ColumnTag ct, Object value) {
        StringBuilder st = new StringBuilder();
        if (ct.getType() == ColumnTag.TEXT) {
            st.append('\"').append(value).append('\"');
        } else {
            st.append(value);
        }
        return st.toString();
    }

    private String getValueTag(ColumnTag ct, AbstractMapEntry w) {
        if (ct.isIdInNK()) {
            return this.getValueWithType(ct, w.getId());
        }
        if (ct.isIdObject()) {
            return this.getValueWithType(ct, w.getObjectid());
        }
        if (ct.isIdDs()) {
            return this.getValueWithType(ct, w.getDatasourceid());
        }
        if (ct.getValue() != null && !"".equals(ct.getValue())) {
            return this.getValueWithType(ct, ct.getValue());
        }
        Tag[] tagArray = w.getTags();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tag t = tagArray[n2];
            if (ct.getNameNK().equals(t.getKey())) {
                return this.getValueWithType(ct, t.getValue());
            }
            ++n2;
        }
        return this.getValueWithType(ct, "");
    }

    public void getConnection2() {
        try {
            Class.forName("org.postgresql.Driver");
            this.connection2 = DriverManager.getConnection("jdbc:postgresql://10.144.2.51/cartography_ds3", "postgres", "postgres");
            this.stmtcart = this.connection2.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTag(Way w) {
        try {
            String from = " map_way_tag";
            String sql = "Select * from " + from + " where owner_id  =" + w.getId();
            ResultSet rs2 = this.stmtcart.executeQuery(sql);
            ArrayList<Tag> l = new ArrayList<Tag>();
            while (rs2.next()) {
                String key = rs2.getString("key");
                String value = rs2.getString("value");
                rs2.getLong("owner_id");
                Tag t = new Tag();
                t.setKey(key);
                t.setValue(value);
                l.add(t);
            }
            rs2.close();
            w.setTags(l.toArray(new Tag[0]));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putWay(Way w, PrintWriter mid, PrintWriter mif) {
        if (w.getNodes() == null) {
            w = this.pWayWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.keyPage), w.getId());
        }
        StringBuilder st = new StringBuilder();
        for (ColumnTag ct : this.getColumnTags()) {
            if (st.length() > 0) {
                st.append(";");
            }
            st.append(this.getValueTag(ct, (AbstractMapEntry)w));
        }
        mid.println(st.toString());
        Node n1 = w.getNodes()[0];
        Node n2 = w.getNodes()[w.getNodes().length - 1];
        if (n1.equals((Object)n2) || n1.getLat() == n2.getLat() && n1.getLon() == n2.getLon()) {
            mif.println("Region  1");
            mif.println(w.getNodes().length);
        } else {
            mif.println("Pline " + w.getNodes().length);
        }
        Node[] nodeArray = w.getNodes();
        int n = nodeArray.length;
        int n3 = 0;
        while (n3 < n) {
            Node n4 = nodeArray[n3];
            mif.println(String.valueOf(n4.getLon()) + " " + n4.getLat());
            ++n3;
        }
    }

    private void putNode(Node n, PrintWriter mid, PrintWriter mif) {
        n = this.nodeWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.keyPage), n.getId());
        StringBuilder st = new StringBuilder();
        for (ColumnTag ct : this.getColumnTags()) {
            if (st.length() > 0) {
                st.append(";");
            }
            st.append(this.getValueTag(ct, (AbstractMapEntry)n));
        }
        mid.println(st.toString());
        mif.println("Point " + n.getLon() + " " + n.getLat());
    }

    @Override
    public void exportData(ObjectUIList<Way> ways, ObjectUIList<Node> nodes) {
        PrintWriter[] mm = this.InitMifMid(this.getFileName(), this.getEncode());
        PrintWriter mif = mm[0];
        PrintWriter mid = mm[1];
        this.InitColumn(mif, mid);
        if (this.isExportWays()) {
            for (Object ww : ways) {
                this.putWay((Way)ww, mid, mif);
                this.inc();
            }
        }
        if (this.isExportNodes()) {
            for (Object nn : nodes) {
                this.putNode((Node)nn, mid, mif);
                this.inc();
            }
        }
        mif.close();
        mid.close();
    }
}

