/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportimport.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.PropertyDescriptor;
import ru.blok.cartography.exportimport.ColumnTag;
import ru.blok.cartography.exportimport.CommonReader;
import ru.blok.cartography.exportimport.ObjectGeom;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class SHPReader
extends CommonReader {
    List<ColumnTag> properties = new ArrayList<ColumnTag>();
    FeatureIterator iterator;

    public SHPReader(String fileName, String encode) {
        String shp = fileName;
        File ff = new File(shp);
        try {
            ShapefileDataStore ds = new ShapefileDataStore(ff.toURI().toURL(), false, Charset.forName(encode));
            SimpleFeatureSource fs = ds.getFeatureSource();
            FeatureCollection fc = fs.getFeatures();
            this.iterator = fc.features();
            this.properties.clear();
            for (PropertyDescriptor pd : fs.getSchema().getDescriptors()) {
                if (!pd.getType().getBinding().equals(String.class)) continue;
                ColumnTag t = new ColumnTag(pd.getType().getName().getLocalPart(), pd.getType().getName().getLocalPart());
                t.setType(ColumnTag.TEXT);
                this.properties.add(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTags(Feature feature, AbstractMapEntry w) {
        Iterator ii = feature.getProperties().iterator();
        ArrayList<Tag> lt = new ArrayList<Tag>();
        while (ii.hasNext()) {
            Property p = (Property)ii.next();
            Object o = p.getValue();
            if (o == null || "".equals(o) || !(o instanceof String)) continue;
            Tag t = new Tag();
            t.setKey(p.getName().toString());
            t.setValue((String)o);
            lt.add(t);
        }
        this.setProperty(lt, w);
    }

    @Override
    public ObjectGeom getNextGeom() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        Feature feature = this.iterator.next();
        Geometry g = (Geometry)feature.getDefaultGeometryProperty().getValue();
        ObjectGeom o = new ObjectGeom();
        if (g instanceof MultiPolygon) {
            MultiPolygon p = (MultiPolygon)g;
            int i = 0;
            while (i < p.getNumGeometries()) {
                Polygon pp = (Polygon)p.getGeometryN(i);
                Way w = new Way();
                w.setCurrentVersion(Integer.valueOf(1));
                ArrayList<Node> ll = new ArrayList<Node>();
                Coordinate[] coordinateArray = pp.getCoordinates();
                int n = coordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate c = coordinateArray[n2];
                    Node n3 = new Node();
                    n3.setCurrentVersion(Integer.valueOf(1));
                    n3.setLat(c.y);
                    n3.setLon(c.x);
                    ll.add(n3);
                    ++n2;
                }
                w.setNodes(ll.toArray(new Node[0]));
                this.setTags(feature, (AbstractMapEntry)w);
                o.getListWay().add(w);
                ++i;
            }
        } else if (g instanceof MultiLineString) {
            MultiLineString p = (MultiLineString)g;
            int i = 0;
            while (i < p.getNumGeometries()) {
                LineString pp = (LineString)p.getGeometryN(i);
                Way w = new Way();
                w.setCurrentVersion(Integer.valueOf(1));
                ArrayList<Node> ll = new ArrayList<Node>();
                int j = 0;
                while (j < pp.getNumPoints()) {
                    Point point = pp.getPointN(j);
                    Node n = new Node();
                    n.setCurrentVersion(Integer.valueOf(1));
                    n.setLat(point.getY());
                    n.setLon(point.getX());
                    ll.add(n);
                    ++j;
                }
                w.setNodes(ll.toArray(new Node[0]));
                this.setTags(feature, (AbstractMapEntry)w);
                o.getListWay().add(w);
                ++i;
            }
        } else if (g instanceof Point) {
            Point point = (Point)g;
            Node n = new Node();
            n.setCurrentVersion(Integer.valueOf(1));
            n.setLat(point.getY());
            n.setLon(point.getX());
            this.setTags(feature, (AbstractMapEntry)n);
            o.getListNode().add(n);
        } else {
            System.out.println(g);
        }
        return o;
    }

    @Override
    public List<ColumnTag> getColumnTags() {
        return this.properties;
    }
}

