/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.exportimport.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.nio.charset.Charset;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ru.blok.cartography.exportimport.ColumnTag;
import ru.blok.cartography.exportimport.CommonWriter;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class SHPWriter
extends CommonWriter {
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    SimpleFeatureTypeBuilder builder;
    ShapefileDataStore myData;

    public FeatureType getTypeB(CoordinateReferenceSystem crs) {
        this.builder = new SimpleFeatureTypeBuilder();
        this.builder.setName("MyType");
        this.builder.add("geom", MultiPolygon.class);
        for (ColumnTag ct : this.getColumnTags()) {
            if (ct.getType() == ColumnTag.NUMBER) {
                this.builder.add(ct.getNameFile(), Integer.class);
                continue;
            }
            this.builder.add(ct.getNameFile(), String.class);
        }
        this.builder.setCRS(crs);
        SimpleFeatureType type = this.builder.buildFeatureType();
        return type;
    }

    private void setAtrToFeature(Object o, SimpleFeature feature) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Way entry = null;
        if (o instanceof Node) {
            Node n = (Node)o;
            n = this.nodeWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.keyPage), n.getId());
            Coordinate c = new Coordinate(n.getLon(), n.getLat());
            Point point = geometryFactory.createPoint(c);
            point.setSRID(4326);
            feature.setDefaultGeometry((Object)point);
            entry = n;
        } else if (o instanceof Way) {
            Coordinate[] coords;
            Node n2;
            Way w;
            entry = w = (Way)this.pWayWSProxy._universalGetCurrentObject((InvocationContext)InitializedVariable.getContext((String)this.keyPage), ((Way)o).getId());
            Node n1 = w.getNodes()[0];
            if (n1.equals((Object)(n2 = w.getNodes()[w.getNodes().length - 1]))) {
                coords = new Coordinate[w.getNodes().length];
                int i = 0;
                while (i < w.getNodes().length) {
                    coords[i] = new Coordinate(w.getNodes()[i].getLon(), w.getNodes()[i].getLat());
                    ++i;
                }
                LinearRing l = geometryFactory.createLinearRing(coords);
                Polygon p = geometryFactory.createPolygon(l, null);
                MultiPolygon pp = geometryFactory.createMultiPolygon(new Polygon[]{p});
                pp.setSRID(4326);
                feature.setDefaultGeometry((Object)pp);
            } else {
                coords = new Coordinate[w.getNodes().length];
                int i = 0;
                while (i < w.getNodes().length) {
                    coords[i] = new Coordinate(w.getNodes()[i].getLon(), w.getNodes()[i].getLat());
                    ++i;
                }
                LineString p = geometryFactory.createLineString(coords);
                MultiLineString pp = geometryFactory.createMultiLineString(new LineString[]{p});
                pp.setSRID(4326);
                feature.setDefaultGeometry((Object)pp);
            }
        }
        for (ColumnTag ct : this.getColumnTags()) {
            Object value = this.getValueTag(ct, (AbstractMapEntry)entry);
            feature.setAttribute(ct.getNameFile(), value);
        }
    }

    private Object getValueTag(ColumnTag ct, AbstractMapEntry w) {
        if (ct.isIdInNK()) {
            return w.getId();
        }
        if (ct.isIdObject()) {
            return w.getObjectid();
        }
        if (ct.isIdDs()) {
            return w.getDatasourceid();
        }
        if (ct.getValue() != null && !"".equals(ct.getValue())) {
            return ct.getValue();
        }
        Tag[] tagArray = w.getTags();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tag t = tagArray[n2];
            if (ct.getNameNK().equals(t.getKey())) {
                return t.getValue();
            }
            ++n2;
        }
        return "";
    }

    @Override
    public void exportData(ObjectUIList<Way> ways, ObjectUIList<Node> nodes) {
        try {
            SimpleFeature outFeature;
            FeatureType featureType = null;
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt4326);
            featureType = this.getTypeB(crs);
            if (featureType == null) {
                System.out.println("Data to export not found");
                return;
            }
            String shp = String.valueOf(this.getFileName()) + ".shp";
            File ff = new File(shp);
            this.myData = new IndexedShapefileDataStore(ff.toURI().toURL(), null, false, true, IndexType.QIX, Charset.forName(this.getEncode()));
            this.myData.createSchema((SimpleFeatureType)featureType);
            FeatureWriter writer = this.myData.getFeatureWriter(Transaction.AUTO_COMMIT);
            if (this.isExportWays()) {
                for (Object o : ways) {
                    outFeature = (SimpleFeature)writer.next();
                    this.setAtrToFeature(o, outFeature);
                    writer.write();
                    this.inc();
                }
            }
            if (this.isExportNodes()) {
                for (Object o : nodes) {
                    outFeature = (SimpleFeature)writer.next();
                    this.setAtrToFeature(o, outFeature);
                    writer.write();
                    this.inc();
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

