/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.geozone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Way;
import ru.infor.ws.objects.cartography.ext.GeoZone;

public class GeoZoneViewer<T>
extends BaseDirectoryViewer<T> {
    private static Map<GeoZone, String> map = new HashMap<GeoZone, String>();

    public GeoZoneViewer(UIFactory<T> factory) {
        super(factory);
        map.clear();
        WaySearchCriteria sc = new WaySearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setMapEntryKeyTypeName("\u0413\u0435\u043e\u0437\u043e\u043d\u0430");
        WayWSProxy proxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
        WayWSProxy.SearchResultListWay list = proxy.getList(InitializedVariable.context, sc);
        if (!list.isEmpty()) {
            int i = 0;
            while (i < list.getObjList().length) {
                Way w = proxy.getCurrentObject(InitializedVariable.context, ((Way)list.getObjList()[i]).getId());
                String name = " \u0417\u043e\u043d\u0430 " + String.valueOf(w.getId());
                int j = 0;
                while (j < w.getTags().length) {
                    if (w.getTags()[j].getKey().equalsIgnoreCase("name")) {
                        name = w.getTags()[j].getValue();
                    }
                    ++j;
                }
                GeoZone gz = new GeoZone();
                gz.setId(w.getId());
                gz.setName(name);
                gz.setGeom(w.getGeom());
                gz.setWay(w);
                map.put(gz, name);
                ++i;
            }
        }
    }

    protected List<?> getDirectoryItems() {
        ArrayList<String> listOut = new ArrayList<String>(map.values());
        Collections.sort(listOut);
        return listOut;
    }

    public Object getValue() {
        String s = (String)super.getValue();
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        for (GeoZone i : map.keySet()) {
            if (!map.get(i).equals(s)) continue;
            return i;
        }
        return null;
    }

    public void setValue(Object object) {
        if (object == null) {
            super.setValue(null);
            return;
        }
        super.setValue((Object)map.get(object));
    }
}

