/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.districtselectiap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.JTSFactoryFinder;
import ru.blok.cartography.importdata.districtselectiap.District;

public class DistrictSelectIap {
    static Connection connection = null;
    private static String[] names = new String[]{"\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u0414\u0437\u0435\u0440\u0436\u0438\u043d\u0441\u043a", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u041d\u0438\u0436\u043d\u0438\u0439 \u041d\u043e\u0432\u0433\u043e\u0440\u043e\u0434", "\u0411\u0430\u043b\u0430\u0445\u043d\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u043e\u043b\u043e\u0434\u0430\u0440\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0411\u043e\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0427\u043a\u0430\u043b\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0413\u043e\u0440\u043e\u0434\u0435\u0446\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041a\u0441\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0414\u0430\u043b\u044c\u043d\u0435\u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0438\u043d\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u0411\u043e\u0440", "\u041f\u0430\u0432\u043b\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0421\u043e\u0441\u043d\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041b\u044b\u0441\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u043e\u0440\u043e\u0442\u044b\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0410\u0440\u0434\u0430\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u0430\u0447\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u0412\u044b\u043a\u0441\u0430", "\u041a\u0443\u043b\u0435\u0431\u0430\u043a\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041d\u0430\u0432\u0430\u0448\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0414\u0438\u0432\u0435\u0435\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u043e\u0437\u043d\u0435\u0441\u0435\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0410\u0440\u0437\u0430\u043c\u0430\u0441\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u0435\u0442\u043b\u0443\u0436\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0422\u043e\u043d\u0448\u0430\u0435\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u0428\u0430\u0445\u0443\u043d\u044c\u044f", "\u0421\u043e\u043a\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041a\u043e\u0432\u0435\u0440\u043d\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u0430\u0440\u043d\u0430\u0432\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0423\u0440\u0435\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0422\u043e\u043d\u043a\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0421\u043f\u0430\u0441\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0411\u0443\u0442\u0443\u0440\u043b\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0411\u043e\u043b\u044c\u0448\u0435\u043c\u0443\u0440\u0430\u0448\u043a\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0421\u0435\u0440\u0433\u0430\u0447\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041f\u0438\u043b\u044c\u043d\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041a\u043d\u044f\u0433\u0438\u043d\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u0430\u0434\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u0410\u0440\u0437\u0430\u043c\u0430\u0441", "\u0428\u0430\u0440\u0430\u043d\u0433\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0412\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041a\u0440\u0430\u0441\u043d\u043e\u0431\u0430\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0421\u0435\u043c\u0451\u043d\u043e\u0432\u0441\u043a\u0438\u0439 \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433", "\u0421\u0435\u0447\u0435\u043d\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0411\u043e\u043b\u044c\u0448\u0435\u0431\u043e\u043b\u0434\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041a\u0440\u0430\u0441\u043d\u043e\u043e\u043a\u0442\u044f\u0431\u0440\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041f\u043e\u0447\u0438\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u043a\u0440\u0443\u0433 \u041f\u0435\u0440\u0432\u043e\u043c\u0430\u0439\u0441\u043a", "\u0428\u0430\u0442\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u041b\u0443\u043a\u043e\u044f\u043d\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0413\u0430\u0433\u0438\u043d\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d", "\u0417\u0410\u0422\u041e \u0421\u0430\u0440\u043e\u0432"};
    private static GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);

    public static void getConnection() throws Exception {
        Class.forName("org.postgresql.Driver");
        connection = DriverManager.getConnection("jdbc:postgresql://power-server/osm_NN1", "openstreetmap", "openstreetmap");
    }

    private static void printToFile(District d, PrintWriter sqlname, PrintWriter sqlgeom) {
        StringBuilder st = new StringBuilder("INSERT INTO spr_region(id, type_id, title, latin_title, osm_id, active, deleted) ").append(" VALUES (nextval('spr_region_id_seq'), (select id from spr_region_type  where code='mo'), ").append("'").append(d.getTitle()).append("','").append(d.getLatin_title() == null ? "" : d.getLatin_title()).append("',").append(d.getOsm_id()).append(", true, false);");
        sqlname.println(st.toString());
        Coordinate[] c = d.getGeometry().getCoordinates();
        int i = 0;
        while (i < c.length) {
            st = new StringBuilder("INSERT INTO region_coordinate( id, region_id, lat, lon, deleted, sorted) ").append(" VALUES (nextval('region_coordinate_id_seq'),").append("(select id from spr_region where title='").append(d.getTitle()).append("'),").append(c[i].x).append(",").append(c[i].y).append(",false,").append(i + 1).append(");");
            sqlgeom.println(st.toString());
            ++i;
        }
        if (c[0].x != c[c.length - 1].x && c[0].y != c[c.length - 1].y) {
            st = new StringBuilder("INSERT INTO region_coordinate( id, region_id, lat, lon, deleted, sorted) ").append(" VALUES (nextval('region_coordinate_id_seq'),").append("(select id from spr_region where title='").append(d.getTitle()).append("'),").append(c[0].x).append(",").append(c[0].y).append(",false,").append(c.length + 1).append(");");
            sqlgeom.println(st.toString());
        }
    }

    private static boolean addNodesToWays(List<Coordinate> ln, String wid, Integer order) throws SQLException {
        boolean ob = false;
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + wid + " order by sequence_id");
        ArrayList<Coordinate> ln1 = new ArrayList<Coordinate>();
        while (rs.next()) {
            Coordinate n = new Coordinate(rs.getDouble("lon"), rs.getDouble("lat"));
            ln1.add(n);
        }
        if (ln.size() > 0 && ln1.size() > 0) {
            if (order == 1) {
                Coordinate s1 = ln.get(ln.size() - 1);
                Coordinate s0 = ln.get(0);
                Coordinate p1 = (Coordinate)ln1.get(0);
                Coordinate p2 = (Coordinate)ln1.get(ln1.size() - 1);
                double d1 = Math.abs(s1.y - p1.y) + Math.abs(s1.x - p1.x);
                double d2 = Math.abs(s1.y - p2.y) + Math.abs(s1.x - p2.x);
                double d3 = Math.abs(s0.y - p1.y) + Math.abs(s0.x - p1.x);
                double d4 = Math.abs(s0.y - p2.y) + Math.abs(s0.x - p2.x);
                if (d1 < d2 && d1 < d3 && d1 < d4) {
                    ln.addAll(ln1);
                } else if (d2 < d1 && d2 < d3 && d2 < d4) {
                    ob = true;
                    int i = ln1.size() - 1;
                    while (i >= 0) {
                        ln.add((Coordinate)ln1.get(i));
                        --i;
                    }
                } else if (d3 < d1 && d3 < d2 && d3 < d4) {
                    ob = true;
                    ArrayList<Coordinate> ln2 = new ArrayList<Coordinate>();
                    int i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add(ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    ln.addAll(ln1);
                } else {
                    ob = true;
                    ArrayList<Coordinate> ln2 = new ArrayList<Coordinate>();
                    int i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add(ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    i = ln1.size() - 1;
                    while (i >= 0) {
                        ln.add((Coordinate)ln1.get(i));
                        --i;
                    }
                }
            } else {
                double d2;
                Coordinate s = ln.get(ln.size() - 1);
                Coordinate p1 = (Coordinate)ln1.get(0);
                Coordinate p2 = (Coordinate)ln1.get(ln1.size() - 1);
                double d1 = Math.abs(s.y - p1.y) + Math.abs(s.x - p1.x);
                if (d1 < (d2 = Math.abs(s.y - p2.y) + Math.abs(s.x - p2.x))) {
                    ln.addAll(ln1);
                } else {
                    ob = true;
                    int i = ln1.size() - 1;
                    while (i >= 0) {
                        ln.add((Coordinate)ln1.get(i));
                        --i;
                    }
                }
            }
        } else {
            ln.addAll(ln1);
        }
        rs.close();
        stmt.close();
        return ob;
    }

    private static List<Coordinate> getWays(String wid) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + wid + " order by sequence_id");
        ArrayList<Coordinate> ln1 = new ArrayList<Coordinate>();
        while (rs.next()) {
            Coordinate n = new Coordinate(rs.getDouble("lon"), rs.getDouble("lat"));
            ln1.add(n);
        }
        rs.close();
        stmt.close();
        return ln1;
    }

    public static List<Coordinate> buildGeom(List<List<Coordinate>> lall) {
        ArrayList<Coordinate> ln = new ArrayList<Coordinate>();
        boolean ins = true;
        block0: while (lall.size() > 0 && ins) {
            ins = false;
            for (List<Coordinate> l : lall) {
                int i;
                double d4;
                double d3;
                double d2;
                if (l.size() <= 0) continue;
                if (ln.size() == 0) {
                    ln.addAll(l);
                    lall.remove(l);
                    ins = true;
                    continue block0;
                }
                Coordinate s1 = (Coordinate)ln.get(ln.size() - 1);
                Coordinate s0 = (Coordinate)ln.get(0);
                Coordinate p1 = l.get(0);
                Coordinate p2 = l.get(l.size() - 1);
                double d1 = Math.abs(s1.y - p1.y) + Math.abs(s1.x - p1.x);
                Double d = Math.min(d1, Math.min(d2 = Math.abs(s1.y - p2.y) + Math.abs(s1.x - p2.x), Math.min(d3 = Math.abs(s0.y - p1.y) + Math.abs(s0.x - p1.x), d4 = Math.abs(s0.y - p2.y) + Math.abs(s0.x - p2.x))));
                if (!(d < 1.0E-6)) continue;
                if (d1 == d) {
                    ln.addAll(l);
                } else if (d2 == d) {
                    int i2 = l.size() - 1;
                    while (i2 >= 0) {
                        ln.add(l.get(i2));
                        --i2;
                    }
                } else if (d3 == d) {
                    ArrayList<Coordinate> ln2 = new ArrayList<Coordinate>();
                    i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add((Coordinate)ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    ln.addAll(l);
                } else {
                    ArrayList<Coordinate> ln2 = new ArrayList<Coordinate>();
                    i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add((Coordinate)ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    i = l.size() - 1;
                    while (i >= 0) {
                        ln.add(l.get(i));
                        --i;
                    }
                }
                lall.remove(l);
                ins = true;
                continue block0;
            }
        }
        return ln;
    }

    private static void setTags(District d) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs2 = stmt.executeQuery(" select * from relation_tags where relation_id = " + d.getOsm_id());
        while (rs2.next()) {
            String k = rs2.getString("k");
            if ("name".equals(k)) {
                d.setTitle(rs2.getString("v"));
                continue;
            }
            if (!"name:en".equals(k)) continue;
            d.setLatin_title(rs2.getString("v"));
        }
        rs2.close();
        stmt.close();
    }

    public static District importDistrinct(Integer osm_id) {
        try {
            Polygon r;
            Geometry rr;
            String ss;
            District d = new District();
            d.setOsm_id(osm_id);
            DistrictSelectIap.setTags(d);
            Statement stmt1 = connection.createStatement();
            ResultSet rs2 = stmt1.executeQuery(" select * from relation_members where relation_id =" + osm_id + " order by sequence_id ");
            ArrayList<List<Coordinate>> lall = new ArrayList<List<Coordinate>>();
            while (rs2.next()) {
                Long mi = rs2.getLong("member_id");
                String mid = mi.toString();
                String type = rs2.getString("member_type");
                rs2.getString("member_role");
                if ("N".equals(type) || !"W".equals(type)) continue;
                List<Coordinate> l = DistrictSelectIap.getWays(mid);
                lall.add(l);
            }
            rs2.close();
            List<Coordinate> list = DistrictSelectIap.buildGeom(lall);
            if (list.get((int)0).x != list.get((int)(list.size() - 1)).x && list.get((int)0).y != list.get((int)(list.size() - 1)).y) {
                list.add(list.get(0));
            }
            if ((ss = (rr = DouglasPeuckerSimplifier.simplify((Geometry)(r = gf.createPolygon(gf.createLinearRing(list.toArray(new Coordinate[list.size()])), null)), (double)3.0E-4f)).toString()).contains("), (")) {
                d.setGeometry((Geometry)r);
                System.out.println(d.getTitle());
            } else {
                d.setGeometry(rr);
            }
            stmt1.close();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void runImportGeom() {
        ArrayList<String> ss = new ArrayList<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ss.add(s);
            ++n2;
        }
        try {
            DistrictSelectIap.getConnection();
            PrintWriter sqlname = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File("insertName.sql").getAbsoluteFile()), "UTF-8"));
            PrintWriter sqlgeom = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File("insertGeom.sql").getAbsoluteFile()), "UTF-8"));
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("\tselect relation_id from relation_tags where k = 'admin_level' and v='6'");
            while (rs.next()) {
                Integer id = rs.getInt("relation_id");
                District d = DistrictSelectIap.importDistrinct(id);
                if (!ss.contains(d.getTitle()) || d.getTitle().equals("\u0410\u0440\u0434\u0430\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d") && d.getLatin_title() != null && d.getLatin_title().equals("Ardatovsky District, Republic of Mordovia")) continue;
                DistrictSelectIap.printToFile(d, sqlname, sqlgeom);
            }
            rs.close();
            stmt.close();
            sqlname.close();
            sqlgeom.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

