/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.importfromosm;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.NodeSearchCriteria;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class ImportFromOSM {
    static Connection connection = null;
    public static Connection connection2 = null;
    public static Statement stmtcart;
    static WayWSProxy pWayWSProxy;
    static NodeWSProxy nodeWSProxy;
    static NodeSearchCriteria sc;

    static {
        pWayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
        nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
        sc = new NodeSearchCriteria();
    }

    public static void getConnection(String database, String url) throws Exception {
        if (connection == null) {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection("jdbc:postgresql://power-server/" + database, "openstreetmap", "openstreetmap");
            connection2 = DriverManager.getConnection("jdbc:postgresql://" + url + "/cartography", "cart", "cart");
            stmtcart = connection2.createStatement();
        }
    }

    public static void getConnection2() throws Exception {
        Class.forName("org.postgresql.Driver");
        connection2 = DriverManager.getConnection("jdbc:postgresql://maps.yarcloud.ru/cartography", "cart", "cart");
        stmtcart = connection2.createStatement();
    }

    public static void importBoundary(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportBoundary();
            ImportFromOSM.runImportBoundary7();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importRoad(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportRoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importRailRoad(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportRailRoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importAero(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportAeroRoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importAmenity(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportAmenity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importWetland(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportWetland();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importNP(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportNP();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importBuilding(String database, String url) {
        try {
            ImportFromOSM.getConnection(database, url);
            ImportFromOSM.runImportBuilding();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runImportRoad() throws SQLException {
        Statement stmt1 = connection.createStatement();
        ResultSet rs = stmt1.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and wt.k ='highway' ");
        ImportFromOSM.saveWayFromRS(rs, 1L, false);
        rs.close();
        rs = stmt1.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n join node_tags nt on n.id = nt.node_id and nt.k ='highway' ");
        ImportFromOSM.saveNodeFromRS(rs, 1L);
        rs.close();
        stmt1.close();
    }

    private static void runImportBuilding() throws SQLException {
        Statement stmt1 = connection.createStatement();
        ResultSet rs = stmt1.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and wt.k ='building' ");
        ImportFromOSM.saveWayFromRS(rs, 9L, false);
        rs.close();
        stmt1.close();
    }

    public static boolean isNotWFromC(String id, Long dataSourceId) throws SQLException {
        ResultSet rs2 = stmtcart.executeQuery(" select count(*) as t from map_ways where datasourceid = " + dataSourceId + " and objectid = " + id);
        rs2.next();
        int t = rs2.getInt("t");
        rs2.close();
        return t == 0;
    }

    public static Long[] selectWFromC(String id, Long dataSourceId) throws SQLException {
        ResultSet rs2 = stmtcart.executeQuery(" select id from map_ways where datasourceid = " + dataSourceId + " and objectid = " + id);
        ArrayList<Long> ll = new ArrayList<Long>();
        while (rs2.next()) {
            Long res = rs2.getLong("id");
            ll.add(res);
        }
        rs2.close();
        return ll.toArray(new Long[0]);
    }

    public static Long isNotNFromC(String id, Long dataSourceId) throws SQLException {
        ResultSet rs2 = stmtcart.executeQuery(" select id from map_nodes where datasourceid = " + dataSourceId + " and objectid = " + id);
        Long res = null;
        if (rs2.next()) {
            res = rs2.getLong("id");
        }
        rs2.close();
        return res;
    }

    public static long getNextId2() throws SQLException {
        String maxid = "select nextval('hibernate_sequence') as id";
        ResultSet rs2 = stmtcart.executeQuery(maxid);
        rs2.next();
        long wid = rs2.getInt("id");
        rs2.close();
        return wid;
    }

    private static Long putWayBase2(Way w) {
        try {
            long wid = ImportFromOSM.getNextId2();
            StringBuilder st = new StringBuilder("update map_ways set geom = ST_SetSrid(ST_GeomFromText('LINESTRING(");
            String insway = "insert into map_ways (id,currentversion,rootid,objectid,datasourceid,isdeleted,createddatetime,createdby_id,acceptedentry,havetags)  values (" + wid + ",1," + wid + "," + w.getObjectid() + "," + w.getDatasourceid() + ",0,current_date,1,1,1 )";
            stmtcart.executeUpdate(insway);
            int i = 0;
            int order = 0;
            Long firstNId = null;
            boolean region = false;
            if (w.getNodes()[0].getLat() == w.getNodes()[w.getNodes().length - 1].getLat() && w.getNodes()[0].getLat() == w.getNodes()[w.getNodes().length - 1].getLon() && w.getNodes().length > 2) {
                region = true;
            }
            while (i < w.getNodes().length) {
                StringBuilder stNodes = new StringBuilder("insert into map_nodes (");
                stNodes.append("id,lat,lon,currentversion,rootid,geom,datasourceid, sourcex,sourcey,isdeleted,createddatetime,createdby_id,changedby_id,acceptedentry,havetags)").append(" values ");
                int kk = i + 100;
                if (kk > w.getNodes().length) {
                    kk = w.getNodes().length;
                }
                if (region && kk == w.getNodes().length) {
                    --kk;
                }
                StringBuilder stWNodes = new StringBuilder("insert into map_way_nodes (");
                stWNodes.append("id,orderindex,wayid,node_id) values");
                boolean f = true;
                int k = i;
                while (k < kk) {
                    Node n = w.getNodes()[k];
                    Point p = new Point(n.getLon(), n.getLat());
                    p.setSrid(4326);
                    if (f) {
                        f = false;
                        if (i > 0) {
                            st.append(",");
                        }
                    } else {
                        st.append(",");
                        stNodes.append(",");
                        stWNodes.append(",");
                    }
                    long nid = ImportFromOSM.getNextId2();
                    if (firstNId == null) {
                        firstNId = nid;
                    }
                    st.append(String.valueOf(n.getLon()) + " " + n.getLat());
                    stNodes.append("(").append(nid).append(",").append(n.getLat()).append(",").append(n.getLon()).append(",1,").append(nid).append(",'").append(p.toString()).append("',").append(w.getDatasourceid()).append(",").append(n.getSourceX()).append(",").append(n.getSourceY()).append(",0,current_date,1,1,null,0) ");
                    stWNodes.append("(nextval('hibernate_sequence'),").append(order).append(",").append(wid).append(",").append(nid).append(")");
                    ++order;
                    ++k;
                }
                if (region && kk == w.getNodes().length - 1) {
                    stWNodes.append(",(nextval('hibernate_sequence'),").append(order).append(",").append(wid).append(",").append(firstNId).append(")");
                    st.append(String.valueOf(w.getNodes()[0].getLon()) + " " + w.getNodes()[0].getLat());
                    ++order;
                }
                i += 100;
                stmtcart.executeUpdate(stNodes.toString());
                stmtcart.executeUpdate(stWNodes.toString());
            }
            st.append(")'),4326) where id = " + wid);
            stmtcart.executeUpdate(st.toString());
            StringBuilder stTag = new StringBuilder("insert into map_way_tag (id, key,owner_id,value) values");
            boolean f = true;
            Tag[] tagArray = w.getTags();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag t = tagArray[n2];
                if (f) {
                    f = false;
                } else {
                    stTag.append(",");
                }
                stTag.append(" (nextval('hibernate_sequence'),'").append(t.getKey()).append("',").append(wid).append(",'").append(t.getValue().replaceAll("'", "''")).append("')");
                ++n2;
            }
            stmtcart.executeUpdate(stTag.toString());
            return wid;
        }
        catch (Exception e) {
            System.out.println(w.getObjectid());
            e.printStackTrace();
            return null;
        }
    }

    private static Long putNodeBase2(Node n) {
        try {
            long nid = ImportFromOSM.getNextId2();
            Point p = new Point(n.getLon(), n.getLat());
            String g = "ST_SetSrid(ST_GeomFromText('" + p.toString() + "'),4326) ";
            StringBuilder stNodes = new StringBuilder("insert into map_nodes (");
            stNodes.append("id,lat,lon,currentversion,rootid,geom,datasourceid, sourcex,sourcey,isdeleted,createddatetime,createdby_id,changedby_id,acceptedentry,havetags)").append(" values ");
            stNodes.append("(").append(nid).append(",").append(n.getLat()).append(",").append(n.getLon()).append(",1,").append(nid).append(",").append(g).append(",").append(n.getDatasourceid()).append(",").append(n.getSourceX()).append(",").append(n.getSourceY()).append(",0,current_date,1,1,null,0) ");
            stmtcart.executeUpdate(stNodes.toString());
            StringBuilder stTag = new StringBuilder("insert into map_node_tag (id, key,owner_id,value) values");
            boolean f = true;
            Tag[] tagArray = n.getTags();
            int n2 = tagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Tag t = tagArray[n3];
                if (f) {
                    f = false;
                } else {
                    stTag.append(",");
                }
                stTag.append(" (nextval('hibernate_sequence'),'").append(t.getKey()).append("',").append(nid).append(",'").append(t.getValue().replaceAll("'", "''")).append("')");
                ++n3;
            }
            stmtcart.executeUpdate(stTag.toString());
            return nid;
        }
        catch (Exception e) {
            System.out.println(n.getObjectid());
            e.printStackTrace();
            return null;
        }
    }

    private static void saveWayFromRS(ResultSet rs, Long dataSourceId) throws SQLException {
        ImportFromOSM.saveWayFromRS(rs, dataSourceId, false);
    }

    private static void saveWayFromRS(ResultSet rs, Long dataSourceId, boolean chech) throws SQLException {
        Statement stmt2 = connection.createStatement();
        Statement stmt3 = connection.createStatement();
        int i = 0;
        while (rs.next()) {
            ++i;
            String id = rs.getString("id");
            boolean nex = true;
            if (chech) {
                nex = ImportFromOSM.isNotWFromC(id, dataSourceId);
            }
            if (nex) {
                Way w = new Way();
                w.setCurrentVersion(Integer.valueOf(1));
                w.setDatasourceid(dataSourceId);
                w.setObjectid(new Long(id));
                ResultSet rs2 = stmt2.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + id + " order by sequence_id");
                ArrayList<Node> ll = new ArrayList<Node>();
                while (rs2.next()) {
                    String idn = rs2.getString("id");
                    Node n = new Node();
                    n.setCurrentVersion(Integer.valueOf(1));
                    n.setLat(rs2.getDouble("lat"));
                    n.setLon(rs2.getDouble("lon"));
                    n.setDatasourceid(dataSourceId);
                    n.setObjectid(new Long(idn));
                    ll.add(n);
                }
                rs2.close();
                w.setNodes(ll.toArray(new Node[0]));
                rs2 = stmt2.executeQuery(" select * from way_tags where way_id = " + id);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs2.next()) {
                    Tag wt = new Tag();
                    wt.setKey(rs2.getString("k"));
                    wt.setValue(rs2.getString("v"));
                    tags.add(wt);
                }
                rs2.close();
                w.setTags(tags.toArray(new Tag[0]));
                ImportFromOSM.putWayBase2(w);
            }
            if (i % 100 != 0) continue;
            System.out.println(new Date() + " " + i);
        }
        rs.close();
        stmt2.close();
        stmt3.close();
    }

    private static void saveWayFromRS_old(ResultSet rs, Long dataSourceId) throws SQLException {
        Statement stmt2 = connection.createStatement();
        Statement stmt3 = connection.createStatement();
        int i = 0;
        while (rs.next()) {
            ++i;
            String id = rs.getString("id");
            if (ImportFromOSM.isNotWFromC(id, dataSourceId)) {
                Way w = new Way();
                w.setCurrentVersion(Integer.valueOf(1));
                w.setDatasourceid(dataSourceId);
                w.setObjectid(new Long(id));
                ResultSet rs2 = stmt2.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + id + " order by sequence_id");
                ArrayList<Node> ll = new ArrayList<Node>();
                ArrayList<Long> l1 = new ArrayList<Long>();
                while (rs2.next()) {
                    String idn = rs2.getString("id");
                    Long nid = ImportFromOSM.isNotNFromC(idn, dataSourceId);
                    if (nid == null) {
                        Node n = new Node();
                        n.setCurrentVersion(Integer.valueOf(1));
                        n.setLat(rs2.getDouble("lat"));
                        n.setLon(rs2.getDouble("lon"));
                        n.setDatasourceid(dataSourceId);
                        n.setObjectid(new Long(idn));
                        ResultSet rs3 = stmt3.executeQuery(" select * from node_tags where node_id = " + idn);
                        ArrayList<Tag> tags = new ArrayList<Tag>();
                        while (rs3.next()) {
                            Tag wt = new Tag();
                            wt.setKey(rs3.getString("k"));
                            wt.setValue(rs3.getString("v"));
                            tags.add(wt);
                        }
                        rs3.close();
                        n.setTags(tags.toArray(new Tag[0]));
                        Node n2 = nodeWSProxy.save(InitializedVariable.context, n);
                        ll.add(n2);
                        l1.add(n2.getId());
                        continue;
                    }
                    Node n2 = nodeWSProxy.getCurrentObject(InitializedVariable.context, nid);
                    ll.add(n2);
                }
                rs2.close();
                nodeWSProxy.rebuildGeomList(InitializedVariable.context, l1.toArray(new Long[0]));
                w.setNodes(ll.toArray(new Node[0]));
                rs2 = stmt2.executeQuery(" select * from way_tags where way_id = " + id);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs2.next()) {
                    Tag wt = new Tag();
                    wt.setKey(rs2.getString("k"));
                    wt.setValue(rs2.getString("v"));
                    tags.add(wt);
                }
                rs2.close();
                w.setTags(tags.toArray(new Tag[0]));
                w = pWayWSProxy.save(InitializedVariable.context, w);
                pWayWSProxy.rebuildGeom(InitializedVariable.context, w.getId());
            }
            if (i % 100 != 0) continue;
            System.out.println(new Date() + " " + i);
        }
        rs.close();
        stmt2.close();
        stmt3.close();
    }

    private static void saveWayFromRS2(ResultSet rs, Long dataSourceId) throws SQLException {
        Statement stmt2 = connection.createStatement();
        Statement stmt3 = connection.createStatement();
        int i = 0;
        while (rs.next()) {
            ++i;
            String id = rs.getString("id");
            ResultSet rs2 = stmt2.executeQuery("select wn.node_id from way_nodes wn  join node_tags nt on nt.node_id = wn.node_id  where way_id = " + id);
            while (rs2.next()) {
                Node n2;
                String idn = rs2.getString("node_id");
                Long nid = ImportFromOSM.isNotNFromC(idn, dataSourceId);
                if (nid == null || (n2 = nodeWSProxy.getCurrentObject(InitializedVariable.context, nid)).getTags() != null && n2.getTags().length != 0) continue;
                ResultSet rs3 = stmt3.executeQuery(" select * from node_tags where node_id = " + idn);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs3.next()) {
                    Tag wt = new Tag();
                    wt.setKey(rs3.getString("k"));
                    wt.setValue(rs3.getString("v"));
                    tags.add(wt);
                }
                rs3.close();
                n2.setTags(tags.toArray(new Tag[0]));
                n2 = nodeWSProxy.save(InitializedVariable.context, n2);
            }
            rs2.close();
            if (i % 100 != 0) continue;
            System.out.println(new Date() + " " + i);
        }
        System.out.println(String.valueOf(i) + " finish");
        rs.close();
        stmt2.close();
        stmt3.close();
    }

    private static void saveNodeFromRS(ResultSet rs, Long dataSourceId) throws SQLException {
        Statement stmt2 = connection.createStatement();
        int i = 0;
        while (rs.next()) {
            ++i;
            String id = rs.getString("id");
            Long nid = ImportFromOSM.isNotNFromC(id, dataSourceId);
            if (nid == null) {
                Node n = new Node();
                n.setCurrentVersion(Integer.valueOf(1));
                n.setLat(rs.getDouble("lat"));
                n.setLon(rs.getDouble("lon"));
                n.setDatasourceid(dataSourceId);
                n.setObjectid(new Long(id));
                ResultSet rs2 = stmt2.executeQuery(" select * from node_tags where node_id = " + id);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs2.next()) {
                    Tag wt = new Tag();
                    wt.setKey(rs2.getString("k"));
                    wt.setValue(rs2.getString("v"));
                    tags.add(wt);
                }
                rs2.close();
                n.setTags(tags.toArray(new Tag[0]));
                ImportFromOSM.putNodeBase2(n);
            }
            if (i % 100 != 0) continue;
            System.out.println(i);
        }
        rs.close();
        stmt2.close();
        System.out.println(String.valueOf(i) + " finish");
    }

    private static void saveNodeFromRS_old(ResultSet rs, Long dataSourceId) throws SQLException {
        Statement stmt2 = connection.createStatement();
        int i = 0;
        while (rs.next()) {
            ++i;
            String id = rs.getString("id");
            Long nid = ImportFromOSM.isNotNFromC(id, dataSourceId);
            if (nid == null) {
                Node n = new Node();
                n.setCurrentVersion(Integer.valueOf(1));
                n.setLat(rs.getDouble("lat"));
                n.setLon(rs.getDouble("lon"));
                n.setDatasourceid(dataSourceId);
                n.setObjectid(new Long(id));
                ResultSet rs2 = stmt2.executeQuery(" select * from node_tags where node_id = " + id);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs2.next()) {
                    Tag wt = new Tag();
                    wt.setKey(rs2.getString("k"));
                    wt.setValue(rs2.getString("v"));
                    tags.add(wt);
                }
                rs2.close();
                n.setTags(tags.toArray(new Tag[0]));
                Node n2 = nodeWSProxy.save(InitializedVariable.context, n);
                nodeWSProxy.rebuildGeom(InitializedVariable.context, n2.getId());
            }
            if (i % 100 != 0) continue;
            System.out.println(i);
        }
        rs.close();
        stmt2.close();
        System.out.println(String.valueOf(i) + " finish");
    }

    private static void runImportRailRoad() throws SQLException {
        System.out.println("runImportRailRoad");
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and wt.k ='railway' ");
        ImportFromOSM.saveWayFromRS(rs, 3L);
        rs.close();
        rs = stmt.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n join node_tags nt on n.id = nt.node_id and nt.k ='railway' ");
        ImportFromOSM.saveNodeFromRS(rs, 3L);
        rs.close();
        stmt.close();
    }

    private static void runImportAeroRoad() throws SQLException {
        System.out.println("runImportAeroRoad");
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and wt.k ='aeroway' ");
        ImportFromOSM.saveWayFromRS(rs, 4L);
        rs.close();
        rs = stmt.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n join node_tags nt on n.id = nt.node_id and nt.k ='aeroway' ");
        ImportFromOSM.saveNodeFromRS(rs, 4L);
        rs.close();
        stmt.close();
    }

    private static void runImportAmenity() throws SQLException {
        System.out.println("runImportAmenity");
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and wt.k ='amenity' ");
        ImportFromOSM.saveWayFromRS(rs, 5L);
        rs.close();
        rs = stmt.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n join node_tags nt on n.id = nt.node_id and nt.k ='amenity' ");
        ImportFromOSM.saveNodeFromRS(rs, 5L);
        rs.close();
        stmt.close();
    }

    private static void runImportWetland() throws SQLException {
        System.out.println("runImportWetland");
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tSELECT id FROM ways w join way_tags wt on w.id = wt.way_id and k = 'natural' and v = 'wetland' ");
        ImportFromOSM.saveWayFromRS(rs, 8L);
        rs.close();
        stmt.close();
    }

    private static void runImportNP() throws SQLException {
        System.out.println("runImportNP");
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n join node_tags nt on n.id = nt.node_id and nt.k ='place' ");
        ImportFromOSM.saveNodeFromRS(rs, 2L);
        rs.close();
        stmt.close();
    }

    private static Tag[] getTagRelation(String id) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs2 = stmt.executeQuery(" select * from relation_tags where relation_id = " + id);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (rs2.next()) {
            Tag wt = new Tag();
            wt.setKey(rs2.getString("k"));
            wt.setValue(rs2.getString("v"));
            tags.add(wt);
        }
        rs2.close();
        stmt.close();
        return tags.toArray(new Tag[0]);
    }

    private static void createNode(String nodeId, String relId, String role, Long ds) throws SQLException {
        Long nid = ImportFromOSM.isNotNFromC(nodeId, ds);
        Statement stmt = connection.createStatement();
        if (nid == null) {
            ResultSet rs = stmt.executeQuery("\tSELECT id,ST_X(n.geom) as lon , ST_Y(n.geom) as lat FROM nodes n where id = " + nodeId);
            if (rs.next()) {
                Tag wt;
                Node n = new Node();
                n.setCurrentVersion(Integer.valueOf(1));
                n.setLat(rs.getDouble("lat"));
                n.setLon(rs.getDouble("lon"));
                n.setDatasourceid(ds);
                n.setObjectid(new Long(nodeId));
                ResultSet rs2 = stmt.executeQuery(" select * from node_tags where node_id = " + nodeId);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                while (rs2.next()) {
                    wt = new Tag();
                    wt.setKey(rs2.getString("k"));
                    wt.setValue(rs2.getString("v"));
                    tags.add(wt);
                }
                rs2.close();
                wt = new Tag();
                wt.setKey(role);
                wt.setValue(relId);
                n.setTags(tags.toArray(new Tag[0]));
                Node n2 = nodeWSProxy.save(InitializedVariable.context, n);
                nodeWSProxy.rebuildGeom(InitializedVariable.context, n2.getId());
            }
            rs.close();
        } else {
            Node n = nodeWSProxy.getCurrentObject(InitializedVariable.context, nid);
            Tag[] nn = n.getTags();
            boolean i = false;
            Tag[] tagArray = nn;
            int n2 = nn.length;
            int wt = 0;
            while (wt < n2) {
                Tag t = tagArray[wt];
                if (t.getKey().equals(role) && t.getValue().equals(relId)) {
                    i = true;
                    break;
                }
                ++wt;
            }
            if (!i) {
                Tag wt2 = new Tag();
                wt2.setKey(role);
                wt2.setValue(relId);
                Tag[] n22 = new Tag[nn.length + 1];
                int ii = 0;
                while (ii < nn.length) {
                    n22[ii] = nn[ii];
                    ++ii;
                }
                n22[n22.length - 1] = wt2;
                n.setTags(n22);
                nodeWSProxy.save(InitializedVariable.context, n);
            }
        }
    }

    private static List<Node> getNodes(String wid, Long ds) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select ST_X(n.geom) as lon , ST_Y(n.geom) as lat, n.id from way_nodes wn join nodes n on wn.node_id = n.id  where way_id = " + wid + " order by sequence_id");
        ArrayList<Long> l1 = new ArrayList<Long>();
        ArrayList<Node> ln1 = new ArrayList<Node>();
        while (rs.next()) {
            String idn = rs.getString("id");
            Long nid = ImportFromOSM.isNotNFromC(idn, ds);
            if (nid == null) {
                Node n = new Node();
                n.setCurrentVersion(Integer.valueOf(1));
                n.setLat(rs.getDouble("lat"));
                n.setLon(rs.getDouble("lon"));
                n.setDatasourceid(ds);
                n.setObjectid(new Long(idn));
                Node n2 = nodeWSProxy.save(InitializedVariable.context, n);
                ln1.add(n2);
                l1.add(n2.getId());
                continue;
            }
            Node n2 = nodeWSProxy.getCurrentObject(InitializedVariable.context, nid);
            ln1.add(n2);
        }
        nodeWSProxy.rebuildGeomList(InitializedVariable.context, l1.toArray(new Long[0]));
        rs.close();
        stmt.close();
        return ln1;
    }

    public static List<Node> buildGeom(List<List<Node>> lall) {
        ArrayList<Node> ln = new ArrayList<Node>();
        boolean ins = true;
        block0: while (lall.size() > 0 && ins) {
            ins = false;
            for (List<Node> l : lall) {
                int i;
                double d4;
                double d3;
                double d2;
                if (l.size() <= 0) continue;
                if (ln.size() == 0) {
                    ln.addAll(l);
                    lall.remove(l);
                    ins = true;
                    continue block0;
                }
                Node s1 = (Node)ln.get(ln.size() - 1);
                Node s0 = (Node)ln.get(0);
                Node p1 = l.get(0);
                Node p2 = l.get(l.size() - 1);
                double d1 = Math.abs(s1.getLat() - p1.getLat()) + Math.abs(s1.getLon() - p1.getLon());
                Double d = Math.min(d1, Math.min(d2 = Math.abs(s1.getLat() - p2.getLat()) + Math.abs(s1.getLon() - p2.getLon()), Math.min(d3 = Math.abs(s0.getLat() - p1.getLat()) + Math.abs(s0.getLon() - p1.getLon()), d4 = Math.abs(s0.getLat() - p2.getLat()) + Math.abs(s0.getLon() - p2.getLon()))));
                if (!(d < 1.0E-6)) continue;
                if (d1 == d) {
                    ln.addAll(l);
                } else if (d2 == d) {
                    int i2 = l.size() - 1;
                    while (i2 >= 0) {
                        ln.add(l.get(i2));
                        --i2;
                    }
                } else if (d3 == d) {
                    ArrayList<Node> ln2 = new ArrayList<Node>();
                    i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add((Node)ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    ln.addAll(l);
                } else {
                    ArrayList<Node> ln2 = new ArrayList<Node>();
                    i = ln.size() - 1;
                    while (i >= 0) {
                        ln2.add((Node)ln.get(i));
                        --i;
                    }
                    ln.clear();
                    ln.addAll(ln2);
                    i = l.size() - 1;
                    while (i >= 0) {
                        ln.add(l.get(i));
                        --i;
                    }
                }
                lall.remove(l);
                ins = true;
                continue block0;
            }
        }
        return ln;
    }

    private static void runImportBoundary() throws SQLException {
        Statement stmt = connection.createStatement();
        Statement stmt1 = connection.createStatement();
        ResultSet rs = stmt.executeQuery("\tselect relation_id from relation_tags where k = 'admin_level' and relation_id <> 81994");
        int i = 0;
        long ds = 6L;
        while (rs.next()) {
            ++i;
            String id = rs.getString("relation_id");
            try {
                Way w;
                System.out.println(id);
                ResultSet rs2 = stmt1.executeQuery(" select * from relation_members where relation_id =" + id + " order by sequence_id ");
                ArrayList<List<Node>> lall = new ArrayList<List<Node>>();
                while (rs2.next()) {
                    Long mi = rs2.getLong("member_id");
                    String mid = mi.toString();
                    String type = rs2.getString("member_type");
                    String role = rs2.getString("member_role");
                    if ("N".equals(type)) {
                        ImportFromOSM.createNode(mid, id, role, ds);
                        continue;
                    }
                    if (!"W".equals(type)) continue;
                    List<Node> l = ImportFromOSM.getNodes(mid, ds);
                    lall.add(l);
                }
                rs2.close();
                List<Node> list = ImportFromOSM.buildGeom(lall);
                Long[] l = ImportFromOSM.selectWFromC(id, ds);
                if (l.length > 0) {
                    w = pWayWSProxy.getCurrentObject(InitializedVariable.context, l[0]);
                    w.setNodes(list.toArray(new Node[0]));
                    w = pWayWSProxy.save(InitializedVariable.context, w);
                    pWayWSProxy.rebuildGeom(InitializedVariable.context, w.getId());
                } else {
                    System.out.println("new " + id);
                    w = new Way();
                    w.setCurrentVersion(Integer.valueOf(1));
                    w.setDatasourceid(Long.valueOf(ds));
                    w.setObjectid(new Long(id));
                    w.setNodes(list.toArray(new Node[0]));
                    w.setTags(ImportFromOSM.getTagRelation(id));
                    w = pWayWSProxy.save(InitializedVariable.context, w);
                    pWayWSProxy.rebuildGeom(InitializedVariable.context, w.getId());
                }
            }
            catch (Exception e) {
                System.out.println("error  " + id);
                e.printStackTrace();
            }
            if (i % 100 != 0) continue;
            System.out.println(i);
        }
        rs.close();
        stmt.close();
        stmt1.close();
    }

    private static void runImportBoundary7() throws SQLException {
        Statement stmt = connection.createStatement();
        connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select way_id as id from way_tags where k = 'admin_level'   and way_id not in (select member_id from relation_members  mm join  relation_tags tt on mm.relation_id = tt.relation_id where k = 'admin_level')");
        ImportFromOSM.saveWayFromRS(rs, 7L);
        rs.close();
    }
}

