/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.importmifmid.importcowparsnip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ru.blok.cartography.importdata.AbstractDataProperty;
import ru.blok.cartography.importdata.AbstractDataRearedOld;
import ru.blok.cartography.importdata.importmifmid.importcowparsnip.DataProperty;
import ru.blok.cartography.importdata.isogd.coordinates.Rybinsk;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.Node;

public class DataReared
extends AbstractDataRearedOld {
    Rybinsk rybinsk = new Rybinsk();

    public DataReared(File mif, File mid) throws IOException {
        super(mif, mid);
    }

    @Override
    public double[] getCoord(double x, double y) {
        double[] latlon = this.rybinsk.local2LatLon(new double[]{x * 100.0, y * 100.0});
        return new double[]{latlon[0], latlon[1]};
    }

    @Override
    public AbstractDataProperty getPropertyFromString(String s) {
        String[] ps = s.split(",");
        DataProperty p = new DataProperty(ps[0].replaceAll("\"", ""), ps[1].replaceAll("\"", ""), ps[2].replaceAll("\"", ""), ps[3], ps[4]);
        return p;
    }

    @Override
    public void setProperty(AbstractDataProperty dp, List<Tag> lwt) {
        DataProperty p = (DataProperty)dp;
        Tag wt = new Tag();
        wt.setKey("amenity");
        wt.setValue("hospital");
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("type");
        wt.setValue("cowparsnip");
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("street");
        wt.setValue(p.getStreet());
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("houseNumber");
        wt.setValue(p.getHousenumber());
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("places");
        wt.setValue(p.getPlases());
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("S_border_zu");
        wt.setValue(p.getSgr());
        lwt.add(wt);
        wt = new Tag();
        wt.setKey("S_zone");
        wt.setValue(p.getSz());
        lwt.add(wt);
    }

    @Override
    protected void parseWayGeom(AbstractDataRearedOld.ObjectGeom h, AbstractDataProperty p) {
        for (AbstractDataRearedOld.Geom s : h.getList()) {
            Node n = new Node();
            n.setCurrentVersion(Integer.valueOf(1));
            double[] dd = s.coord.get(0);
            n.setLat(dd[0]);
            n.setLon(dd[1]);
            ArrayList<Tag> lwt = new ArrayList<Tag>();
            this.setProperty(p, lwt);
            n.setTags(lwt.toArray(new Tag[0]));
            h.getListNode().add(n);
        }
    }
}

