/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.isogd.yar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ru.blok.cartography.importdata.AbstractDataProperty;
import ru.blok.cartography.importdata.AbstractDataRearedOld;
import ru.blok.cartography.importdata.importmifmid.ImportGeomFromMifMid;
import ru.blok.cartography.importdata.isogd.coordinates.Yaroslavl;
import ru.blok.cartography.importdata.isogd.yar.DataProperty;
import ru.infor.ws.objects.cartography.Tag;

public class DataReared
extends AbstractDataRearedOld {
    Yaroslavl yaroslavl = new Yaroslavl();

    public DataReared(File mif, File mid) throws IOException {
        super(mif, mid);
    }

    @Override
    public String getR() {
        return "  ";
    }

    @Override
    public double[] getCoord(double x, double y) {
        double[] latlon = this.yaroslavl.local2LatLon(new double[]{y, x});
        return new double[]{latlon[0], latlon[1]};
    }

    @Override
    public AbstractDataProperty getPropertyFromString(String s) {
        String[] ps = s.split("\",\"");
        DataProperty p = new DataProperty(ps[0].replaceAll("\"", ""), ps[8].replaceAll("\"", ""), ps[9].replaceAll("\"", ""), ps[10].replaceAll("\"", ""), ps[11].replaceAll("\"", ""), ps[12].replaceAll("\"", ""), ps[13].replaceAll("\"", ""), ps[15].replaceAll("\"", ""), ps[17].replaceAll("\"", ""), ps[18].replaceAll("\"", ""), ps[19].replaceAll("\"", ""), ps[20].replaceAll("\"", ""), ps[21].replaceAll("\"", ""), ps[22].replaceAll("\"", ""));
        return p;
    }

    @Override
    public void setProperty(AbstractDataProperty dp, List<Tag> lwt) {
        DataProperty p = (DataProperty)dp;
        ImportGeomFromMifMid.addTag("sourcedb:id", p.getId(), lwt);
        ImportGeomFromMifMid.addTag("building", "yes", lwt);
        ImportGeomFromMifMid.addTag("addr:city", "\u042f\u0440\u043e\u0441\u043b\u0430\u0432\u043b\u044c", lwt);
        ImportGeomFromMifMid.addTag("addr:country", "RU", lwt);
        if (!"".equals(p.getDistrictID())) {
            ImportGeomFromMifMid.addTag("addr:district", String.valueOf(p.getDistrictID()) + " \u0440\u0430\u0439\u043e\u043d", lwt);
        }
        if (!"".equals(p.getStreetID())) {
            ImportGeomFromMifMid.addTag("addr:street", p.getStreetID(), lwt);
        }
        if (!"".equals(p.getNum())) {
            ImportGeomFromMifMid.addTag("addr:housenumber", p.getNum(), lwt);
        }
        if (!"".equals(p.getEtazhnost())) {
            ImportGeomFromMifMid.addTag("building:levels", p.getEtazhnost(), lwt);
        }
    }

    public String getRPline() {
        return "  ";
    }
}

