/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.isogd.yar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ru.blok.cartography.importdata.AbstractDataProperty;
import ru.blok.cartography.importdata.AbstractDataRearedOld;
import ru.blok.cartography.importdata.importmifmid.ImportGeomFromMifMid;
import ru.blok.cartography.importdata.isogd.coordinates.Yaroslavl;
import ru.blok.cartography.importdata.isogd.yar.DataPropertyR;
import ru.infor.ws.objects.cartography.Tag;

public class DataRearedR
extends AbstractDataRearedOld {
    String admin_level;
    Yaroslavl yaroslavl = new Yaroslavl();

    public DataRearedR(File mif, File mid, String admin_level) throws IOException {
        super(mif, mid);
        this.admin_level = admin_level;
    }

    @Override
    public double[] getCoord(double x, double y) {
        double[] latlon = this.yaroslavl.local2LatLon(new double[]{y / 100.0, x / 100.0});
        return new double[]{latlon[0], latlon[1]};
    }

    @Override
    public AbstractDataProperty getPropertyFromString(String s) {
        String[] ps = s.split(";");
        DataPropertyR p = new DataPropertyR(ps[0], ps[1].replaceAll("\"", ""));
        return p;
    }

    @Override
    public void setProperty(AbstractDataProperty dp, List<Tag> lwt) {
        DataPropertyR p = (DataPropertyR)dp;
        ImportGeomFromMifMid.addTag("sourcedb:id", p.getId(), lwt);
        ImportGeomFromMifMid.addTag("admin_level", this.admin_level, lwt);
        ImportGeomFromMifMid.addTag("boundary", "administrative", lwt);
    }

    public String getRPline() {
        return "  ";
    }
}

