/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.isogd.zdanryb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ru.blok.cartography.importdata.AbstractDataProperty;
import ru.blok.cartography.importdata.AbstractDataRearedOld;
import ru.blok.cartography.importdata.importmifmid.ImportGeomFromMifMid;
import ru.blok.cartography.importdata.isogd.coordinates.Rybinsk;
import ru.blok.cartography.importdata.isogd.zdanryb.DataProperty;
import ru.infor.ws.objects.cartography.Tag;

public class DataReared
extends AbstractDataRearedOld {
    Rybinsk rybinsk = new Rybinsk();

    public DataReared(File mif, File mid) throws IOException {
        super(mif, mid);
    }

    @Override
    public String getR() {
        return "  ";
    }

    @Override
    public double[] getCoord(double x, double y) {
        double[] latlon = this.rybinsk.local2LatLon(new double[]{x * 100.0, y * 100.0});
        return new double[]{latlon[0], latlon[1]};
    }

    @Override
    public AbstractDataProperty getPropertyFromString(String s) {
        String[] ps = s.split(",");
        DataProperty p = new DataProperty(ps[0].replaceAll("\"", ""), ps[1].replaceAll("\"", ""), ps[2], ps[3].replaceAll("\"", ""), ps[4].replaceAll("\"", ""));
        return p;
    }

    @Override
    public void setProperty(AbstractDataProperty dp, List<Tag> lwt) {
        DataProperty p = (DataProperty)dp;
        ImportGeomFromMifMid.addTag("building", "yes", lwt);
        ImportGeomFromMifMid.addTag("addr:city", "\u0420\u044b\u0431\u0438\u043d\u0441\u043a", lwt);
        ImportGeomFromMifMid.addTag("addr:country", "RU", lwt);
        ImportGeomFromMifMid.addTag("addr:street", p.getStreat(), lwt);
        ImportGeomFromMifMid.addTag("addr:housenumber", p.getNumberDoma(), lwt);
        if (!"".equals(p.getEtazh())) {
            ImportGeomFromMifMid.addTag("building:levels", p.getEtazh(), lwt);
        }
        ImportGeomFromMifMid.addTag("material", p.getMaterial(), lwt);
        ImportGeomFromMifMid.addTag("appointment", p.getNazn(), lwt);
    }
}

