/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importdata.medical;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import ru.blok.cartography.importdata.medical.exportmo.Coordinat;
import ru.blok.cartography.importdata.medical.exportmo.Coordinats;
import ru.blok.cartography.importdata.medical.exportmo.MO;
import ru.blok.cartography.importdata.medical.exportmo.RootMO;
import ru.blok.cartography.importdata.medical.exportmu.Filial;
import ru.blok.cartography.importdata.medical.exportmu.Mu;
import ru.blok.cartography.importdata.medical.exportmu.Profile;
import ru.blok.cartography.importdata.medical.exportmu.Profiles;
import ru.blok.cartography.importdata.medical.exportmu.Root;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.MapEntryKeyFilter;
import ru.infor.ws.objects.cartography.NodeSearchCriteria;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.MapEntryKeyValue;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class Export {
    static NodeWSProxy proxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    static WayWSProxy wayProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);

    public static void exportMO(String fileName) {
        WaySearchCriteria sc = (WaySearchCriteria)wayProxy._getSearchCriteriaTemplate();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        MapEntryKeyValue mekv = new MapEntryKeyValue();
        mekv.setKey("enk:mo");
        mekv.setValue("yes");
        MapEntryKeyFilter mek = new MapEntryKeyFilter();
        mek.setValues(new MapEntryKeyValue[]{mekv});
        sc.setKeyFilter(new MapEntryKeyFilter[]{mek});
        sc.setHaveTags(Integer.valueOf(1));
        Object[] ways = wayProxy.getList(InitializedVariable.context, sc).getObjList();
        RootMO r = Export.putObjectToXmlMO(ways);
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{RootMO.class});
            c.createMarshaller().marshal((Object)r, (OutputStream)new FileOutputStream(fileName, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static RootMO putObjectToXmlMO(Object[] ways) {
        RootMO root = new RootMO();
        root.setType("mo");
        ArrayList<MO> l = new ArrayList<MO>();
        root.setMos(l);
        if (ways != null && ways.length > 0) {
            Object[] objectArray = ways;
            int n = ways.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Way w = wayProxy.getCurrentObject(InitializedVariable.context, ((Way)o).getId());
                l.add(Export.getMOFromWay(w));
                ++n2;
            }
        }
        return root;
    }

    private static MO getMOFromWay(Way w) {
        MO mo = new MO();
        mo.setCode_kladr(Export.getValueFromTag((AbstractMapEntry)w, "code_kladr"));
        mo.setMo_name(Export.getValueFromTag((AbstractMapEntry)w, "Name_mo"));
        if (mo.getMo_name().equals("")) {
            mo.setMo_name(Export.getValueFromTag((AbstractMapEntry)w, "name"));
        }
        mo.setMo_type(Export.getValueFromTag((AbstractMapEntry)w, "mo_type"));
        mo.setPopulation(Export.getValueFromTag((AbstractMapEntry)w, "population"));
        mo.setPopulation_density(Export.getValueFromTag((AbstractMapEntry)w, "population_density"));
        Coordinats coordinats = new Coordinats();
        mo.setCoordinats(coordinats);
        ArrayList<Coordinat> list = new ArrayList<Coordinat>();
        coordinats.setCoordinat(list);
        Node[] nodeArray = w.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            Coordinat c = new Coordinat();
            c.setLat(Double.toString(n3.getLat()));
            c.setLng(Double.toString(n3.getLon()));
            list.add(c);
            ++n2;
        }
        return mo;
    }

    public static void exportMU(String fileName) {
        NodeSearchCriteria sc = (NodeSearchCriteria)proxy._getSearchCriteriaTemplate();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        MapEntryKeyValue mekv = new MapEntryKeyValue();
        mekv.setKey("enk:hospital");
        mekv.setValue("yes");
        MapEntryKeyFilter mek = new MapEntryKeyFilter();
        mek.setValues(new MapEntryKeyValue[]{mekv});
        sc.setKeyFilter(new MapEntryKeyFilter[]{mek});
        sc.setHaveTags(Integer.valueOf(1));
        sc.setDatasourceidList(new Long[]{6002L});
        Object[] nodes = proxy.getList(InitializedVariable.context, sc).getObjList();
        Root r = Export.putObjectToXml(nodes);
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Root.class});
            c.createMarshaller().marshal((Object)r, (OutputStream)new FileOutputStream(fileName, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Root putObjectToXml(Object[] nodes) {
        Root root = new Root();
        root.setType("mu");
        ArrayList<Mu> l = new ArrayList<Mu>();
        root.setMus(l);
        if (nodes != null && nodes.length > 0) {
            Object[] objectArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Node n3 = proxy.getCurrentObject(InitializedVariable.context, ((Node)o).getId());
                l.add(Export.getMuFromNode(n3));
                ++n2;
            }
        }
        return root;
    }

    private static String getValueFromTag(AbstractMapEntry n, String key) {
        if (n != null) {
            Tag[] tagArray = n.getTags();
            int n2 = tagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Tag t = tagArray[n3];
                if (t.getKey().equals(key)) {
                    return t.getValue();
                }
                ++n3;
            }
        }
        return "";
    }

    private static Mu getMuFromNode(Node n) {
        Mu mu = new Mu();
        mu.setCode_kladr(Export.getValueFromTag((AbstractMapEntry)n, "code_kladr"));
        mu.setMu_name(Export.getValueFromTag((AbstractMapEntry)n, "mu_name"));
        mu.setMu_type(Export.getValueFromTag((AbstractMapEntry)n, "mu_type"));
        mu.setMu_level(Export.getValueFromTag((AbstractMapEntry)n, "mu_level"));
        mu.setAddress(Export.getValueFromTag((AbstractMapEntry)n, "address"));
        mu.setOms(Export.getValueFromTag((AbstractMapEntry)n, "oms"));
        mu.setOgrn(Export.getValueFromTag((AbstractMapEntry)n, "ogrn"));
        mu.setInn(Export.getValueFromTag((AbstractMapEntry)n, "inn"));
        mu.setMu_priznak(Export.getValueFromTag((AbstractMapEntry)n, "mu_priznak"));
        Filial f = new Filial();
        f.setType("0");
        mu.setFilial(f);
        Profiles fl = new Profiles();
        mu.setProfiles(fl);
        ArrayList<Profile> pfl = new ArrayList<Profile>();
        fl.setProfile(pfl);
        int i = 1;
        while (i <= 7) {
            Profile p = new Profile();
            p.setId(Integer.toString(i));
            p.setN_bed_total(Export.getValueFromTag((AbstractMapEntry)n, "profile_" + Integer.toString(i) + ":n_bed_total"));
            p.setCapacity(Export.getValueFromTag((AbstractMapEntry)n, "profile_" + Integer.toString(i) + ":capacity"));
            pfl.add(p);
            ++i;
        }
        return mu;
    }
}

