/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importviewzones;

import ru.blok.cartography.exportimport.ObjectGeom;
import ru.blok.cartography.importviewzones.ImportViewZones;
import ru.blok.cartography.mapviewer.MapValue;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class MapValuePoint
extends MapValue {
    public static int WAY = 0;
    public static int ENTERPOINT = 1;
    public static int IMPORTWAY = 2;
    int type = -1;
    public ImportViewZones zonePoint;
    Way way;
    ObjectGeom objectGeom;
    Way[] intersectionWays;
    private Way selectedWay = null;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ImportViewZones getZonePoint() {
        return this.zonePoint;
    }

    public void setZonePoint(ImportViewZones zonePoint) {
        this.zonePoint = zonePoint;
    }

    public MapValuePoint(double lat, double lon, int zoom) {
        super(lat, lon, zoom);
    }

    public Way getWay() {
        return this.way;
    }

    public void setWay(Way way) {
        this.way = way;
    }

    public ObjectGeom getObjectGeom() {
        return this.objectGeom;
    }

    public void setObjectGeom(ObjectGeom objectGeom) {
        this.objectGeom = objectGeom;
    }

    @Override
    public Double[] getMinMaxWay() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.zonePoint != null) {
            int n;
            Node[] nodeArray;
            if (this.type == 0 && this.way != null) {
                nodeArray = this.way.getNodes();
                n = nodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Node d = nodeArray[n2];
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon == null || d.getLon() > maxLon) {
                        maxLon = d.getLon();
                    }
                    ++n2;
                }
            } else if (this.type == ENTERPOINT) {
                for (Node d : this.zonePoint.getNodes()) {
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon != null && !(d.getLon() > maxLon)) continue;
                    maxLon = d.getLon();
                }
            } else if (this.type == IMPORTWAY && this.objectGeom != null) {
                for (Way w : this.objectGeom.getListWay()) {
                    Node[] nodeArray2 = w.getNodes();
                    int n3 = nodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Node d = nodeArray2[n4];
                        if (minLat == null || d.getLat() < minLat) {
                            minLat = d.getLat();
                        }
                        if (maxLat == null || d.getLat() > maxLat) {
                            maxLat = d.getLat();
                        }
                        if (minLon == null || d.getLon() < minLon) {
                            minLon = d.getLon();
                        }
                        if (maxLon == null || d.getLon() > maxLon) {
                            maxLon = d.getLon();
                        }
                        ++n4;
                    }
                }
                for (Node d : this.objectGeom.getListNode()) {
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon != null && !(d.getLon() > maxLon)) continue;
                    maxLon = d.getLon();
                }
            }
            if (this.intersectionWays != null) {
                nodeArray = this.intersectionWays;
                n = this.intersectionWays.length;
                int n5 = 0;
                while (n5 < n) {
                    Way w;
                    w = nodeArray[n5];
                    Node[] nodeArray3 = w.getNodes();
                    int n6 = nodeArray3.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Node d = nodeArray3[n7];
                        if (minLat == null || d.getLat() < minLat) {
                            minLat = d.getLat();
                        }
                        if (maxLat == null || d.getLat() > maxLat) {
                            maxLat = d.getLat();
                        }
                        if (minLon == null || d.getLon() < minLon) {
                            minLon = d.getLon();
                        }
                        if (maxLon == null || d.getLon() > maxLon) {
                            maxLon = d.getLon();
                        }
                        ++n7;
                    }
                    ++n5;
                }
            }
            if (minLat == null) {
                return null;
            }
            return new Double[]{minLat, maxLat, minLon, maxLon};
        }
        return null;
    }

    public Way[] getIntersectionWays() {
        return this.intersectionWays;
    }

    public void setIntersectionWays(Way[] intersectionWays) {
        this.intersectionWays = intersectionWays;
    }

    public Way getSelectedWay() {
        return this.selectedWay;
    }

    public void setSelectedWay(Way selectedWay) {
        this.selectedWay = selectedWay;
    }
}

