/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.importviewzones.maps;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.exportimport.ObjectGeom;
import ru.blok.cartography.importviewzones.MapValuePoint;
import ru.blok.cartography.mapviewer.painter.WayPainter;
import ru.blok.cartography.mapviewer.painter.WayViewSettings;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class NodePainter<T extends JXMapViewer>
extends WayPainter<T> {
    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        block12: {
            ObjectGeom o;
            Rectangle2D.Double vp3;
            Rectangle2D.Double vp2;
            block13: {
                block11: {
                    if (this.value == null) {
                        return;
                    }
                    Rectangle viewportBounds = map.getViewportBounds();
                    int zoom = map.getZoom();
                    Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
                    int tileSize = map.getTileFactory().getTileSize(zoom);
                    Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
                    double vpx = viewportBounds.getX();
                    while (vpx < 0.0) {
                        vpx += sizeInPixels.getWidth();
                    }
                    while (vpx > sizeInPixels.getWidth()) {
                        vpx -= sizeInPixels.getWidth();
                    }
                    vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
                    vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
                    if (((MapValuePoint)this.value).getIntersectionWays() != null) {
                        WayViewSettings v = new WayViewSettings();
                        v.setColorLine(Color.GREEN);
                        WayViewSettings vS = new WayViewSettings();
                        vS.setColorLine(Color.GREEN);
                        vS.setStroke(new BasicStroke(5.0f, 1, 1));
                        Way select = ((MapValuePoint)this.value).getSelectedWay();
                        Way[] wayArray = ((MapValuePoint)this.value).getIntersectionWays();
                        int n = wayArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Way w = wayArray[n2];
                            if (w.equals((Object)select)) {
                                super.paintTrack(w, map, g, vp2, vp3, vS);
                            } else {
                                super.paintTrack(w, map, g, vp2, vp3, v);
                            }
                            ++n2;
                        }
                    }
                    if (((MapValuePoint)this.value).getType() != MapValuePoint.WAY) break block11;
                    super.paintTrack(((MapValuePoint)this.value).getWay(), map, g, vp2, vp3, this.value.getWayViewSetting());
                    break block12;
                }
                if (((MapValuePoint)this.value).getType() != MapValuePoint.ENTERPOINT) break block13;
                if (this.value == null || ((MapValuePoint)this.value).zonePoint.getNodes() == null || ((MapValuePoint)this.value).zonePoint.getNodes().size() <= 0) break block12;
                int from = 0;
                List<Node> nn = ((MapValuePoint)this.value).zonePoint.getNodes();
                Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(nn.get(from).getLat(), nn.get(from).getLon()), map.getZoom());
                g.setColor(Color.red);
                this.paintPoint(pointFrom, map, g, vp2, vp3);
                int i = 1;
                while (i < nn.size()) {
                    Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(nn.get(i).getLat(), nn.get(i).getLon()), map.getZoom());
                    this.paint(pointFrom, pointTo, map, g, vp2, vp3);
                    from = i++;
                    pointFrom = pointTo;
                    this.paintPoint(pointFrom, map, g, vp2, vp3);
                }
                break block12;
            }
            if (((MapValuePoint)this.value).getType() == MapValuePoint.IMPORTWAY && (o = ((MapValuePoint)this.value).getObjectGeom()) != null) {
                for (Way w : o.getListWay()) {
                    super.paintTrack(w, map, g, vp2, vp3, this.value.getWayViewSetting());
                }
                for (Node n : o.getListNode()) {
                    Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(n.getLat(), n.getLon()), map.getZoom());
                    this.paintPoint(point, map, g, vp2, vp3);
                }
            }
        }
    }

    @Override
    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
        }
    }

    protected void paintPoint(Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(point)) {
            g.fillOval((int)(point.getX() - vp2.getX()) - 2, (int)(point.getY() - vp2.getY()) - 2, 5, 5);
        }
        if (vp3.contains(point) || vp3.contains(point)) {
            g.fillOval((int)(point.getX() - vp3.getX()) - 2, (int)(point.getY() - vp3.getY()) - 2, 5, 5);
        }
    }
}

