/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.josm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jxmapviewer.viewer.GeoPosition;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.cartography.josm.JosmMainApp;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.MapEntryKeyFilter;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class GeometryDataSet
extends DataSet {
    WayWSProxy proxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    NodeWSProxy nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    org.openstreetmap.josm.data.osm.Way wayJosm;
    Way way;
    ArrayList<org.openstreetmap.josm.data.osm.Way> col = new ArrayList();

    public GeometryDataSet(Way way) throws SQLException {
        this.way = way;
        this.analysGeom(way.getGeom());
    }

    private org.openstreetmap.josm.data.osm.Way addgeom(Geometry p) {
        this.wayJosm = new org.openstreetmap.josm.data.osm.Way();
        int i = 0;
        while (i < p.numPoints() - 1) {
            Point pp = p.getPoint(i);
            org.openstreetmap.josm.data.osm.Node trackNode = new org.openstreetmap.josm.data.osm.Node(new LatLon(pp.getY(), pp.getX()));
            this.addPrimitive((OsmPrimitive)trackNode);
            this.wayJosm.addNode(trackNode);
            ++i;
        }
        Point pp = p.getPoint(p.numPoints() - 1);
        if (pp.equals(p.getPoint(0))) {
            this.wayJosm.addNode(this.wayJosm.getNode(0));
        } else {
            org.openstreetmap.josm.data.osm.Node trackNode = new org.openstreetmap.josm.data.osm.Node(new LatLon(pp.getY(), pp.getX()));
            this.addPrimitive((OsmPrimitive)trackNode);
            this.wayJosm.addNode(trackNode);
        }
        this.addPrimitive((OsmPrimitive)this.wayJosm);
        return this.wayJosm;
    }

    public org.openstreetmap.josm.data.osm.Way analysGeom(String geom) {
        if (geom != null) {
            Object p = null;
            try {
                p = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : (geom.toLowerCase().indexOf("LINESTRING".toLowerCase()) > -1 ? new LineString(geom) : new Polygon(geom));
            }
            catch (Exception exception) {}
            this.col.clear();
            if (p instanceof MultiPolygon) {
                Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
                int n = polygonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Polygon pol = polygonArray[n2];
                    this.col.add(this.addgeom((Geometry)pol));
                    ++n2;
                }
            } else {
                this.col.add(this.addgeom((Geometry)p));
            }
            this.setSelected(this.col);
            return this.col.get(0);
        }
        return null;
    }

    public void analysGeomWithTag(Way ww) {
        if (ww.getGeom() != null) {
            org.openstreetmap.josm.data.osm.Way w = this.analysGeom(ww.getGeom());
            if (ww.getTags() != null) {
                Tag[] tagArray = ww.getTags();
                int n = tagArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Tag t = tagArray[n2];
                    w.put(t.getKey(), t.getValue());
                    ++n2;
                }
            }
        }
    }

    public Collection<org.openstreetmap.josm.data.osm.Way> getWays() {
        return this.col;
    }

    public org.openstreetmap.josm.data.osm.Way getWay() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.col.get(0);
    }

    public void save() {
        boolean ok;
        org.openstreetmap.josm.data.osm.Way[] tracks = null;
        if (this.getSelectedWays().size() == 0) {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is null");
        } else {
            tracks = this.getSelectedWays().toArray(new org.openstreetmap.josm.data.osm.Way[0]);
            this.wayJosm = tracks[0];
        }
        if (tracks != null && (ok = true) && tracks.length == 1) {
            ArrayList<Long> ll = new ArrayList<Long>();
            ArrayList<Node> lNode = new ArrayList<Node>();
            int i = 0;
            while (i < this.wayJosm.getNodesCount()) {
                Node nn;
                org.openstreetmap.josm.data.osm.Node n = this.wayJosm.getNode(i);
                if (n.getId() > 0L) {
                    nn = this.nodeWSProxy.getCurrentObject(InitializedVariable.context, Long.valueOf(n.getId()));
                } else {
                    nn = new Node();
                    nn.setCurrentVersion(Integer.valueOf(1));
                }
                nn.setLat(n.getCoor().lat());
                nn.setLon(n.getCoor().lon());
                nn = this.nodeWSProxy.save(InitializedVariable.context, nn);
                ll.add(nn.getId());
                lNode.add(nn);
                ++i;
            }
            this.way.setNodes(lNode.toArray(new Node[0]));
            this.way = this.proxy.save(InitializedVariable.context, this.way);
            this.nodeWSProxy.rebuildGeomList(InitializedVariable.context, ll.toArray(new Long[0]));
            this.proxy.rebuildGeom(InitializedVariable.context, this.way.getId());
        }
    }

    public void addToMapObjectByTag(MapEntryKeyFilter mek, JosmMainApp app) {
        WaySearchCriteria sc = (WaySearchCriteria)this.proxy._getSearchCriteriaTemplate();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setKeyFilter(new MapEntryKeyFilter[]{mek});
        sc.setHaveTags(Integer.valueOf(1));
        StringBuilder st = new StringBuilder();
        MapView mv = Main.map.mapView;
        Bounds currentBounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        GeoPosition point1 = new GeoPosition(currentBounds.getMax().lat(), currentBounds.getMin().lon());
        GeoPosition point2 = new GeoPosition(currentBounds.getMin().lat(), currentBounds.getMax().lon());
        st.append("POLYGON((").append(point1.getLongitude()).append(" ").append(point1.getLatitude()).append(", ").append(point2.getLongitude()).append(" ").append(point1.getLatitude()).append(", ").append(point2.getLongitude()).append(" ").append(point2.getLatitude()).append(", ").append(point1.getLongitude()).append(" ").append(point2.getLatitude()).append(", ").append(point1.getLongitude()).append(" ").append(point1.getLatitude()).append("))");
        sc.setGeom(st.toString());
        Object[] oo = this.proxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Way w = this.proxy.getCurrentObject(InitializedVariable.context, ((Way)o).getId());
                this.analysGeomWithTag(w);
                ++n2;
            }
        }
    }
}

