/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.josm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.xml.bind.JAXBException;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import ru.blok.cartography.josm.BuferDialog;
import ru.blok.cartography.josm.GeometryDataSet;
import ru.blok.cartography.josm.WMSLayer;
import ru.blok.cartography.mapviewer.providertiles.DefaultProvider;
import ru.blok.cartography.mapviewer.providertiles.ProviderInfo;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.dialog.CommonMessage;
import ru.infor.beanviewer.dialog.MessageCancelButton;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.cartography.entities.Way;

public class JosmMainApp
extends Main {
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";
    protected static WMSLayer layer2;
    protected static DataSet ds;
    protected static JosmMainApp main_josm;

    protected void initMenu(JMenu sysmenu, final String keyPage) {
        JMenuItem mi2 = new JMenuItem("\u0412\u044b\u0431\u043e\u0440 \u043a\u0430\u0440\u0442\u044b");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingMap m = new SettingMap();
                m.setProvidersInfo((ProviderInfo)layer2.getUIProperties());
                MessageOKButton b = new MessageOKButton(){

                    public void actionPerformed(Object message) {
                        ((PanelContext)this.getContext()).getPanel().updateMainObject();
                        ProviderInfo p = ((SettingMap)((Object)((PanelContext)this.getContext()).getPanel().getObject())).getProvidersInfo();
                        if (layer2 != null) {
                            layer2.setUIProperties(p);
                            Main.map.repaint();
                        }
                        if (PropertyManager.getSaver() != null) {
                            try {
                                String key = String.valueOf(WMSLayer.class.toString()) + "maps";
                                PropertyManager.getSaver().save(key, PropertyManager.propertiesToXML((Object)layer2.getUIProperties()));
                            }
                            catch (JAXBException e) {
                                e.printStackTrace();
                            }
                        }
                        super.actionPerformed(message);
                    }
                };
                InitializedVariable.getFactory((String)keyPage).runMessageEx(keyPage, "", (Object)m, new BeanViewerAction[]{b, new MessageCancelButton()});
            }
        });
        sysmenu.add(mi2);
        mi2 = new JMenuItem("\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0434\u043b\u044f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043b\u0438\u043d\u0438\u0439");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BuferDialog dlg = new BuferDialog();
                ExtendedDialog d = new ExtendedDialog(Main.parent, "\u0414\u0430\u043d\u043d\u044b\u0435", new String[]{I18n.tr((String)"Apply", (Object[])new Object[]{""}), I18n.tr((String)"Cancel", (Object[])new Object[]{""})});
                d.setContent((Component)dlg);
                d.showDialog();
                int answer = d.getValue();
                if (answer == 1 && (OsmDataLayer)Main.map.mapView.getActiveLayer() != null) {
                    Double z = dlg.getThickness();
                    OsmDataLayer l = (OsmDataLayer)Main.map.mapView.getActiveLayer();
                    Collection ww = l.data.getSelectedWays();
                    if (ww != null && ww.size() > 0) {
                        GeometryFactory f = new GeometryFactory();
                        try {
                            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
                            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
                            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
                            for (org.openstreetmap.josm.data.osm.Way w : ww) {
                                Coordinate[] cc = new Coordinate[w.getNodesCount()];
                                int i = 0;
                                while (i < w.getNodesCount()) {
                                    GeneralDirectPosition pt1 = new GeneralDirectPosition(w.getNode(i).getCoor().lon(), w.getNode(i).getCoor().lat());
                                    DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                                    cc[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                                    ++i;
                                }
                                LineString s = f.createLineString(cc);
                                Geometry buffer = s.buffer(z.doubleValue());
                                if (!(buffer instanceof Polygon)) continue;
                                Polygon p = (Polygon)buffer;
                                org.openstreetmap.josm.data.osm.Way w2 = new org.openstreetmap.josm.data.osm.Way();
                                int i2 = 0;
                                while (i2 < p.getCoordinates().length - 1) {
                                    Coordinate c = p.getCoordinates()[i2];
                                    GeneralDirectPosition pt1 = new GeneralDirectPosition(c.x, c.y);
                                    DirectPosition pt2 = math2.transform((DirectPosition)pt1, null);
                                    Node n = new Node(new LatLon(pt2.getCoordinate()[1], pt2.getCoordinate()[0]));
                                    l.data.addPrimitive((OsmPrimitive)n);
                                    w2.addNode(n);
                                    ++i2;
                                }
                                w2.addNode(w2.getNode(0));
                                l.data.addPrimitive((OsmPrimitive)w2);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        sysmenu.add(mi2);
    }

    public JosmMainApp(final JFrame mainFrame, String keyPage) {
        Component[] componentArray = panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof GettingStarted) {
                panel.remove(component);
            }
            ++n2;
        }
        this.menu.remove((Component)this.menu.fileMenu);
        this.menu.remove((Component)this.menu.audioMenu);
        this.menu.remove((Component)this.menu.presetsMenu);
        this.menu.remove((Component)this.menu.helpMenu);
        JMenu sysmenu = this.menu.addMenu("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", 83, 0, null);
        this.initMenu(sysmenu, keyPage);
        JMenuItem mi1 = new JMenuItem("\u0412\u044b\u0445\u043e\u0434");
        mi1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.setVisible(false);
            }
        });
        sysmenu.add(mi1);
        toolbar.refreshToolbarControl();
    }

    public static void initCommon(JFrame m) {
        Main.pref = new Preferences();
        I18n.init();
        Main.determinePlatformHook();
        Main.pref.init(false);
        Main.pref.updateSystemProperties();
        MainApplication.preConstructorInit(new HashMap());
        Main.parent = m;
        Main.addListener();
    }

    public static void initFinal(JFrame m) {
        MainApplication.toolbar.refreshToolbarControl();
        m.setContentPane(contentPanePrivate);
        m.setJMenuBar((JMenuBar)JosmMainApp.main_josm.menu);
        if (!m.isVisible()) {
            m.setVisible(true);
        } else {
            m.validate();
            m.toFront();
        }
        m.setExtendedState(6);
    }

    public static void init(JFrame m, String keyPage) {
        if (main_josm == null) {
            JosmMainApp.initCommon(m);
            main_josm = new JosmMainApp(m, keyPage);
        }
        JosmMainApp.initFinal(m);
    }

    public static void initLayer(Way w, String name, String keyPage) {
        Layer current = null;
        Layer osm = null;
        if (main_josm != null && map != null && JosmMainApp.map.mapView != null && JosmMainApp.map.mapView.getAllLayers() != null) {
            for (Layer layer : JosmMainApp.map.mapView.getAllLayers()) {
                if (layer.getName().equals(name)) {
                    current = layer;
                }
                if (!(layer instanceof WMSLayer)) continue;
                osm = layer;
            }
        }
        if (current != null) {
            main_josm.removeLayer(current);
        }
        try {
            ds = new GeometryDataSet(w);
            main_josm.addLayer((Layer)new OsmDataLayer(ds, name, null));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (osm == null) {
            layer2 = new WMSLayer(keyPage);
            main_josm.addLayer(layer2);
        }
        if (((GeometryDataSet)ds).getWay() != null) {
            main_josm.getCurrentDataSet().setSelected(ds.getWays());
            JosmMainApp.map.mapView.zoomTo(((GeometryDataSet)ds).getWay().getNode(0).getCoor());
        } else {
            Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.workplaceId);
            Node n = new Node(new LatLon(coord[0].doubleValue(), coord[1].doubleValue()));
            ds.addPrimitive((OsmPrimitive)n);
            main_josm.getCurrentDataSet().setSelected(new PrimitiveId[]{n});
        }
    }

    @ListView(views={@View(title="", layoutKeys={"dialogLayoutManager"})})
    public static class SettingMap
    extends CommonMessage {
        ProviderInfo providersInfo;

        @ListField(fields={@Field(order=10, title="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", viewer={DefaultProvider.AbstractDefaultProvidersViewer.class})})
        public ProviderInfo getProvidersInfo() {
            return this.providersInfo;
        }

        public void setProvidersInfo(ProviderInfo providersInfo) {
            this.providersInfo = providersInfo;
        }
    }
}

