/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapentrykey.editortags;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.entities.AbstractMapEntry;
import ru.infor.ws.objects.cartography.entities.Node;

public class PrimitiveDataSet
extends DataSet {
    WayWSProxy wayWSProxy;
    NodeWSProxy nodeWSProxy;
    Way wayJosm;
    org.openstreetmap.josm.data.osm.Node nodeJosm;
    AbstractMapEntry primitive;
    static Integer NODE = 0;
    static Integer WAY = 1;
    private Integer type;
    String keyPage;
    ArrayList<OsmPrimitive> col = new ArrayList();

    public PrimitiveDataSet(String keyPage) {
        this.keyPage = keyPage;
    }

    public PrimitiveDataSet(AbstractMapEntry primitive, String keyPage) throws SQLException {
        this.keyPage = keyPage;
        this.wayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(ru.infor.ws.objects.cartography.entities.Way.class, (String)keyPage);
        this.nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class, (String)keyPage);
        this.primitive = primitive;
        this.wayJosm = null;
        this.nodeJosm = null;
        if (primitive instanceof Node) {
            this.type = NODE;
            this.nodeJosm = new org.openstreetmap.josm.data.osm.Node();
            this.nodeJosm.setOsmId(primitive.getId().longValue(), 1);
            Node nn = (Node)primitive;
            this.nodeJosm.setCoor(new LatLon(nn.getLat(), nn.getLon()));
            this.col.clear();
            this.addPrimitive((OsmPrimitive)this.nodeJosm);
            this.col.add((OsmPrimitive)this.nodeJosm);
            this.setSelected(this.col);
        } else {
            this.type = WAY;
            ru.infor.ws.objects.cartography.entities.Way ww = (ru.infor.ws.objects.cartography.entities.Way)primitive;
            this.wayJosm = new Way();
            this.wayJosm.setOsmId(ww.getId().longValue(), 1);
            int i = 0;
            while (i < ww.getNodes().length - 1) {
                Node nn = ww.getNodes()[i];
                org.openstreetmap.josm.data.osm.Node trackNode = new org.openstreetmap.josm.data.osm.Node(new LatLon(nn.getLat(), nn.getLon()));
                trackNode.setOsmId(nn.getId().longValue(), 1);
                this.addPrimitive((OsmPrimitive)trackNode);
                this.wayJosm.addNode(trackNode);
                ++i;
            }
            Node nn = ww.getNodes()[ww.getNodes().length - 1];
            if (nn.equals((Object)ww.getNodes()[0])) {
                this.wayJosm.addNode(this.wayJosm.getNode(0));
            } else {
                org.openstreetmap.josm.data.osm.Node trackNode = new org.openstreetmap.josm.data.osm.Node(new LatLon(nn.getLat(), nn.getLon()));
                trackNode.setOsmId(nn.getId().longValue(), 1);
                this.addPrimitive((OsmPrimitive)trackNode);
                this.wayJosm.addNode(trackNode);
            }
            this.col.clear();
            this.addPrimitive((OsmPrimitive)this.wayJosm);
            this.col.add((OsmPrimitive)this.wayJosm);
            this.setSelected(this.col);
        }
    }

    public Collection<OsmPrimitive> getOsmPrimitives() {
        return this.col;
    }

    public OsmPrimitive getOsmPrimitive() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.col.get(0);
    }

    public void save() {
        if (this.type == NODE) {
            org.openstreetmap.josm.data.osm.Node[] tracks = null;
            if (this.getSelectedNodes().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected node is null");
            } else {
                tracks = this.getSelectedNodes().toArray(new org.openstreetmap.josm.data.osm.Node[0]);
            }
            if (tracks != null) {
                this.nodeJosm = tracks[0];
                ((Node)this.primitive).setLat(this.nodeJosm.getCoor().lat());
                ((Node)this.primitive).setLon(this.nodeJosm.getCoor().lon());
                this.primitive = this.nodeWSProxy.save(InitializedVariable.getContext((String)this.keyPage), (Node)this.primitive);
                this.nodeWSProxy.rebuildGeom(InitializedVariable.getContext((String)this.keyPage), this.primitive.getId());
            }
        } else {
            boolean ok;
            Way[] tracks = null;
            if (this.getSelectedWays().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected way is null");
            } else {
                tracks = this.getSelectedWays().toArray(new Way[0]);
                this.wayJosm = tracks[0];
            }
            if (tracks != null && (ok = true) && tracks.length == 1) {
                ArrayList<Long> ll = new ArrayList<Long>();
                ArrayList<Node> lNode = new ArrayList<Node>();
                int i = 0;
                while (i < this.wayJosm.getNodesCount()) {
                    org.openstreetmap.josm.data.osm.Node n = this.wayJosm.getNode(i);
                    Node nn = n.getId() > 0L ? this.nodeWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.keyPage), Long.valueOf(n.getId())) : new Node();
                    nn.setLat(n.getCoor().lat());
                    nn.setLon(n.getCoor().lon());
                    nn = this.nodeWSProxy.save(InitializedVariable.getContext((String)this.keyPage), nn);
                    ll.add(nn.getId());
                    lNode.add(nn);
                    ++i;
                }
                ((ru.infor.ws.objects.cartography.entities.Way)this.primitive).setNodes(lNode.toArray(new Node[0]));
                this.primitive = this.wayWSProxy.save(InitializedVariable.getContext((String)this.keyPage), (ru.infor.ws.objects.cartography.entities.Way)this.primitive);
                this.nodeWSProxy.rebuildGeomList(InitializedVariable.getContext((String)this.keyPage), ll.toArray(new Long[0]));
                this.wayWSProxy.rebuildGeom(InitializedVariable.getContext((String)this.keyPage), this.primitive.getId());
            }
        }
    }
}

