/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapnik.definition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.cartography.ConnectionParameterWSProxy;
import ru.infor.client.soap.proxy.cartography.FontSetWSProxy;
import ru.infor.client.soap.proxy.cartography.LayerWSProxy;
import ru.infor.client.soap.proxy.cartography.MapnikDefinitionWSProxy;
import ru.infor.client.soap.proxy.cartography.RuleWSProxy;
import ru.infor.client.soap.proxy.cartography.StyleWSProxy;
import ru.infor.ws.objects.cartography.entities.AbstractTag;
import ru.infor.ws.objects.cartography.entities.ConnectionParameter;
import ru.infor.ws.objects.cartography.entities.FontSet;
import ru.infor.ws.objects.cartography.entities.Layer;
import ru.infor.ws.objects.cartography.entities.MapnikDefinition;
import ru.infor.ws.objects.cartography.entities.Rule;
import ru.infor.ws.objects.cartography.entities.Style;
import ru.infor.ws.objects.cartography.entities.ext.MapnikDefinitionExt;

public class MapnikDefinitionSaveBtn
extends BeanViewerAction<ViewerContext> {
    MapnikDefinitionWSProxy proxy;
    FontSetWSProxy proxyFontSet;
    StyleWSProxy proxyStyle;
    LayerWSProxy proxyLayer;
    RuleWSProxy proxyRule;
    ConnectionParameterWSProxy proxyConn;

    public void actionPerformed(Object message) {
        this.proxy = (MapnikDefinitionWSProxy)CurrentProxyFactory.getProxy(MapnikDefinition.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        this.proxyFontSet = (FontSetWSProxy)CurrentProxyFactory.getProxy(FontSet.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        this.proxyStyle = (StyleWSProxy)CurrentProxyFactory.getProxy(Style.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        this.proxyLayer = (LayerWSProxy)CurrentProxyFactory.getProxy(Layer.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        this.proxyRule = (RuleWSProxy)CurrentProxyFactory.getProxy(Rule.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        this.proxyConn = (ConnectionParameterWSProxy)CurrentProxyFactory.getProxy(ConnectionParameter.class, (String)((ViewerContext)this.getContext()).getKeyPage());
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        List list = ((ViewerContext)this.getContext()).getPresentator().getSelectedItems();
        if (list == null) {
            return;
        }
        MapnikDefinitionExt md = (MapnikDefinitionExt)((Object)list.get(0));
        md = (MapnikDefinitionExt)this.proxy.getCurrentObject(InitializedVariable.getContext((String)((ViewerContext)this.getContext()).getKeyPage()), md.getId());
        String fileName = String.valueOf(md.getName()) + ".xml";
        this.exportData(md, fileName);
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
    }

    private void exportData(MapnikDefinitionExt md, String fileName) {
        try {
            PrintWriter xml = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(fileName).getAbsoluteFile())));
            xml.println("<!DOCTYPE Map [");
            xml.println("");
            xml.println("]>");
            xml.println("<!--");
            xml.println("    " + md.getDescription());
            xml.println("-->");
            xml.println("<Map");
            if (md.getTags() != null && md.getTags().length > 0) {
                this.writeMDTags(xml, (AbstractTag[])md.getTags());
            }
            xml.println(">");
            if (md.getFontsets() != null && md.getFontsets().length > 0) {
                this.writeMDTags(xml, md.getFontsets());
            }
            ArrayList<Style> listStyle = new ArrayList<Style>();
            if (md.getLayers() != null && md.getLayers().length > 0) {
                int i = 0;
                while (i < md.getLayers().length) {
                    if (!listStyle.contains(md.getLayers()[i].getStyle())) {
                        listStyle.add(md.getLayers()[i].getStyle());
                    }
                    ++i;
                }
                this.writeMDStyles(xml, listStyle);
                this.writeMDLayers(xml, md.getLayers());
            }
            xml.println("");
            xml.println("");
            xml.println("");
            xml.println("");
            xml.println("</Map>");
            xml.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private void writeMDLayers(PrintWriter xml, Layer[] layers) {
        int i = 0;
        while (i < layers.length) {
            ConnectionParameter curObj;
            Layer lay = this.proxyLayer.getCurrentObject(InitializedVariable.context, layers[i].getId());
            xml.println(" <Layer name=" + this.edgingQuotes(lay.getName()) + " srs=" + this.edgingQuotes(lay.getSrs().getDescription()));
            if (lay.getTags() != null && lay.getTags().length > 0) {
                this.writeMDTags(xml, (AbstractTag[])lay.getTags());
            }
            xml.println("      >");
            xml.println("  <StyleName>" + lay.getStyle().getName() + "</StyleName>");
            xml.println("  <Datasource>");
            if (lay.getDatasource() != null && lay.getDatasource().length > 0) {
                this.writeMDTags3(xml, (AbstractTag[])lay.getDatasource());
            }
            if (lay.getConnectionParameter() != null && (curObj = this.proxyConn.getCurrentObject(InitializedVariable.getContext((String)((ViewerContext)this.getContext()).getKeyPage()), lay.getConnectionParameter().getId())).getTags() != null && curObj.getTags().length > 0) {
                this.writeMDTags3(xml, (AbstractTag[])curObj.getTags());
            }
            xml.println("  </Datasource>");
            xml.println(" </Layer>");
            ++i;
        }
    }

    private void writeMDStyles(PrintWriter xml, List<Style> listStyle) {
        int i = 0;
        while (i < listStyle.size()) {
            Style style = this.proxyStyle.getCurrentObject(InitializedVariable.getContext((String)((ViewerContext)this.getContext()).getKeyPage()), listStyle.get(i).getId());
            xml.println(" <Style name=" + this.edgingQuotes(style.getName()) + ">");
            int j = 0;
            while (j < style.getRules().length) {
                xml.println("  <Rule>");
                Rule rule = this.proxyRule.getCurrentObject(InitializedVariable.getContext((String)((ViewerContext)this.getContext()).getKeyPage()), style.getRules()[j].getId());
                this.writeMDTags2(xml, (AbstractTag[])rule.getTags());
                xml.println("  </Rule>");
                ++j;
            }
            xml.println(" </Style>");
            ++i;
        }
    }

    private void writeMDTags(PrintWriter xml, FontSet[] fontsets) {
        int i = 0;
        while (i < fontsets.length) {
            xml.println(" <FontSet name=" + this.edgingQuotes(fontsets[i].getName()) + ">");
            FontSet curObj = this.proxyFontSet.getCurrentObject(InitializedVariable.getContext((String)((ViewerContext)this.getContext()).getKeyPage()), fontsets[i].getId());
            if (curObj.getTags() != null && curObj.getTags().length > 0) {
                xml.println("  <Font " + curObj.getTags()[0].getKey() + "=" + this.edgingQuotes(curObj.getTags()[0].getValue()) + "/>");
            }
            xml.println(" </FontSet>");
            ++i;
        }
    }

    private void writeMDTags(PrintWriter xml, AbstractTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            xml.println("   " + tags[i].getKey() + "=" + this.edgingQuotes(tags[i].getValue()));
            ++i;
        }
    }

    private void writeMDTags2(PrintWriter xml, AbstractTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getValue().indexOf("\"") > -1) {
                xml.println("   <" + tags[i].getKey() + " " + tags[i].getValue() + " />");
            } else {
                xml.println("   <" + tags[i].getKey() + ">" + tags[i].getValue() + "</" + tags[i].getKey() + ">");
            }
            ++i;
        }
    }

    private void writeMDTags3(PrintWriter xml, AbstractTag[] tags) {
        int i = 0;
        while (i < tags.length) {
            String st = "   <Parameter name=" + this.edgingQuotes(tags[i].getKey());
            st = tags[i].getValue() == null || tags[i].getValue().trim().equals("") ? String.valueOf(st) + "/>" : String.valueOf(st) + ">" + tags[i].getValue().trim() + "</Parameter>";
            xml.println(st);
            ++i;
        }
    }

    private String edgingQuotes(String st) {
        if (st == null || st.trim().equals("")) {
            return "\"\"";
        }
        st = st.replaceAll("\"", "'");
        return "\"" + st + "\"";
    }

    public String getHint() {
        return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438";
    }

    public String getIcon() {
        return ResourceStrings.btFileSave;
    }
}

