/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapnik.rule;

import java.util.logging.Logger;
import ru.blok.cartography.mapnik.rule.RuleList;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.cartography.AbstractMapnikEntrySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Rule;
import ru.infor.ws.objects.cartography.entities.ext.RuleExt;
import ru.infor.ws.objects.core.SortObject;

public class RulesListViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    private Rule[] listObj;

    public Class getTableCellViewerClass() {
        return RulesListCellViewer.class;
    }

    public RulesListViewer(UIFactory<T> factory) {
        super(factory);
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((AbstractMapnikEntrySearchCriteria)sc).setQuickSearch(value);
        sc.appendSorting(SortObject.getInstance((String)"name", (String)SortObject.DIRECTION_ASC));
        return sc;
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(Rule.class);
    }

    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof Rule) {
            this.listObj = new Rule[]{(Rule)o};
        }
        return this.listObj;
    }

    public void setValue(Object object) {
        this.listObj = object instanceof Rule ? new Rule[]{(Rule)object} : (Rule[])object;
        super.setValue((Object)this.valueToString(object));
    }

    public String valueToString(Object value) {
        if (this.listObj == null) {
            return "";
        }
        if (this.listObj.length == 1) {
            return this.objectToString(this.listObj[0]);
        }
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 (" + this.listObj.length + " \u0448\u0442.)";
    }

    public String objectToString(Object o) {
        if (o == null || o instanceof String && ((String)o).trim() == "") {
            return "";
        }
        return ((RuleExt)((Object)o)).getFullName();
    }

    public void buttonActionPerfomed() {
        try {
            RuleList list = new RuleList();
            this.getFactory().newPage(Rule.class, RuleList.class, (Object)list, this.getViewerContext(), "filterInListRules");
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class RulesListCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public RulesListCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((RuleExt)((Object)object)).getFullName()));
        }
    }
}

