/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.maps.importyarhouse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.postgis.LineString;
import org.postgis.Point;
import ru.blok.cartography.maps.importyarhouse.HouseFileReared;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.RemoverButtonInAsyncList;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

@ListView(views={@View(title="\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u043c\u043e\u0432", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class ImportYarHouse {
    private String mif = "/home/kraportova/\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b/osm/yar2/\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0437\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438-\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0437\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438.mif";
    private String mid = "/home/kraportova/\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b/osm/yar2/\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0437\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438-\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0437\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438.mid";
    private List<Way> ways = new ArrayList<Way>();
    private WayWSProxy wsProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    private Imp imp = new Imp();
    private Read read = new Read();

    public void reloadW() {
        WaySearchCriteria sc = (WaySearchCriteria)this.wsProxy._getSearchCriteriaTemplate();
        Object[] oo = this.wsProxy.getList(InitializedVariable.context, sc).getObjList();
        this.ways.clear();
        if (oo != null) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.ways.add((Way)o);
                ++n2;
            }
        }
    }

    @ListField(fields={@Field(title="Ways", order=100, propertiesLayout="0#span#wrap, spanx", content=Way.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=BeanViewerAction.Editor.class, doubleclick=true), @ActionField(clazz=RemoverButtonInAsyncList.class, doubleclick=true)})})})
    public List<Way> getWays() {
        return this.ways;
    }

    public void setWays(List<Way> ways) {
        this.ways = ways;
    }

    public Way editWays(Way way) {
        return this.wsProxy.getCurrentObject(InitializedVariable.context, way.getId());
    }

    public void removeWays(Way way) {
        this.wsProxy.delete(InitializedVariable.context, way.getId());
    }

    @ListField(fields={@Field(title="", order=90, viewer={ActionButton.class}, propertiesLayout="0")})
    public Read getRead() {
        return this.read;
    }

    @ListField(fields={@Field(title="Mif file", order=10, propertiesLayout="0/wrap 2")})
    public String getMif() {
        return this.mif;
    }

    public void setMif(String mif) {
        this.mif = mif;
    }

    @ListField(fields={@Field(title="Mid file", order=20, propertiesLayout="0")})
    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    @ListField(fields={@Field(title="", order=30, viewer={ActionButton.class}, propertiesLayout="0")})
    public Imp getImp() {
        return this.imp;
    }

    public void reload(String mif, String mid) {
        try {
            HouseFileReared.House h;
            HouseFileReared fileReared = new HouseFileReared(new File(mif), new File(mid));
            int i = 0;
            int k = 5;
            while ((h = fileReared.getNextHouse()) != null && i < k) {
                ++i;
                for (HouseFileReared.Way2 w : h.getWays()) {
                    this.save(w);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(HouseFileReared.Way2 w2) {
        WayWSProxy pWayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
        NodeWSProxy nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
        ArrayList<Node> ll = new ArrayList<Node>();
        ArrayList<Point> lp = new ArrayList<Point>();
        for (Node n : w2.getNodes()) {
            n.setCurrentVersion(Integer.valueOf(1));
            Point p = new Point(n.getLon(), n.getLat());
            p.setSrid(4326);
            n.setGeom(p.toString());
            System.out.println(p.toString());
            Node n2 = nodeWSProxy.save(InitializedVariable.context, n);
            ll.add(n2);
            lp.add(p);
        }
        Way w = new Way();
        w.setNodes(ll.toArray(new Node[0]));
        LineString wg = new LineString(lp.toArray(new Point[0]));
        wg.setSrid(4326);
        w.setGeom(wg.toString());
        System.out.println(wg.toString());
        w.setCurrentVersion(Integer.valueOf(1));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String key : w2.getProperties().keySet()) {
            Tag wt = new Tag();
            wt.setKey(key);
            wt.setValue(w2.getProperties().get(key));
            tags.add(wt);
        }
        w.setTags(tags.toArray(new Tag[0]));
        w = pWayWSProxy.save(InitializedVariable.context, w);
    }

    public static class Imp
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ImportYarHouse h = (ImportYarHouse)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
            h.reload(h.getMif(), h.getMid());
        }

        public String getName() {
            return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u043f\u043e\u0440\u0442";
        }
    }

    public static class Read
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ImportYarHouse h = (ImportYarHouse)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
            h.reloadW();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }

        public String getName() {
            return "\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c way";
        }
    }
}

