/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapsource.rightsownerlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.client.soap.proxy.cartography.MapSourceWSProxy;
import ru.infor.ws.objects.cartography.MapSourceSearchCriteria;
import ru.infor.ws.objects.cartography.entities.MapSource;
import ru.infor.ws.objects.core.SortObject;

public class MapSourceViewer<T>
extends BaseDirectoryViewer<T> {
    private Map<MapSource, String> map = new HashMap<MapSource, String>();

    public Class getTableCellViewerClass() {
        return MapSourceCellViewer.class;
    }

    public MapSourceViewer(UIFactory<T> factory) {
        super(factory);
    }

    public void setKey(String key) {
        key = String.valueOf(this.getContentClass().getName()) + this.getKey();
    }

    protected List<?> getDirectoryItems() {
        if (this.map.size() == 0) {
            MapSourceWSProxy proxy = (MapSourceWSProxy)CurrentProxyFactory.getProxy(MapSource.class, (String)this.getViewerContext().getKeyPage());
            MapSourceSearchCriteria scr = new MapSourceSearchCriteria();
            scr.appendSorting(SortObject.getInstance((String)"name", (String)SortObject.DIRECTION_ASC));
            scr.setCount(Integer.valueOf(Integer.MAX_VALUE));
            MapSourceWSProxy.SearchResultListMapSource sr = proxy.getList(InitializedVariable.getContext((String)this.getViewerContext().getKeyPage()), scr);
            if (!sr.isEmpty()) {
                int i = 0;
                while (i < sr.getObjList().length) {
                    MapSource ms = (MapSource)sr.getObjList()[i];
                    this.map.put(ms, ms.getName());
                    ++i;
                }
            }
        }
        ArrayList<String> listOut = new ArrayList<String>(this.map.values());
        Collections.sort(listOut);
        return listOut;
    }

    public Object getValue() {
        String s = (String)super.getValue();
        for (MapSource i : this.map.keySet()) {
            if (!this.map.get(i).equals(s)) continue;
            return i;
        }
        return null;
    }

    public void setValue(Object object) {
        if (object == null) {
            super.setValue(null);
            return;
        }
        super.setValue((Object)this.map.get(object));
    }

    public static class MapSourceCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public MapSourceCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public Object getValue() {
            return super.getValue();
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((MapSource)object).getName()));
        }
    }
}

