/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class HelpUtils {
    static HashMap<String, Long> mapTimes = new HashMap();
    static Color[] listColor = new Color[]{new Color(255, 0, 0, 255), new Color(0, 0, 255, 255), new Color(255, 255, 0, 255), new Color(255, 0, 255, 100), new Color(0, 255, 255, 100), new Color(0, 0, 0, 100), new Color(127, 255, 0, 100), new Color(0, 255, 0, 255)};

    public static void putToMapTimes(String key) {
        if (mapTimes == null) {
            mapTimes = new HashMap();
        }
        mapTimes.put(key, System.currentTimeMillis());
    }

    public static Long getFromMapTimes(String key) {
        if (mapTimes.get(key) != null) {
            return mapTimes.get(key);
        }
        return null;
    }

    public static void deleteToMapTimes(String key) {
        if (mapTimes.get(key) != null) {
            mapTimes.remove(key);
        }
    }

    public static void eraseMapTimes() {
        if (mapTimes != null) {
            mapTimes.clear();
        }
    }

    public static void showDeltaTime(String key) {
        Long beg = HelpUtils.getFromMapTimes(key);
        if (beg == null) {
            HelpUtils.putToMapTimes(key);
            beg = HelpUtils.getFromMapTimes(key);
        }
        System.out.println("***************    key=" + key + " t=" + (double)(System.currentTimeMillis() - beg) / 1000.0 + " sec");
    }

    public static Double convertString2Double(String val, String fp) {
        String[] mfp;
        if (val == null) {
            return null;
        }
        if (fp == null) {
            return null;
        }
        fp = fp.replaceAll("De", "###0").replaceAll("Mi", "###0").replaceAll("Se", "###0").replaceAll("9", "#");
        String[] mval = val.split(" ");
        if (mval.length != (mfp = fp.split(" ")).length) {
            return null;
        }
        if (mfp.length == 1) {
            try {
                return Double.parseDouble(mval[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (mfp.length == 2) {
            try {
                return Double.parseDouble(mval[0]) + Double.parseDouble(mval[1]) / 60.0;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return Double.parseDouble(mval[0]) + Double.parseDouble(mval[1]) / 60.0 + Double.parseDouble(mval[2]) / 3600.0;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertLatLon(Double d, String fp) {
        if (d == null) {
            return "";
        }
        if (!(d instanceof Double)) {
            return d.toString();
        }
        String[] mf = HelpUtils.partitionTemplate(fp);
        Double de = Math.floor(d);
        Double mi0 = (d - de) * 60.0;
        Double mi = Math.floor(mi0);
        Double se0 = (mi0 - mi) * 60.0;
        String ss = mf[0].replaceAll("De", "###0");
        ss = ss.replaceAll("9", "#");
        DecimalFormat df = new DecimalFormat(ss);
        if (mf.length == 1) {
            return df.format(d);
        }
        String rez = df.format(de).concat("\u00b0").concat(" ");
        ss = mf[1].replaceAll("Mi", "###0");
        ss = ss.replaceAll("9", "#");
        df = new DecimalFormat(ss);
        if (mf.length == 2) {
            rez = rez.concat(df.format(mi0)).concat("'");
            return rez;
        }
        rez = rez.concat(df.format(mi)).concat("' ");
        ss = mf[2].replaceAll("Se", "###0");
        ss = ss.replaceAll("9", "#");
        df = new DecimalFormat(ss);
        rez = rez.concat(df.format(se0)).concat("\"");
        return rez;
    }

    public static String[] partitionTemplate(String fp) {
        ArrayList<String> listF = new ArrayList<String>();
        if (fp.toLowerCase().indexOf("de") < 0) {
            listF.add("De.99");
            return listF.toArray(new String[listF.size()]);
        }
        String de = fp.substring(fp.toLowerCase().indexOf("de"));
        int i1 = de.indexOf(" ");
        if (i1 < 0 && de.length() == fp.length()) {
            listF.add(fp);
            return listF.toArray(new String[listF.size()]);
        }
        if ((de = de.substring(0, i1)).indexOf(".") > 0) {
            listF.add(de.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(de);
        if (fp.toLowerCase().indexOf("mi") < 0) {
            return listF.toArray(new String[listF.size()]);
        }
        String mi = fp.substring(fp.toLowerCase().indexOf("mi"));
        i1 = mi.indexOf(" ");
        if (i1 < 0) {
            listF.add(mi);
            return listF.toArray(new String[listF.size()]);
        }
        if ((mi = mi.substring(0, i1)).indexOf(".") > 0) {
            listF.add(mi.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(mi);
        if (fp.toLowerCase().indexOf("se") < 0) {
            return listF.toArray(new String[listF.size()]);
        }
        String se = fp.substring(fp.toLowerCase().indexOf("se"));
        i1 = se.indexOf(" ");
        if (i1 < 0) {
            listF.add(se);
            return listF.toArray(new String[listF.size()]);
        }
        if ((se = se.substring(0, i1)).indexOf(".") > 0) {
            listF.add(se.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(se);
        return listF.toArray(new String[listF.size()]);
    }

    public static Color getCurrentColor(int currentColorIndex, boolean shortLength) {
        if (shortLength) {
            return listColor[new BigDecimal(currentColorIndex).toBigInteger().mod(new BigDecimal(7).toBigInteger()).intValue()];
        }
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 127;
        int[] zn = nArray;
        if (currentColorIndex > 27) {
            currentColorIndex = 1;
        }
        int a = new BigDecimal(currentColorIndex).toBigInteger().mod(new BigDecimal(3).toBigInteger()).intValue();
        int a3 = (currentColorIndex - a) / 3;
        int b = new BigDecimal(a3).toBigInteger().mod(new BigDecimal(3).toBigInteger()).intValue();
        int c = (a3 - b) / 3;
        return new Color(zn[c], zn[b], zn[a], 127);
    }
}

