/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ru.blok.cartography.mapviewer.painter.IconOnMap;
import ru.blok.cartography.mapviewer.painter.WayViewSettings;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

public class MapValue {
    private double lat;
    private double lon;
    private int zoom;
    private WayViewSettings wayViewSetting = new WayViewSettings();
    private WayViewSettings polygonViewSetting = this.defaultPolygonViewSetting();
    List<IconOnMap> listIcons = new ArrayList<IconOnMap>();
    List<Way> listZone;
    List<Way> listWay;

    public MapValue() {
    }

    public MapValue(double lat, double lon, int zoom) {
        this.lat = lat;
        this.lon = lon;
        this.zoom = zoom;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public List<IconOnMap> getListIcons() {
        return this.listIcons;
    }

    public void addIconOnMap(IconOnMap m) {
        this.listIcons.add(m);
    }

    public void removeIconOnMap(IconOnMap m) {
        this.listIcons.remove(m);
    }

    public void setListIcons(List<IconOnMap> listIcons) {
        this.listIcons = listIcons;
    }

    public void deleteAllIcons() {
        this.listIcons.clear();
    }

    public List<Way> getListZone() {
        return this.listZone;
    }

    public void setListZone(List<Way> listZone) {
        this.listZone = listZone;
    }

    public void setZones(Way[] ways) {
        this.setListZone(this.arrayWayToList(ways));
    }

    public List<Way> getListWay() {
        return this.listWay;
    }

    public void setListWay(List<Way> listWay) {
        this.listWay = listWay;
    }

    public void setWays(Way[] ways) {
        this.setListWay(this.arrayWayToList(ways));
    }

    public List<Way> arrayWayToList(Way[] ways) {
        if (ways == null || ways.length == 0) {
            return null;
        }
        ArrayList<Way> listWay = new ArrayList<Way>();
        int i = 0;
        while (i < ways.length) {
            listWay.add(ways[i]);
            ++i;
        }
        return listWay;
    }

    public WayViewSettings getWayViewSetting() {
        return this.wayViewSetting;
    }

    public void setWayViewSetting(WayViewSettings wayViewSetting) {
        this.wayViewSetting = wayViewSetting;
    }

    public WayViewSettings getPolygonViewSetting() {
        return this.polygonViewSetting;
    }

    public void setPolygonViewSetting(WayViewSettings polygonViewSetting) {
        this.polygonViewSetting = polygonViewSetting;
    }

    public WayViewSettings defaultPolygonViewSetting() {
        WayViewSettings v = new WayViewSettings();
        Color w1 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 70);
        Color w2 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 90);
        v.setColorLine(w2);
        v.setColorPixel(w1);
        return v;
    }

    public Double[] getMinMaxWay() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.getListWay() != null) {
            for (Way w : this.getListWay()) {
                Node[] nodeArray = w.getNodes();
                int n = nodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Node d = nodeArray[n2];
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon == null || d.getLon() > maxLon) {
                        maxLon = d.getLon();
                    }
                    ++n2;
                }
            }
            if (minLat == null) {
                return null;
            }
            return new Double[]{minLat, maxLat, minLon, maxLon};
        }
        return null;
    }
}

