/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer.painter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jxmapviewer.JXMapViewer;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.painter.IconOnMap;
import ru.blok.cartography.mapviewer.painter.MapViewPainter;

public class IconPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValue value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getListIcons() != null) {
            for (IconOnMap m : this.value.getListIcons()) {
                BufferedImage img1;
                int y;
                int x;
                Point2D point = map.getTileFactory().geoToPixel(m.getPoint(), map.getZoom());
                if (vp2.contains(point)) {
                    x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                    y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                    try {
                        img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(m.getImage()));
                        int imwidth = ((Image)img1).getWidth(null);
                        int imheight = ((Image)img1).getHeight(null);
                        g.drawImage((Image)img1, x - imheight, y - imwidth, (ImageObserver)map);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!vp3.contains(point)) continue;
                x = (int)(point.getX() - ((RectangularShape)vp3).getX());
                y = (int)(point.getY() - ((RectangularShape)vp3).getY());
                try {
                    img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(m.getImage()));
                    g.drawImage((Image)img1, x, y, (ImageObserver)map);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setValue(MapValue mapValueWithTrack) {
        this.value = mapValueWithTrack;
    }
}

