/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer.painter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.painter.MapViewPainter;
import ru.blok.cartography.mapviewer.painter.WayViewSettings;
import ru.infor.ws.objects.cartography.entities.Way;

public class PolygonPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValue value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getListZone() != null) {
            for (Way w : this.value.getListZone()) {
                this.paint(w, map, g, vp2, vp3);
            }
        }
    }

    protected void paintPolygon(Way w, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w1, Color w2) {
        Polygon pp = new Polygon();
        int ii = 0;
        while (ii < w.getNodes().length) {
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(w.getNodes()[ii].getLat(), w.getNodes()[ii].getLon()), map.getZoom());
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            pp.addPoint(x, y);
            ++ii;
        }
        g.setColor(w2);
        g.drawPolygon(pp);
        GeneralPath path = new GeneralPath(pp);
        g.setColor(w1);
        g.fill(path);
    }

    protected void paint(Way w, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (w != null && w.getNodes() != null) {
            WayViewSettings v = this.value.getPolygonViewSetting();
            this.paintPolygon(w, map, g, vp2, vp3, v.getColorPixel(), v.getColorLine());
        }
    }

    @Override
    public void setValue(MapValue mapValueWithTrack) {
        this.value = mapValueWithTrack;
    }
}

