/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer.painter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.painter.MapViewPainter;
import ru.blok.cartography.mapviewer.painter.WayViewSettings;
import ru.infor.ws.objects.cartography.entities.Way;

public class WayPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected MapValue value;
    static double accuracyOfPaint = 8.0;

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getListWay() != null) {
            WayViewSettings v = this.value.getWayViewSetting();
            int j = 0;
            while (j < this.value.getListWay().size()) {
                Way w = this.value.getListWay().get(j);
                this.paintTrack(w, map, g, vp2, vp3, v);
                ++j;
            }
        }
    }

    protected void paintTrack(Way w, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, WayViewSettings v) {
        if (w.getNodes() != null && w.getNodes().length > 0) {
            int s = w.getNodes().length;
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(w.getNodes()[from].getLat(), w.getNodes()[from].getLon()), map.getZoom());
            g.setStroke(v.getStroke());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(v.getColorLine());
            int i = 1;
            while (i < s) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(w.getNodes()[i].getLat(), w.getNodes()[i].getLon()), map.getZoom());
                double d = pointFrom.distance(pointTo);
                if (d > accuracyOfPaint) {
                    this.paint(pointFrom, pointTo, map, g, vp2, vp3);
                    from = i;
                    pointFrom = pointTo;
                }
                ++i;
            }
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
        }
    }

    @Override
    public void setValue(MapValue mapValueWithTrack) {
        this.value = mapValueWithTrack;
    }
}

