/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.mapviewer.providertiles;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.util.MercatorUtils;
import ru.blok.cartography.mapviewer.providertiles.ProviderInfo;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.client.soap.proxy.cartography.MapSourceWSProxy;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.cartography.MapSourceSearchCriteria;
import ru.infor.ws.objects.cartography.entities.MapSource;

public class DefaultProvider {
    private static List<ProviderInfo> listPI = null;
    static Logger logger = Logger.getLogger(DefaultProvider.class);
    final int max;
    final int min;
    String baseUrl;
    final String type;
    private String version;
    private String layer;
    private String format;
    private String srs;
    private String styles;
    AbstractTileFactory tf = null;

    public static ProviderInfo getDefaultProviderInfo(String keyPage) {
        if (listPI == null) {
            DefaultProvider.init(keyPage);
        }
        return listPI.get(0);
    }

    public static ProviderInfo getOSMProviderInfo(String keyPage) {
        if (listPI == null) {
            DefaultProvider.init(keyPage);
        }
        if (listPI.size() > 1) {
            return listPI.get(1);
        }
        return listPI.get(0);
    }

    public static void init(String keyPage) {
        MapSourceWSProxy.SearchResultListMapSource srMS = null;
        try {
            MapSourceWSProxy mapSourceWSProxy = (MapSourceWSProxy)CurrentProxyFactory.getProxy(MapSource.class, (String)keyPage);
            srMS = mapSourceWSProxy.getList(InitializedVariable.getContext((String)keyPage), new MapSourceSearchCriteria());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        listPI = new ArrayList<ProviderInfo>();
        if (srMS == null || srMS.isEmpty()) {
            ProviderInfo info = new ProviderInfo(18, 1, "http://tile.openstreetmap.org", "OpenStreetMap", "OpenStreetMap", "OpenStreetMap.org", "http://www.openstreetmap.org/", "\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u0440\u0442\u044b CCBYSA 2010", "http://creativecommons.org/licenses/by-sa/2.0/", null, null, null, null, null, null);
            listPI.add(info);
            listPI.add(DefaultProvider.setDefaultMapSource());
        } else {
            int i = 0;
            while (i < srMS.getObjList().length) {
                MapSource mapSource = (MapSource)srMS.getObjList()[i];
                ProviderInfo info = new ProviderInfo(mapSource.getMaxLevel(), mapSource.getMinLevel(), mapSource.getBaseUrl(), mapSource.getMapType(), mapSource.getDescription(), mapSource.getCopyright(), mapSource.getCopyrightURL(), mapSource.getExtDesc(), mapSource.getExtDescURL(), mapSource.getId(), mapSource.getVersion(), mapSource.getLayer(), mapSource.getFormat(), mapSource.getSrs(), mapSource.getStyles());
                listPI.add(info);
                ++i;
            }
        }
    }

    public static ProviderInfo setDefaultMapSource() {
        int maxLevel = Integer.valueOf(SysProperties.getProperty((String)"mapSource.MaxLevel", (String)"18"));
        int minLevel = Integer.valueOf(SysProperties.getProperty((String)"mapSource.MinLevel", (String)"1"));
        String baseUrl = SysProperties.getProperty((String)"mapSource.BaseUrl", (String)"http://tile.openstreetmap.org");
        String mapType = SysProperties.getProperty((String)"mapSource.MapType", (String)"OpenStreetMap");
        String description = SysProperties.getProperty((String)"mapSource.Description", (String)"OpenStreetMap");
        SysProperties.getProperty((String)"mapSource.Copyright", (String)"OpenStreetMap.org");
        SysProperties.getProperty((String)"mapSource.CopyrightURL", (String)"http://www.openstreetmap.org/");
        SysProperties.getProperty((String)"mapSource.ExtDesc", (String)"Map data CCBYSA 2010");
        SysProperties.getProperty((String)"mapSource.ExtDescURL", (String)"http://creativecommons.org/licenses/by-sa/2.0/");
        ProviderInfo info = new ProviderInfo(maxLevel, minLevel, baseUrl, mapType, description);
        return info;
    }

    public DefaultProvider(ProviderInfo info) {
        this.max = info.getMaxLevel();
        this.min = info.getMinLevel();
        this.baseUrl = info.getBaseUrl();
        this.type = info.getType();
        this.version = info.getVersion();
        this.layer = info.getLayer();
        this.format = info.getFormat();
        this.srs = info.getSrs();
        this.styles = info.getStyles();
    }

    public AbstractTileFactory getTileFactory() {
        TileFactoryInfo info = null;
        if ("OpenStreetMap".equals(this.type) || "OSMARender".equals(this.type) || "TransMonitorMap".equals(this.type)) {
            info = new TileFactoryInfo(this.min, this.max - 2, this.max, 256, true, true, this.baseUrl, "x", "y", "z"){

                public String getTileUrl(int x, int y, int zoom) {
                    zoom = DefaultProvider.this.max - zoom;
                    String url = String.valueOf(this.baseURL) + "/" + zoom + "/" + x + "/" + y + ".png";
                    return url;
                }
            };
        } else if ("MapSurfer".equals(this.type) || "MapSurferTopo".equals(this.type)) {
            info = new TileFactoryInfo(1, 16, 18, 256, true, true, this.baseUrl, "x", "y", "z"){

                public String getTileUrl(int x, int y, int zoom) {
                    zoom = 18 - zoom;
                    String url = String.valueOf(this.baseURL) + "x=" + x + "&y=" + y + "&z=" + zoom;
                    return url;
                }
            };
        } else if ("WMS".equals(this.type)) {
            info = new TileFactoryInfo(this.min, this.max - 2, this.max, 500, true, true, "", "x", "y", "zoom"){

                public String toWMSURL(int x, int y, int zoom, int tileSize) {
                    int ts = tileSize;
                    int circumference = this.widthOfWorldInPixels(zoom, tileSize);
                    double radius = (double)circumference / (Math.PI * 2);
                    double ulx = MercatorUtils.xToLong((int)(x * ts), (double)radius);
                    double uly = MercatorUtils.yToLat((int)(y * ts), (double)radius);
                    double lrx = MercatorUtils.xToLong((int)((x + 1) * ts), (double)radius);
                    double lry = MercatorUtils.yToLat((int)((y + 1) * ts), (double)radius);
                    String bbox = String.valueOf(ulx) + "," + uly + "," + lrx + "," + lry;
                    String url = String.valueOf(DefaultProvider.this.baseUrl) + "version=" + DefaultProvider.this.version + "&request=" + "GetMap&Layers=" + DefaultProvider.this.layer + "&format=" + DefaultProvider.this.format + "&BBOX=" + bbox + "&width=" + ts + "&height=" + ts + "&SRS=" + DefaultProvider.this.srs + "&Styles=" + DefaultProvider.this.styles;
                    return url;
                }

                private int widthOfWorldInPixels(int zoom, int TILE_SIZE) {
                    int tiles = (int)Math.pow(2.0, zoom);
                    int circumference = TILE_SIZE * tiles;
                    return circumference;
                }

                public String getTileUrl(int x, int y, int zoom) {
                    int zz = 17 - zoom;
                    int z = 4;
                    z = (int)Math.pow(2.0, (double)zz - 1.0);
                    return this.toWMSURL(x - z, z - 1 - y, zz, this.getTileSize(zoom));
                }
            };
        } else if ("Gorizont".equals(this.type)) {
            info = new TileFactoryInfo(this.min, this.max - 2, this.max, 256, true, true, this.baseUrl, "x", "y", "z"){

                public String getTileUrl(int x, int y, int zoom) {
                    zoom = DefaultProvider.this.max - zoom;
                    y = (int)(Math.pow(2.0, zoom) / 2.0 - 1.0 - (double)y);
                    String u1 = "";
                    if (DefaultProvider.this.baseUrl.lastIndexOf("/") != DefaultProvider.this.baseUrl.length() - 1) {
                        u1 = "/";
                    }
                    String url = String.valueOf(this.baseURL) + u1 + zoom + "/" + x + "/" + y + ".png";
                    return url;
                }
            };
        }
        this.tf = new DefaultTileFactory(info);
        return this.tf;
    }

    public String getUriZoom(int zoom) {
        if (this.tf == null) {
            this.tf = this.getTileFactory();
        }
        zoom = this.max - zoom;
        String url = String.valueOf(this.baseUrl) + "/" + zoom;
        return url;
    }

    public static class AbstractDefaultProvidersViewer<T>
    extends BaseDirectoryViewer<T> {
        public AbstractDefaultProvidersViewer(UIFactory<T> factory) {
            super(factory);
        }

        protected List<?> getDirectoryItems() {
            if (this.getViewerContext() != null && listPI == null) {
                DefaultProvider.init(this.getViewerContext().getKeyPage());
            }
            return listPI;
        }

        public void setViewerContext(ViewerContext viewerContext) {
            super.setViewerContext(viewerContext);
            if (this.getViewerContext() != null && listPI == null) {
                DefaultProvider.init(this.getViewerContext().getKeyPage());
            }
        }
    }
}

