/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.protectionzones;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import ru.blok.cartography.josm.GeometryDataSet;
import ru.blok.cartography.josm.JosmMainApp;
import ru.blok.cartography.protectionzones.BuferDialogRiver;
import ru.infor.ws.objects.cartography.MapEntryKeyFilter;
import ru.infor.ws.objects.cartography.entities.MapEntryKeyValue;
import ru.infor.ws.objects.cartography.entities.Way;

public class JosmMain2
extends JosmMainApp {
    public JosmMain2(JFrame mainFrame, String keyPage) {
        super(mainFrame, keyPage);
    }

    @Override
    protected void initMenu(JMenu sysmenu, String keyPage) {
        JMenuItem mi2 = new JMenuItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c\u043e\u0439 \u0437\u043e\u043d\u044b");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GeometryDataSet)ds).save();
            }
        });
        sysmenu.add(mi2);
        mi2 = new JMenuItem("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0432\u043e\u0434\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEntryKeyValue mekv = new MapEntryKeyValue();
                mekv.setKey("water");
                mekv.setValue("river");
                MapEntryKeyFilter mek = new MapEntryKeyFilter();
                mek.setValues(new MapEntryKeyValue[]{mekv});
                ((GeometryDataSet)ds).addToMapObjectByTag(mek, JosmMain2.this);
            }
        });
        sysmenu.add(mi2);
        mi2 = new JMenuItem("\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u043e\u0434\u043e\u043e\u0445\u0440\u0430\u043d\u043d\u0443\u044e \u043e\u0431\u043b\u0430\u0441\u0442\u044c");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Collection ww;
                OsmDataLayer l = (OsmDataLayer)Main.map.mapView.getActiveLayer();
                if (l != null && (ww = l.data.getSelectedWays()) != null && ww.size() > 0) {
                    GeometryFactory f = new GeometryFactory();
                    try {
                        Double z;
                        Geometry buffer;
                        CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
                        CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
                        MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                        MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
                        org.openstreetmap.josm.data.osm.Way w = (org.openstreetmap.josm.data.osm.Way)ww.iterator().next();
                        Coordinate[] cc = new Coordinate[w.getNodesCount()];
                        int i = 0;
                        while (i < w.getNodesCount()) {
                            GeneralDirectPosition pt1 = new GeneralDirectPosition(w.getNode(i).getCoor().lon(), w.getNode(i).getCoor().lat());
                            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                            cc[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                            ++i;
                        }
                        LineString s = f.createLineString(cc);
                        double ll = s.getLength() / 2.0;
                        BuferDialogRiver dlg = new BuferDialogRiver(ll);
                        ExtendedDialog d = new ExtendedDialog(Main.parent, "\u0414\u0430\u043d\u043d\u044b\u0435", new String[]{I18n.tr((String)"Apply", (Object[])new Object[]{""}), I18n.tr((String)"Cancel", (Object[])new Object[]{""})});
                        d.setContent((Component)dlg);
                        d.showDialog();
                        int answer = d.getValue();
                        if (answer == 1 && (OsmDataLayer)Main.map.mapView.getActiveLayer() != null && (buffer = s.buffer((z = dlg.getThickness()).doubleValue())) instanceof Polygon) {
                            Polygon p = (Polygon)buffer;
                            org.openstreetmap.josm.data.osm.Way w2 = new org.openstreetmap.josm.data.osm.Way();
                            int i2 = 0;
                            while (i2 < p.getCoordinates().length - 1) {
                                Coordinate c = p.getCoordinates()[i2];
                                GeneralDirectPosition pt1 = new GeneralDirectPosition(c.x, c.y);
                                DirectPosition pt2 = math2.transform((DirectPosition)pt1, null);
                                Node n = new Node(new LatLon(pt2.getCoordinate()[1], pt2.getCoordinate()[0]));
                                l.data.addPrimitive((OsmPrimitive)n);
                                w2.addNode(n);
                                ++i2;
                            }
                            w2.addNode(w2.getNode(0));
                            l.data.addPrimitive((OsmPrimitive)w2);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        sysmenu.add(mi2);
        super.initMenu(sysmenu, keyPage);
    }

    public static void init(JFrame m, Way w, String keyPage) {
        JosmMain2.initCommon(m);
        main_josm = new JosmMain2(m, keyPage);
        JosmMain2.initFinal(m);
        JosmMain2.initLayer(w, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c\u043e\u0439 \u0437\u043e\u043d\u044b", keyPage);
    }
}

