/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.protectionzones.enterzonepoint;

import java.util.ArrayList;
import java.util.List;
import ru.blok.cartography.coordinatemanager.CoordinateManager;
import ru.blok.cartography.coordinatemanager.CoordinateTransformParametersDirectoryViewer;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.cartography.protectionzones.enterzonepoint.MapValuePoint;
import ru.blok.cartography.protectionzones.enterzonepoint.MapViewerPoint;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.RemoverButton;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.BaseDirectoryViewer;
import ru.infor.client.soap.proxy.cartography.CoordinateTransformParametersWSProxy;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.CoordinateTransformParameters;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;

@ListView(views={@View(title="\u0412\u0432\u043e\u0434 \u0437\u043e\u043d\u044b \u043f\u043e \u043f\u043e\u0432\u043e\u0440\u043e\u0442\u043d\u044b\u043c \u0442\u043e\u0447\u043a\u0430\u043c", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class EnterZonePoint {
    static List<ZoneType> listZones = new ArrayList<ZoneType>();
    CoordinateTransformParameters coordinateTransformParameters;
    CoordinateTransformParametersWSProxy proxy = (CoordinateTransformParametersWSProxy)CurrentProxyFactory.getProxy(CoordinateTransformParameters.class);
    double x;
    double y;
    CoordinateManager m = new CoordinateManager();
    Double[] kf = null;
    AddNode addNode = new AddNode();
    List<Node> nodes = new ArrayList<Node>();
    MapValuePoint valuePoint;
    ZoneType zoneType;
    static WayWSProxy wayWSProxy;
    static NodeWSProxy nodeWSProxy;
    BtSave btSave = new BtSave();

    static {
        listZones.add(new ZoneType("\u0412\u043e\u0434\u043e\u043e\u0445\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u043e\u043d\u044b", new String[][]{{"protection_zone", "river"}, {"name", "\u0412\u043e\u0434\u043e\u043e\u0445\u0440\u0430\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430"}}));
        listZones.add(new ZoneType("\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0431\u0435\u0440\u0435\u0433\u043e\u0443\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u044f", new String[][]{{"protection_zone", "shore"}, {"name", "\u041e\u0431\u044a\u0435\u043a\u0442 \u0431\u0435\u0440\u0435\u0433\u043e\u0443\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u044f"}}));
        listZones.add(new ZoneType("\u041f\u043e\u0434\u043f\u043e\u0440\u044b \u0432\u043e\u0434\u043d\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", new String[][]{{"protection_zone", "support"}, {"name", "\u041f\u043e\u0434\u043f\u043e\u0440\u0430 \u0432\u043e\u0434\u043d\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432"}}));
        wayWSProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
        nodeWSProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    }

    public EnterZonePoint() {
        Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.workplaceId);
        this.valuePoint = new MapValuePoint(coord[0], coord[1], coord[2].intValue());
        this.valuePoint.setZonePoint(this);
    }

    @ListField(fields={@Field(title="C\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442", order=10, propertiesLayout="Scroll1:Split1/h/l/0.3:m1/wrap 2", viewer={CoordinateTransformParametersDirectoryViewer.class})})
    public CoordinateTransformParameters getCoordinateTransformParameters() {
        return this.coordinateTransformParameters;
    }

    public void setCoordinateTransformParameters(CoordinateTransformParameters coordinateTransformParameters) {
        this.coordinateTransformParameters = coordinateTransformParameters;
        if (coordinateTransformParameters != null) {
            this.coordinateTransformParameters = this.proxy.getCurrentObject(InitializedVariable.context, coordinateTransformParameters.getId());
        }
    }

    @ListField(fields={@Field(title="X", order=11, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:m///spanx")})
    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    @ListField(fields={@Field(title="Y", order=12, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:m")})
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double[] getCoord(double x, double y) {
        if (this.coordinateTransformParameters == null) {
            return new double[]{y, x};
        }
        double[] d = this.m.transformMSKtoWGS(new double[]{x, y}, this.coordinateTransformParameters);
        return d;
    }

    public void addNode() {
        Node n = new Node();
        n.setSourceX(this.getX());
        n.setSourceY(this.getY());
        double[] dd = this.getCoord(this.getX(), this.getY());
        n.setLat(dd[0]);
        n.setLon(dd[1]);
        this.nodes.add(n);
    }

    @ListField(fields={@Field(title="", order=14, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:m", viewer={ActionButton.class})})
    public AddNode getAddNode() {
        return this.addNode;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0442\u043e\u0447\u0435\u043a", order=20, propertiesLayout="Scroll1:Split1/h/l/0.3:m1#wrap, spanx 2#wrap, spanx 2", viewer={ListViewer.class}, propertiesField={"keycontentview=nodeinzone"}, content=Node.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=btDown.class), @ActionField(clazz=btUp.class), @ActionField(clazz=RemoverButton.class)})})})
    public List<Node> getNodes() {
        return this.nodes;
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewerPoint.class}, propertiesLayout="Scroll1:Split1/h/r/0.2:Scroll1:Split1/v/l/0.8")})
    public MapValuePoint getValuePoint() {
        return this.valuePoint;
    }

    public void setValuePoint(MapValuePoint valuePoint) {
        this.valuePoint = valuePoint;
    }

    @ListField(fields={@Field(title="\u0422\u0438\u043f \u0437\u043e\u043d\u044b", order=30, propertiesLayout="Scroll1:Split1/h/l/0.3:m1", viewer={ZoneTypeViewer.class})})
    public ZoneType getZoneType() {
        return this.zoneType;
    }

    public void setZoneType(ZoneType zoneType) {
        this.zoneType = zoneType;
    }

    @ListField(fields={@Field(title="", order=50, propertiesLayout="Scroll1:Split1/h/l/0.3:m1#spanx 2#wrap", viewer={ActionButton.class})})
    public BtSave getBtSave() {
        return this.btSave;
    }

    public static class AddNode
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            ((EnterZonePoint)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject()).addNode();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("nodes");
            ((MapViewerPoint)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("valuePoint").getViewer()).positionOnWay();
        }

        public String getName() {
            return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u0447\u043a\u0443";
        }
    }

    public static class BtSave
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            EnterZonePoint ezp = (EnterZonePoint)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
            if (ezp.getZoneType() == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u0437\u043e\u043d\u044b"), new BeanViewerAction[]{new MessageOKButton()});
            } else if (ezp.getNodes().size() < 2) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u0434\u0432\u0435 \u0442\u043e\u0447\u043a\u0438"), new BeanViewerAction[]{new MessageOKButton()});
            } else {
                ArrayList<Long> nIds = new ArrayList<Long>();
                int i = 0;
                while (i < ezp.getNodes().size()) {
                    Node n = ezp.getNodes().get(i);
                    n.setCurrentVersion(Integer.valueOf(1));
                    n = nodeWSProxy.save(InitializedVariable.context, n);
                    nIds.add(n.getId());
                    ezp.getNodes().set(i, n);
                    ++i;
                }
                nodeWSProxy.rebuildGeomList(InitializedVariable.context, nIds.toArray(new Long[0]));
                Way w = new Way();
                w.setNodes(ezp.getNodes().toArray(new Node[0]));
                ezp.getZoneType().setDefaultTagToWay(w);
                w.setCurrentVersion(Integer.valueOf(1));
                w = wayWSProxy.save(InitializedVariable.context, w);
                wayWSProxy.rebuildGeom(InitializedVariable.context, w.getId());
            }
        }

        public String getName() {
            return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c";
        }
    }

    public static class ZoneType {
        private String name;
        private String[][] tags;

        public ZoneType(String name, String[][] tags) {
            this.name = name;
            this.tags = tags;
        }

        public void setDefaultTagToWay(Way way) {
            int n;
            int n2;
            Tag[] tagArray;
            ArrayList<Tag> ts = new ArrayList<Tag>();
            if (way.getTags() != null) {
                tagArray = way.getTags();
                n2 = tagArray.length;
                n = 0;
                while (n < n2) {
                    Tag t = tagArray[n];
                    ts.add(t);
                    ++n;
                }
            }
            tagArray = this.tags;
            n2 = this.tags.length;
            n = 0;
            while (n < n2) {
                Tag tt = tagArray[n];
                Tag t = new Tag();
                t.setKey((String)tt[0]);
                t.setValue((String)tt[1]);
                ts.add(t);
                ++n;
            }
            way.setTags(ts.toArray(new Tag[0]));
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ZoneTypeViewer<T>
    extends BaseDirectoryViewer<T> {
        public ZoneTypeViewer(UIFactory<T> factory) {
            super(factory);
        }

        protected List<?> getDirectoryItems() {
            return listZones;
        }
    }

    public static class btDown
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            int[] s = ((ListViewer)((ViewerContext)this.getContext()).getPresentator().getViewer()).getTM().getSelectedRows();
            if (s != null && s.length > 0) {
                EnterZonePoint p = (EnterZonePoint)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
                int i = s[0];
                int k = this.moveNode(i, p.getNodes());
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
                ((ListViewer)((ViewerContext)this.getContext()).getPresentator().getViewer()).getTM().setSelectedRows(new int[]{k});
            }
        }

        public int moveNode(int i, List<Node> nodes) {
            if (i < nodes.size() - 1) {
                Node n = nodes.get(i);
                Node n2 = nodes.get(i + 1);
                nodes.set(i, n2);
                nodes.set(i + 1, n);
                return i + 1;
            }
            return i;
        }

        public boolean isNotEnableWithEmptySelection() {
            return true;
        }

        public String getIcon() {
            return ResourceStrings.btArrowDown;
        }
    }

    public static class btUp
    extends btDown {
        @Override
        public int moveNode(int i, List<Node> nodes) {
            if (i > 0) {
                Node n = nodes.get(i);
                Node n2 = nodes.get(i - 1);
                nodes.set(i, n2);
                nodes.set(i - 1, n);
                return i - 1;
            }
            return i;
        }

        @Override
        public String getIcon() {
            return ResourceStrings.btArrowUp;
        }
    }
}

