/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.protectionzones.enterzonepoint;

import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.protectionzones.enterzonepoint.EnterZonePoint;
import ru.infor.ws.objects.cartography.entities.Node;

public class MapValuePoint
extends MapValue {
    public EnterZonePoint zonePoint;

    public EnterZonePoint getZonePoint() {
        return this.zonePoint;
    }

    public void setZonePoint(EnterZonePoint zonePoint) {
        this.zonePoint = zonePoint;
    }

    public MapValuePoint(double lat, double lon, int zoom) {
        super(lat, lon, zoom);
    }

    @Override
    public Double[] getMinMaxWay() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.zonePoint != null) {
            for (Node d : this.zonePoint.getNodes()) {
                if (minLat == null || d.getLat() < minLat) {
                    minLat = d.getLat();
                }
                if (maxLat == null || d.getLat() > maxLat) {
                    maxLat = d.getLat();
                }
                if (minLon == null || d.getLon() < minLon) {
                    minLon = d.getLon();
                }
                if (maxLon != null && !(d.getLon() > maxLon)) continue;
                maxLon = d.getLon();
            }
            if (minLat == null) {
                return null;
            }
            return new Double[]{minLat, maxLat, minLon, maxLon};
        }
        return null;
    }
}

