/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.protectionzones.enterzonepoint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.painter.MapViewPainter;
import ru.blok.cartography.protectionzones.enterzonepoint.MapValuePoint;
import ru.infor.ws.objects.cartography.entities.Node;

public class NodePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValuePoint valuePoint;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.valuePoint != null && this.valuePoint.zonePoint.getNodes() != null && this.valuePoint.zonePoint.getNodes().size() > 0) {
            int from = 0;
            List<Node> nn = this.valuePoint.zonePoint.getNodes();
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(nn.get(from).getLat(), nn.get(from).getLon()), map.getZoom());
            g.setColor(Color.red);
            this.paintPoint(pointFrom, map, g, vp2, vp3);
            int i = 1;
            while (i < nn.size()) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(nn.get(i).getLat(), nn.get(i).getLon()), map.getZoom());
                this.paint(pointFrom, pointTo, map, g, vp2, vp3);
                from = i++;
                pointFrom = pointTo;
                this.paintPoint(pointFrom, map, g, vp2, vp3);
            }
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
        }
    }

    protected void paintPoint(Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(point)) {
            g.fillRect((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), 3, 3);
        }
        if (vp3.contains(point) || vp3.contains(point)) {
            g.fillRect((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), 3, 3);
        }
    }

    @Override
    public void setValue(MapValue mapValueWithTrack) {
        this.valuePoint = (MapValuePoint)mapValueWithTrack;
    }
}

